/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.IngresSubstringFunction;
import org.hibernate.dialect.function.LocateEmulationUsingPositionAndSubstring;
import org.hibernate.dialect.pagination.FirstLimitHandler;
import org.hibernate.dialect.pagination.LegacyFirstLimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.naming.Identifier;
import org.hibernate.query.sqm.mutation.spi.SqmMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.idtable.GlobalTempTableExporter;
import org.hibernate.query.sqm.mutation.spi.idtable.GlobalTemporaryTableStrategy;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTable;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableSupport;
import org.hibernate.query.sqm.mutation.spi.idtable.StandardIdTableSupport;
import org.hibernate.query.sqm.produce.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.produce.function.spi.FunctionAsExpressionTemplate;
import org.hibernate.tool.schema.extract.internal.SequenceNameExtractorImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.type.spi.StandardSpiBasicTypes;

public class IngresDialect
extends Dialect {
    public IngresDialect() {
        this.registerColumnType(-7, "tinyint");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(4, "integer");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(7, "real");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "float");
        this.registerColumnType(2, "decimal($p, $s)");
        this.registerColumnType(3, "decimal($p, $s)");
        this.registerColumnType(-2, 32000L, "byte($l)");
        this.registerColumnType(-2, "long byte");
        this.registerColumnType(-3, 32000L, "varbyte($l)");
        this.registerColumnType(-3, "long byte");
        this.registerColumnType(-4, "long byte");
        this.registerColumnType(1, 32000L, "char($l)");
        this.registerColumnType(12, 32000L, "varchar($l)");
        this.registerColumnType(12, "long varchar");
        this.registerColumnType(-1, "long varchar");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time with time zone");
        this.registerColumnType(93, "timestamp with time zone");
        this.registerColumnType(2004, "blob");
        this.registerColumnType(2005, "clob");
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_get_generated_keys", "false");
        this.getDefaultProperties().setProperty("hibernate.query.substitutions", "true=1,false=0");
    }

    @Override
    public void initializeFunctionRegistry(SqmFunctionRegistry registry) {
        super.initializeFunctionRegistry(registry);
        registry.registerPattern("bit_length", "octet_length(hex(?1))*4", StandardSpiBasicTypes.INTEGER);
        registry.register("concat", new FunctionAsExpressionTemplate("(", "+", ")", StandardFunctionReturnTypeResolvers.invariant(StandardSpiBasicTypes.STRING)));
        registry.namedTemplateBuilder("day").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.INTEGER).register();
        registry.namedTemplateBuilder("hour").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.INTEGER).register();
        registry.registerPattern("extract", "date_part('?1', ?2)", StandardSpiBasicTypes.INTEGER);
        registry.register("locate", new LocateEmulationUsingPositionAndSubstring((reg, type, arguments) -> reg.findFunctionTemplate("substring").makeSqmFunctionExpression(arguments, type)));
        registry.namedTemplateBuilder("minute").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.INTEGER).register();
        registry.namedTemplateBuilder("month").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.INTEGER).register();
        registry.namedTemplateBuilder("second").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.INTEGER).register();
        registry.register("substring", IngresSubstringFunction.INSTANCE);
        registry.namedTemplateBuilder("year").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.INTEGER).register();
        registry.registerPattern("str", "cast(?1 as varchar)", StandardSpiBasicTypes.STRING);
        CommonFunctionFactory.atan(registry);
        CommonFunctionFactory.cos(registry);
        CommonFunctionFactory.exp(registry);
        CommonFunctionFactory.ln(registry);
        CommonFunctionFactory.log(registry);
        CommonFunctionFactory.position(registry);
        CommonFunctionFactory.sin(registry);
        CommonFunctionFactory.soundex(registry);
        registry.noArgsBuilder("current_user").setInvariantType(StandardSpiBasicTypes.STRING).register();
        registry.noArgsBuilder("dba").setInvariantType(StandardSpiBasicTypes.STRING).setUseParenthesesWhenNoArgs(true).register();
        registry.registerNoArgs("gmt_timestamp", StandardSpiBasicTypes.STRING);
        registry.registerNoArgs("initial_user", StandardSpiBasicTypes.STRING);
        registry.registerNoArgs("session_user", StandardSpiBasicTypes.STRING);
        registry.registerNoArgs("system_user", StandardSpiBasicTypes.STRING);
        registry.registerNoArgs("user", StandardSpiBasicTypes.STRING);
        registry.noArgsBuilder("usercode").setInvariantType(StandardSpiBasicTypes.STRING).setUseParenthesesWhenNoArgs(true).register();
        registry.noArgsBuilder("username").setInvariantType(StandardSpiBasicTypes.STRING).setUseParenthesesWhenNoArgs(true).register();
        registry.noArgsBuilder("uuid_create").setUseParenthesesWhenNoArgs(true).setInvariantType(StandardSpiBasicTypes.BYTE);
        registry.namedTemplateBuilder("uuid_compare").setExactArgumentCount(2).setInvariantType(StandardSpiBasicTypes.INTEGER).register();
        registry.namedTemplateBuilder("uuid_from_char").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.BYTE).register();
        registry.namedTemplateBuilder("uuid_to_char").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.STRING).register();
        registry.namedTemplateBuilder("bit_and").setExactArgumentCount(2).register();
        registry.namedTemplateBuilder("bit_add").setExactArgumentCount(2).register();
        registry.namedTemplateBuilder("bit_or").setExactArgumentCount(2).register();
        registry.namedTemplateBuilder("bit_xor").setExactArgumentCount(2).register();
        registry.namedTemplateBuilder("bit_not").setExactArgumentCount(1).register();
        registry.registerAlternateKey("character_length", "length");
        registry.namedTemplateBuilder("charextract").setExactArgumentCount(2).setInvariantType(StandardSpiBasicTypes.STRING).register();
        registry.registerAlternateKey("lowercase", "lower");
        registry.registerAlternateKey("uppercase", "upper");
        registry.namedTemplateBuilder("date_trunc").setInvariantType(StandardSpiBasicTypes.TIMESTAMP).register();
        registry.namedTemplateBuilder("dow").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.STRING).register();
        registry.namedTemplateBuilder("power").setExactArgumentCount(2).setInvariantType(StandardSpiBasicTypes.DOUBLE).register();
        registry.noArgsBuilder("random").setUseParenthesesWhenNoArgs(true).setInvariantType(StandardSpiBasicTypes.LONG).register();
        registry.noArgsBuilder("randomf").setUseParenthesesWhenNoArgs(true).setInvariantType(StandardSpiBasicTypes.DOUBLE).register();
        registry.registerNamed("hash", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("hex", StandardSpiBasicTypes.STRING);
        registry.registerNamed("intextract", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("left", StandardSpiBasicTypes.STRING);
        registry.registerNamed("octet_length", StandardSpiBasicTypes.LONG);
        registry.registerNamed("pad", StandardSpiBasicTypes.STRING);
        registry.registerNamed("right", StandardSpiBasicTypes.STRING);
        registry.namedTemplateBuilder("size").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.LONG).register();
        registry.registerNamed("squeeze");
        registry.registerNamed("unhex", StandardSpiBasicTypes.STRING);
    }

    @Override
    public String getSelectGUIDString() {
        return "select uuid_to_char(uuid_create())";
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public String getAddColumnString() {
        return "add column";
    }

    @Override
    public String getNullColumnString() {
        return " with null";
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public String getSequenceNextValString(String sequenceName) {
        return "select nextval for " + sequenceName;
    }

    @Override
    public String getSelectSequenceNextValString(String sequenceName) {
        return sequenceName + ".nextval";
    }

    @Override
    public String getCreateSequenceString(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    @Override
    public String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName + " restrict";
    }

    @Override
    public String getQuerySequencesString() {
        return "select seq_name from iisequence";
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceNameExtractorImpl.INSTANCE;
    }

    @Override
    public String getLowercaseFunction() {
        return "lowercase";
    }

    @Override
    public LimitHandler getLimitHandler() {
        if (this.isLegacyLimitHandlerBehaviorEnabled()) {
            return LegacyFirstLimitHandler.INSTANCE;
        }
        return this.getDefaultLimitHandler();
    }

    protected LimitHandler getDefaultLimitHandler() {
        return FirstLimitHandler.INSTANCE;
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsLimitOffset() {
        return false;
    }

    @Override
    public String getLimitString(String querySelect, int offset, int limit) {
        if (offset > 0) {
            throw new UnsupportedOperationException("query result offset is not supported");
        }
        return new StringBuilder(querySelect.length() + 16).append(querySelect).insert(6, " first " + limit).toString();
    }

    @Override
    public boolean supportsVariableLimit() {
        return false;
    }

    @Override
    public boolean useMaxForLimit() {
        return true;
    }

    @Override
    public SqmMutationStrategy getDefaultIdTableStrategy() {
        return new GlobalTemporaryTableStrategy(this.generateIdTableSupport());
    }

    private IdTableSupport generateIdTableSupport() {
        return new StandardIdTableSupport(this.generateIdTableExporter()){

            @Override
            protected Identifier determineIdTableName(Identifier baseName) {
                return new Identifier("session." + super.determineIdTableName(baseName).getText(), false);
            }
        };
    }

    private Exporter<IdTable> generateIdTableExporter() {
        return new GlobalTempTableExporter(){

            @Override
            public String getCreateCommand() {
                return "declare global temporary table";
            }

            @Override
            public String getCreateOptions() {
                return "on commit preserve rows with norecovery";
            }
        };
    }

    @Override
    public String getCurrentTimestampSQLFunctionName() {
        return "date(now)";
    }

    @Override
    public boolean supportsSubselectAsInPredicateLHS() {
        return false;
    }

    @Override
    public boolean supportsEmptyInList() {
        return false;
    }

    @Override
    public boolean supportsExpectedLobUsagePattern() {
        return false;
    }

    @Override
    public boolean supportsTupleDistinctCounts() {
        return false;
    }
}

