/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.identity.MimerSQLIdentityColumnSupport;
import org.hibernate.query.sqm.produce.function.SqmFunctionRegistry;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorMimerSQLDatabaseImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.spi.StandardSpiBasicTypes;

public class MimerSQLDialect
extends Dialect {
    private static final int NATIONAL_CHAR_LENGTH = 2000;
    private static final int BINARY_MAX_LENGTH = 2000;

    public MimerSQLDialect() {
        this.registerColumnType(-7, "ODBC.BIT");
        this.registerColumnType(-5, "BIGINT");
        this.registerColumnType(5, "SMALLINT");
        this.registerColumnType(-6, "ODBC.TINYINT");
        this.registerColumnType(4, "INTEGER");
        this.registerColumnType(1, "NCHAR(1)");
        this.registerColumnType(12, 2000L, "NATIONAL CHARACTER VARYING($l)");
        this.registerColumnType(12, "NCLOB($l)");
        this.registerColumnType(-1, "CLOB($1)");
        this.registerColumnType(6, "FLOAT");
        this.registerColumnType(8, "DOUBLE PRECISION");
        this.registerColumnType(91, "DATE");
        this.registerColumnType(92, "TIME");
        this.registerColumnType(93, "TIMESTAMP");
        this.registerColumnType(-3, 2000L, "BINARY VARYING($l)");
        this.registerColumnType(-3, "BLOB($1)");
        this.registerColumnType(-4, "BLOB($1)");
        this.registerColumnType(-2, 2000L, "BINARY");
        this.registerColumnType(-2, "BLOB($1)");
        this.registerColumnType(2, "NUMERIC(19, $l)");
        this.registerColumnType(2004, "BLOB($l)");
        this.registerColumnType(2005, "NCLOB($l)");
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_streams_for_binary", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "50");
    }

    @Override
    public void initializeFunctionRegistry(SqmFunctionRegistry registry) {
        super.initializeFunctionRegistry(registry);
        registry.registerNamed("abs");
        registry.registerNamed("sign", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("ceiling");
        registry.registerNamed("floor");
        registry.registerNamed("round");
        registry.registerNamed("dacos", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("acos", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("dasin", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("asin", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("datan", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("atan", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("datan2", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("atan2", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("dcos", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("cos", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("dcot", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("cot", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("ddegrees", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("degrees", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("dexp", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("exp", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("dlog", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("log", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("dlog10", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("log10", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("dradian", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("radian", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("dsin", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("sin", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("soundex", StandardSpiBasicTypes.STRING);
        registry.registerNamed("dsqrt", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("sqrt", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("dtan", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("tan", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("dpower");
        registry.registerNamed("power");
        registry.registerNamed("date", StandardSpiBasicTypes.DATE);
        registry.registerNamed("dayofweek", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("dayofyear", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("time", StandardSpiBasicTypes.TIME);
        registry.registerNamed("timestamp", StandardSpiBasicTypes.TIMESTAMP);
        registry.registerNamed("week", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("varchar", StandardSpiBasicTypes.STRING);
        registry.registerNamed("real", StandardSpiBasicTypes.FLOAT);
        registry.registerNamed("bigint", StandardSpiBasicTypes.LONG);
        registry.registerNamed("char", StandardSpiBasicTypes.CHARACTER);
        registry.registerNamed("integer", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("smallint", StandardSpiBasicTypes.SHORT);
        registry.registerNamed("ascii_char", StandardSpiBasicTypes.CHARACTER);
        registry.registerNamed("ascii_code", StandardSpiBasicTypes.STRING);
        registry.registerNamed("unicode_char", StandardSpiBasicTypes.LONG);
        registry.registerNamed("unicode_code", StandardSpiBasicTypes.STRING);
        registry.registerNamed("upper");
        registry.registerNamed("lower");
        registry.registerNamed("char_length", StandardSpiBasicTypes.LONG);
        registry.registerNamed("bit_length", StandardSpiBasicTypes.STRING);
    }

    @Override
    public String getAddColumnString() {
        return "add column";
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public String getSequenceNextValString(String sequenceName) {
        return "select next_value of " + sequenceName + " from system.onerow";
    }

    @Override
    public String getCreateSequenceString(String sequenceName) {
        return "create unique sequence " + sequenceName;
    }

    @Override
    public String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName + " restrict";
    }

    @Override
    public boolean supportsLimit() {
        return false;
    }

    @Override
    public String getCascadeConstraintsString() {
        return " cascade";
    }

    @Override
    public String getQuerySequencesString() {
        return "select * from information_schema.ext_sequences";
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceInformationExtractorMimerSQLDatabaseImpl.INSTANCE;
    }

    @Override
    public boolean forUpdateOfColumns() {
        return false;
    }

    @Override
    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return new MimerSQLIdentityColumnSupport();
    }
}

