/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.JDBCException;
import org.hibernate.NullPrecedence;
import org.hibernate.PessimisticLockException;
import org.hibernate.cfg.Environment;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.InnoDBStorageEngine;
import org.hibernate.dialect.MyISAMStorageEngine;
import org.hibernate.dialect.MySQLStorageEngine;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.identity.MySQLIdentityColumnSupport;
import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitHelper;
import org.hibernate.dialect.unique.MySQLUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.query.sqm.mutation.spi.SqmMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTable;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableSupport;
import org.hibernate.query.sqm.mutation.spi.idtable.LocalTempTableExporter;
import org.hibernate.query.sqm.mutation.spi.idtable.LocalTemporaryTableStrategy;
import org.hibernate.query.sqm.mutation.spi.idtable.StandardIdTableSupport;
import org.hibernate.query.sqm.produce.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.produce.function.spi.ConcatFunctionTemplate;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.type.spi.StandardSpiBasicTypes;

public class MySQLDialect
extends Dialect {
    private final UniqueDelegate uniqueDelegate;
    private MySQLStorageEngine storageEngine;
    private static final LimitHandler LIMIT_HANDLER = new AbstractLimitHandler(){

        @Override
        public String processSql(String sql, RowSelection selection) {
            boolean hasOffset = LimitHelper.hasFirstRow(selection);
            return sql + (hasOffset ? " limit ?, ?" : " limit ?");
        }

        @Override
        public boolean supportsLimit() {
            return true;
        }
    };

    public MySQLDialect() {
        String storageEngine = Environment.getProperties().getProperty("hibernate.dialect.storage_engine");
        if (storageEngine == null) {
            storageEngine = System.getProperty("hibernate.dialect.storage_engine");
        }
        if (storageEngine == null) {
            this.storageEngine = this.getDefaultMySQLStorageEngine();
        } else if ("innodb".equals(storageEngine.toLowerCase())) {
            this.storageEngine = InnoDBStorageEngine.INSTANCE;
        } else if ("myisam".equals(storageEngine.toLowerCase())) {
            this.storageEngine = MyISAMStorageEngine.INSTANCE;
        } else {
            throw new UnsupportedOperationException("The " + storageEngine + " storage engine is not supported!");
        }
        this.registerColumnType(-7, "bit");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(4, "integer");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double precision");
        this.registerColumnType(16, "bit");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "datetime");
        this.registerColumnType(-3, "longblob");
        this.registerColumnType(-3, 0xFFFFFFL, "mediumblob");
        this.registerColumnType(-3, 65535L, "blob");
        this.registerColumnType(-3, 255L, "tinyblob");
        this.registerColumnType(-2, "binary($l)");
        this.registerColumnType(-4, "longblob");
        this.registerColumnType(-4, 0xFFFFFFL, "mediumblob");
        this.registerColumnType(2, "decimal($p,$s)");
        this.registerColumnType(2004, "longblob");
        this.registerColumnType(2005, "longtext");
        this.registerColumnType(2011, "longtext");
        this.registerVarcharTypes();
        this.getDefaultProperties().setProperty("hibernate.max_fetch_depth", "2");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
        this.uniqueDelegate = new MySQLUniqueDelegate(this);
    }

    @Override
    public void initializeFunctionRegistry(SqmFunctionRegistry registry) {
        super.initializeFunctionRegistry(registry);
        registry.namedTemplateBuilder("ascii").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("bin").setInvariantType(StandardSpiBasicTypes.STRING).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("char_length").setInvariantType(StandardSpiBasicTypes.LONG).setExactArgumentCount(1).register();
        registry.registerAlternateKey("character_length", "char_length");
        registry.register("concat", new ConcatFunctionTemplate("concat(", ", ", ")"));
        CommonFunctionFactory.lower(registry);
        registry.registerAlternateKey("lcase", "lower");
        registry.namedTemplateBuilder("ltrim").setInvariantType(StandardSpiBasicTypes.STRING).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("ord").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("quote").setInvariantType(StandardSpiBasicTypes.STRING).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("reverse").setInvariantType(StandardSpiBasicTypes.STRING).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("rtrim").setInvariantType(StandardSpiBasicTypes.STRING).setExactArgumentCount(1).register();
        CommonFunctionFactory.soundex(registry);
        registry.namedTemplateBuilder("space").setInvariantType(StandardSpiBasicTypes.STRING).setExactArgumentCount(1).register();
        CommonFunctionFactory.upper(registry);
        registry.registerAlternateKey("ucase", "upper");
        registry.namedTemplateBuilder("unhex").setInvariantType(StandardSpiBasicTypes.STRING).setExactArgumentCount(1).register();
        CommonFunctionFactory.abs(registry);
        CommonFunctionFactory.sign(registry);
        CommonFunctionFactory.acos(registry);
        CommonFunctionFactory.asin(registry);
        CommonFunctionFactory.atan(registry);
        CommonFunctionFactory.atan(registry);
        CommonFunctionFactory.cos(registry);
        CommonFunctionFactory.cot(registry);
        registry.namedTemplateBuilder("crc32").setInvariantType(StandardSpiBasicTypes.LONG).setExactArgumentCount(1).register();
        CommonFunctionFactory.exp(registry);
        CommonFunctionFactory.ln(registry);
        CommonFunctionFactory.log(registry);
        registry.namedTemplateBuilder("log2").setInvariantType(StandardSpiBasicTypes.DOUBLE).setExactArgumentCount(1).register();
        CommonFunctionFactory.log10(registry);
        registry.registerNoArgs("pi", StandardSpiBasicTypes.DOUBLE);
        registry.registerNoArgs("rand", StandardSpiBasicTypes.DOUBLE);
        CommonFunctionFactory.sin(registry);
        CommonFunctionFactory.sqrt(registry);
        CommonFunctionFactory.tan(registry);
        registry.namedTemplateBuilder("stddev", "std").setInvariantType(StandardSpiBasicTypes.DOUBLE).setExactArgumentCount(1).register();
        CommonFunctionFactory.radians(registry);
        CommonFunctionFactory.degrees(registry);
        CommonFunctionFactory.ceiling(registry);
        CommonFunctionFactory.ceil(registry);
        CommonFunctionFactory.floor(registry);
        CommonFunctionFactory.round(registry);
        registry.namedTemplateBuilder("datediff").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(2).register();
        registry.namedTemplateBuilder("timediff").setInvariantType(StandardSpiBasicTypes.TIME).setExactArgumentCount(2).register();
        registry.namedTemplateBuilder("date_format").setInvariantType(StandardSpiBasicTypes.STRING).setExactArgumentCount(2).register();
        registry.registerNoArgs("curdate", StandardSpiBasicTypes.DATE);
        registry.registerNoArgs("curtime", StandardSpiBasicTypes.TIME);
        registry.registerNoArgs("current_date", StandardSpiBasicTypes.DATE);
        registry.registerNoArgs("current_time", StandardSpiBasicTypes.TIME);
        registry.registerNoArgs("current_timestamp", StandardSpiBasicTypes.TIMESTAMP);
        registry.namedTemplateBuilder("date").setInvariantType(StandardSpiBasicTypes.DATE).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("day").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("dayofmonth").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("dayname").setInvariantType(StandardSpiBasicTypes.STRING).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("dayofweek").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("dayofyear").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("from_days").setInvariantType(StandardSpiBasicTypes.DATE).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("from_unixtime").setInvariantType(StandardSpiBasicTypes.TIMESTAMP).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("hour").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("last_day").setInvariantType(StandardSpiBasicTypes.DATE).setExactArgumentCount(1).register();
        registry.registerNoArgs("localtime", StandardSpiBasicTypes.TIMESTAMP);
        registry.registerNoArgs("localtimestamp", StandardSpiBasicTypes.TIMESTAMP);
        registry.namedTemplateBuilder("microseconds").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("minute").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("month").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("monthname").setInvariantType(StandardSpiBasicTypes.STRING).setExactArgumentCount(1).register();
        registry.registerNoArgs("now", StandardSpiBasicTypes.TIMESTAMP);
        registry.namedTemplateBuilder("quarter").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("second").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("sec_to_time").setInvariantType(StandardSpiBasicTypes.TIME).setExactArgumentCount(1).register();
        registry.registerNoArgs("sysdate", StandardSpiBasicTypes.TIMESTAMP);
        registry.namedTemplateBuilder("time").setInvariantType(StandardSpiBasicTypes.TIME).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("timestamp").setInvariantType(StandardSpiBasicTypes.TIMESTAMP).setArgumentCountBetween(1, 2).register();
        registry.namedTemplateBuilder("time_to_sec").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("to_days").setInvariantType(StandardSpiBasicTypes.LONG).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("unix_timestamp").setInvariantType(StandardSpiBasicTypes.LONG).setArgumentCountBetween(0, 1).setUseParenthesesWhenNoArgs(true).register();
        registry.registerNoArgs("utc_date", StandardSpiBasicTypes.STRING);
        registry.registerNoArgs("utc_time", StandardSpiBasicTypes.STRING);
        registry.registerNoArgs("utc_timestamp", StandardSpiBasicTypes.STRING);
        registry.namedTemplateBuilder("week").setInvariantType(StandardSpiBasicTypes.INTEGER).setArgumentCountBetween(1, 2).register();
        registry.namedTemplateBuilder("weekday").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("weekofyear").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("year").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("yearweek").setInvariantType(StandardSpiBasicTypes.INTEGER).setArgumentCountBetween(1, 2).register();
        registry.namedTemplateBuilder("hex").setInvariantType(StandardSpiBasicTypes.STRING).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("oct").setInvariantType(StandardSpiBasicTypes.STRING).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("octet_length").setInvariantType(StandardSpiBasicTypes.LONG).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("bit_length").setInvariantType(StandardSpiBasicTypes.LONG).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("bit_count").setInvariantType(StandardSpiBasicTypes.LONG).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("encrypt").setInvariantType(StandardSpiBasicTypes.STRING).setArgumentCountBetween(1, 2).register();
        registry.namedTemplateBuilder("md5").setInvariantType(StandardSpiBasicTypes.STRING).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("sha1").setInvariantType(StandardSpiBasicTypes.STRING).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("sha").setInvariantType(StandardSpiBasicTypes.STRING).setExactArgumentCount(1).register();
    }

    protected void registerVarcharTypes() {
        this.registerColumnType(12, "longtext");
        this.registerColumnType(12, 255L, "varchar($l)");
        this.registerColumnType(-1, "longtext");
    }

    @Override
    public String getAddColumnString() {
        return "add column";
    }

    @Override
    public boolean qualifyIndexName() {
        return false;
    }

    @Override
    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        String cols = String.join((CharSequence)", ", foreignKey);
        String referencedCols = String.join((CharSequence)", ", primaryKey);
        return String.format(" add constraint %s foreign key (%s) references %s (%s)", constraintName, cols, referencedTable, referencedCols);
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public String getDropForeignKeyString() {
        return " drop foreign key ";
    }

    @Override
    public LimitHandler getLimitHandler() {
        return LIMIT_HANDLER;
    }

    @Override
    public String getLimitString(String sql, boolean hasOffset) {
        return sql + (hasOffset ? " limit ?, ?" : " limit ?");
    }

    @Override
    public char closeQuote() {
        return '`';
    }

    @Override
    public char openQuote() {
        return '`';
    }

    @Override
    public boolean canCreateCatalog() {
        return true;
    }

    @Override
    public String[] getCreateCatalogCommand(String catalogName) {
        return new String[]{"create database " + catalogName};
    }

    @Override
    public String[] getDropCatalogCommand(String catalogName) {
        return new String[]{"drop database " + catalogName};
    }

    @Override
    public boolean canCreateSchema() {
        return false;
    }

    @Override
    public String[] getCreateSchemaCommand(String schemaName) {
        throw new UnsupportedOperationException("MySQL does not support dropping creating/dropping schemas in the JDBC sense");
    }

    @Override
    public String[] getDropSchemaCommand(String schemaName) {
        throw new UnsupportedOperationException("MySQL does not support dropping creating/dropping schemas in the JDBC sense");
    }

    @Override
    public boolean supportsIfExistsBeforeTableName() {
        return true;
    }

    @Override
    public String getSelectGUIDString() {
        return "select uuid()";
    }

    @Override
    public String getTableComment(String comment) {
        return " comment='" + comment + "'";
    }

    @Override
    public String getColumnComment(String comment) {
        return " comment '" + comment + "'";
    }

    @Override
    public SqmMutationStrategy getDefaultIdTableStrategy() {
        return new LocalTemporaryTableStrategy(this.generateIdTableSupport());
    }

    private IdTableSupport generateIdTableSupport() {
        return new StandardIdTableSupport(this.generateIdTableExporter());
    }

    private Exporter<IdTable> generateIdTableExporter() {
        return new LocalTempTableExporter(){

            @Override
            public String getCreateCommand() {
                return "create temporary table if not exists";
            }

            @Override
            public String getDropCommand() {
                return "drop temporary table";
            }
        };
    }

    @Override
    public String getCastTypeName(int code) {
        switch (code) {
            case 16: {
                return "char";
            }
            case -5: 
            case 4: 
            case 5: {
                return this.smallIntegerCastTarget();
            }
            case 6: 
            case 7: {
                return this.floatingPointNumberCastTarget();
            }
            case 2: {
                return this.fixedPointNumberCastTarget();
            }
            case 12: {
                return "char";
            }
            case -3: {
                return "binary";
            }
        }
        return super.getCastTypeName(code);
    }

    protected String smallIntegerCastTarget() {
        return "signed";
    }

    protected String floatingPointNumberCastTarget() {
        return this.fixedPointNumberCastTarget();
    }

    protected String fixedPointNumberCastTarget() {
        return "decimal(19,2)";
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select now()";
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        return col;
    }

    @Override
    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        boolean isResultSet = ps.execute();
        while (!isResultSet && ps.getUpdateCount() != -1) {
            isResultSet = ps.getMoreResults();
        }
        return ps.getResultSet();
    }

    @Override
    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    @Override
    public boolean supportsRowValueConstructorSyntax() {
        return true;
    }

    @Override
    public String renderOrderByElement(String expression, String collation, String order, NullPrecedence nulls) {
        StringBuilder orderByElement = new StringBuilder();
        if (nulls != NullPrecedence.NONE) {
            orderByElement.append("case when ").append(expression).append(" is null then ");
            if (nulls == NullPrecedence.FIRST) {
                orderByElement.append("0 else 1");
            } else {
                orderByElement.append("1 else 0");
            }
            orderByElement.append(" end, ");
        }
        orderByElement.append(super.renderOrderByElement(expression, collation, order, NullPrecedence.NONE));
        return orderByElement.toString();
    }

    @Override
    public String getForUpdateString() {
        return " for update";
    }

    @Override
    public String getWriteLockString(int timeout) {
        return " for update";
    }

    @Override
    public String getReadLockString(int timeout) {
        return " lock in share mode";
    }

    @Override
    public boolean supportsEmptyInList() {
        return false;
    }

    @Override
    public boolean areStringComparisonsCaseInsensitive() {
        return true;
    }

    @Override
    public boolean supportsLobValueChangePropogation() {
        return false;
    }

    @Override
    public boolean supportsSubqueryOnMutatingTable() {
        return false;
    }

    @Override
    public boolean supportsLockTimeouts() {
        return false;
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return new SQLExceptionConversionDelegate(){

            @Override
            public JDBCException convert(SQLException sqlException, String message, String sql) {
                switch (sqlException.getErrorCode()) {
                    case 1205: {
                        return new PessimisticLockException(message, sqlException, sql);
                    }
                    case 1206: 
                    case 1207: {
                        return new LockAcquisitionException(message, sqlException, sql);
                    }
                }
                String sqlState = JdbcExceptionHelper.extractSqlState(sqlException);
                if ("41000".equals(sqlState)) {
                    return new LockTimeoutException(message, sqlException, sql);
                }
                if ("40001".equals(sqlState)) {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                return null;
            }
        };
    }

    @Override
    public String getNotExpression(String expression) {
        return "not (" + expression + ")";
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return new MySQLIdentityColumnSupport();
    }

    @Override
    public boolean isJdbcLogWarningsEnabledByDefault() {
        return false;
    }

    @Override
    public boolean supportsCascadeDelete() {
        return this.storageEngine.supportsCascadeDelete();
    }

    @Override
    public String getTableTypeString() {
        return this.storageEngine.getTableTypeString(this.getEngineKeyword());
    }

    protected String getEngineKeyword() {
        return "type";
    }

    @Override
    public boolean hasSelfReferentialForeignKeyBug() {
        return this.storageEngine.hasSelfReferentialForeignKeyBug();
    }

    @Override
    public boolean dropConstraints() {
        return this.storageEngine.dropConstraints();
    }

    protected MySQLStorageEngine getDefaultMySQLStorageEngine() {
        return MyISAMStorageEngine.INSTANCE;
    }

    @Override
    protected String escapeLiteral(String literal) {
        return super.escapeLiteral(literal).replace("\\", "\\\\");
    }
}

