/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.JDBCException;
import org.hibernate.QueryTimeoutException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.OracleTypesHelper;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.NvlFunctionTemplate;
import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitHelper;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtracter;
import org.hibernate.exception.spi.ViolatedConstraintNameExtracter;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.naming.Identifier;
import org.hibernate.procedure.internal.StandardCallableStatementSupport;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.sqm.mutation.spi.SqmMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.idtable.GlobalTempTableExporter;
import org.hibernate.query.sqm.mutation.spi.idtable.GlobalTemporaryTableStrategy;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTable;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableSupport;
import org.hibernate.query.sqm.mutation.spi.idtable.StandardIdTableSupport;
import org.hibernate.query.sqm.produce.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.produce.function.spi.ConcatFunctionTemplate;
import org.hibernate.sql.CaseFragment;
import org.hibernate.sql.DecodeCaseFragment;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.OracleJoinFragment;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorOracleDatabaseImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.type.descriptor.sql.spi.BitSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.spi.StandardSpiBasicTypes;

public class Oracle8iDialect
extends Dialect {
    private static final Pattern DISTINCT_KEYWORD_PATTERN = Pattern.compile("\\bdistinct\\b");
    private static final Pattern GROUP_BY_KEYWORD_PATTERN = Pattern.compile("\\bgroup\\sby\\b");
    private static final Pattern ORDER_BY_KEYWORD_PATTERN = Pattern.compile("\\border\\sby\\b");
    private static final Pattern UNION_KEYWORD_PATTERN = Pattern.compile("\\bunion\\b");
    private static final Pattern SQL_STATEMENT_TYPE_PATTERN = Pattern.compile("^(?:\\/\\*.*?\\*\\/)?\\s*(select|insert|update|delete)\\s+.*?");
    private static final AbstractLimitHandler LIMIT_HANDLER = new AbstractLimitHandler(){

        @Override
        public String processSql(String sql, RowSelection selection) {
            boolean hasOffset = LimitHelper.hasFirstRow(selection);
            sql = sql.trim();
            boolean isForUpdate = false;
            if (sql.toLowerCase(Locale.ROOT).endsWith(" for update")) {
                sql = sql.substring(0, sql.length() - 11);
                isForUpdate = true;
            }
            StringBuilder pagingSelect = new StringBuilder(sql.length() + 100);
            if (hasOffset) {
                pagingSelect.append("select * from ( select row_.*, rownum rownum_ from ( ");
            } else {
                pagingSelect.append("select * from ( ");
            }
            pagingSelect.append(sql);
            if (hasOffset) {
                pagingSelect.append(" ) row_ ) where rownum_ <= ? and rownum_ > ?");
            } else {
                pagingSelect.append(" ) where rownum <= ?");
            }
            if (isForUpdate) {
                pagingSelect.append(" for update");
            }
            return pagingSelect.toString();
        }

        @Override
        public boolean supportsLimit() {
            return true;
        }

        @Override
        public boolean bindLimitParametersInReverseOrder() {
            return true;
        }

        @Override
        public boolean useMaxForLimit() {
            return true;
        }
    };
    private static final int PARAM_LIST_SIZE_LIMIT = 1000;
    private static final ViolatedConstraintNameExtracter EXTRACTER = new TemplatedViolatedConstraintNameExtracter(){

        @Override
        protected String doExtractConstraintName(SQLException sqle) throws NumberFormatException {
            int errorCode = JdbcExceptionHelper.extractErrorCode(sqle);
            if (errorCode == 1 || errorCode == 2291 || errorCode == 2292) {
                return this.extractUsingTemplate("(", ")", sqle.getMessage());
            }
            if (errorCode == 1400) {
                return null;
            }
            return null;
        }
    };

    public Oracle8iDialect() {
        this.registerCharacterTypeMappings();
        this.registerNumericTypeMappings();
        this.registerDateTimeTypeMappings();
        this.registerLargeObjectTypeMappings();
        this.registerReverseHibernateTypeMappings();
        this.registerDefaultProperties();
    }

    @Override
    public void initializeFunctionRegistry(SqmFunctionRegistry registry) {
        super.initializeFunctionRegistry(registry);
        CommonFunctionFactory.abs(registry);
        CommonFunctionFactory.sign(registry);
        CommonFunctionFactory.acos(registry);
        CommonFunctionFactory.asin(registry);
        CommonFunctionFactory.atan(registry);
        CommonFunctionFactory.cos(registry);
        CommonFunctionFactory.cosh(registry);
        CommonFunctionFactory.exp(registry);
        CommonFunctionFactory.ln(registry);
        CommonFunctionFactory.sin(registry);
        CommonFunctionFactory.sinh(registry);
        CommonFunctionFactory.stddev(registry);
        CommonFunctionFactory.sqrt(registry);
        CommonFunctionFactory.tan(registry);
        CommonFunctionFactory.tanh(registry);
        CommonFunctionFactory.variance(registry);
        registry.namedTemplateBuilder("bitand").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(2).register();
        CommonFunctionFactory.round(registry);
        CommonFunctionFactory.trunc(registry);
        CommonFunctionFactory.ceil(registry);
        CommonFunctionFactory.floor(registry);
        registry.namedTemplateBuilder("chr").setInvariantType(StandardSpiBasicTypes.CHARACTER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("initcap").setInvariantType(StandardSpiBasicTypes.STRING).setExactArgumentCount(1).register();
        CommonFunctionFactory.lower(registry);
        registry.namedTemplateBuilder("ltrim").setInvariantType(StandardSpiBasicTypes.STRING).setArgumentCountBetween(1, 2).register();
        registry.namedTemplateBuilder("rtrim").setInvariantType(StandardSpiBasicTypes.STRING).setArgumentCountBetween(1, 2).register();
        CommonFunctionFactory.soundex(registry);
        CommonFunctionFactory.upper(registry);
        registry.namedTemplateBuilder("ascii").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("to_char").setInvariantType(StandardSpiBasicTypes.STRING).setArgumentCountBetween(1, 3).register();
        registry.namedTemplateBuilder("to_date").setInvariantType(StandardSpiBasicTypes.TIMESTAMP).setArgumentCountBetween(1, 3).register();
        registry.registerNoArgs("current_date", StandardSpiBasicTypes.DATE);
        registry.registerNoArgs("current_time", StandardSpiBasicTypes.TIME);
        registry.namedTemplateBuilder("current_timestamp").setInvariantType(StandardSpiBasicTypes.TIMESTAMP).setArgumentCountBetween(0, 1).register();
        registry.namedTemplateBuilder("last_day").setInvariantType(StandardSpiBasicTypes.DATE).setExactArgumentCount(1).register();
        registry.registerNoArgs("sysdate", StandardSpiBasicTypes.DATE);
        registry.registerNoArgs("systimestamp", StandardSpiBasicTypes.TIMESTAMP);
        registry.registerNoArgs("uid", StandardSpiBasicTypes.INTEGER);
        registry.registerNoArgs("user", StandardSpiBasicTypes.STRING);
        registry.registerNoArgs("rowid", StandardSpiBasicTypes.LONG);
        registry.registerNoArgs("rownum", StandardSpiBasicTypes.LONG);
        registry.register("concat", new ConcatFunctionTemplate("", "||", ""));
        registry.namedTemplateBuilder("instr").setInvariantType(StandardSpiBasicTypes.INTEGER).setArgumentCountBetween(2, 4).register();
        registry.namedTemplateBuilder("instrb").setInvariantType(StandardSpiBasicTypes.INTEGER).setArgumentCountBetween(2, 4).register();
        registry.namedTemplateBuilder("lpad").setInvariantType(StandardSpiBasicTypes.STRING).setArgumentCountBetween(2, 3).register();
        registry.namedTemplateBuilder("replace").setInvariantType(StandardSpiBasicTypes.STRING).setArgumentCountBetween(2, 3).register();
        registry.namedTemplateBuilder("rpad").setInvariantType(StandardSpiBasicTypes.STRING).setArgumentCountBetween(2, 3).register();
        registry.namedTemplateBuilder("substr").setInvariantType(StandardSpiBasicTypes.STRING).setArgumentCountBetween(2, 3).register();
        registry.namedTemplateBuilder("substrb").setInvariantType(StandardSpiBasicTypes.STRING).setArgumentCountBetween(2, 3).register();
        registry.namedTemplateBuilder("translate").setInvariantType(StandardSpiBasicTypes.STRING).setExactArgumentCount(3).register();
        registry.registerAlternateKey("substring", "substr");
        registry.registerPattern("locate", "instr(?2,?1)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("bit_length", "vsize(?1)*8", StandardSpiBasicTypes.INTEGER);
        registry.register("coalesce", new NvlFunctionTemplate());
        registry.namedTemplateBuilder("atan2").setInvariantType(StandardSpiBasicTypes.FLOAT).setExactArgumentCount(2).register();
        CommonFunctionFactory.log(registry);
        CommonFunctionFactory.mod(registry);
        registry.namedTemplateBuilder("nvl").setExactArgumentCount(2).register();
        registry.namedTemplateBuilder("nvl2").setExactArgumentCount(3).register();
        registry.namedTemplateBuilder("power").setInvariantType(StandardSpiBasicTypes.FLOAT).setExactArgumentCount(2).register();
        registry.namedTemplateBuilder("add_months").setInvariantType(StandardSpiBasicTypes.DATE).setExactArgumentCount(2).register();
        registry.namedTemplateBuilder("months_between").setInvariantType(StandardSpiBasicTypes.FLOAT).setExactArgumentCount(2).register();
        registry.namedTemplateBuilder("next_day").setInvariantType(StandardSpiBasicTypes.DATE).setExactArgumentCount(2).register();
        registry.registerAlternateKey("str", "to_char");
    }

    protected void registerCharacterTypeMappings() {
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, 4000L, "varchar2($l)");
        this.registerColumnType(12, "long");
    }

    protected void registerNumericTypeMappings() {
        this.registerColumnType(-7, "number(1,0)");
        this.registerColumnType(-5, "number(19,0)");
        this.registerColumnType(5, "number(5,0)");
        this.registerColumnType(-6, "number(3,0)");
        this.registerColumnType(4, "number(10,0)");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double precision");
        this.registerColumnType(2, "number($p,$s)");
        this.registerColumnType(3, "number($p,$s)");
        this.registerColumnType(16, "number(1,0)");
    }

    protected void registerDateTimeTypeMappings() {
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "date");
        this.registerColumnType(93, "date");
    }

    protected void registerLargeObjectTypeMappings() {
        this.registerColumnType(-2, 2000L, "raw($l)");
        this.registerColumnType(-2, "long raw");
        this.registerColumnType(-3, 2000L, "raw($l)");
        this.registerColumnType(-3, "long raw");
        this.registerColumnType(2004, "blob");
        this.registerColumnType(2005, "clob");
        this.registerColumnType(-1, "long");
        this.registerColumnType(-4, "long raw");
    }

    protected void registerReverseHibernateTypeMappings() {
    }

    protected void registerDefaultProperties() {
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_streams_for_binary", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_get_generated_keys", "false");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_versioned_data", "false");
    }

    @Override
    protected SqlTypeDescriptor getSqlTypeDescriptorOverride(int sqlCode) {
        return sqlCode == 16 ? BitSqlDescriptor.INSTANCE : super.getSqlTypeDescriptorOverride(sqlCode);
    }

    @Override
    public JoinFragment createOuterJoinFragment() {
        return new OracleJoinFragment();
    }

    @Override
    public String getCrossJoinSeparator() {
        return ", ";
    }

    @Override
    public CaseFragment createCaseFragment() {
        return new DecodeCaseFragment();
    }

    @Override
    public LimitHandler getLimitHandler() {
        return LIMIT_HANDLER;
    }

    @Override
    public String getLimitString(String sql, boolean hasOffset) {
        sql = sql.trim();
        boolean isForUpdate = false;
        if (sql.toLowerCase(Locale.ROOT).endsWith(" for update")) {
            sql = sql.substring(0, sql.length() - 11);
            isForUpdate = true;
        }
        StringBuilder pagingSelect = new StringBuilder(sql.length() + 100);
        if (hasOffset) {
            pagingSelect.append("select * from ( select row_.*, rownum rownum_ from ( ");
        } else {
            pagingSelect.append("select * from ( ");
        }
        pagingSelect.append(sql);
        if (hasOffset) {
            pagingSelect.append(" ) row_ ) where rownum_ <= ? and rownum_ > ?");
        } else {
            pagingSelect.append(" ) where rownum <= ?");
        }
        if (isForUpdate) {
            pagingSelect.append(" for update");
        }
        return pagingSelect.toString();
    }

    public String getBasicSelectClauseNullString(int sqlType) {
        return super.getSelectClauseNullString(sqlType);
    }

    @Override
    public String getSelectClauseNullString(int sqlType) {
        switch (sqlType) {
            case 1: 
            case 12: {
                return "to_char(null)";
            }
            case 91: 
            case 92: 
            case 93: {
                return "to_date(null)";
            }
        }
        return "to_number(null)";
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select sysdate from dual";
    }

    @Override
    public String getCurrentTimestampSQLFunctionName() {
        return "sysdate";
    }

    @Override
    public String getAddColumnString() {
        return "add";
    }

    @Override
    public String getSequenceNextValString(String sequenceName) {
        return "select " + this.getSelectSequenceNextValString(sequenceName) + " from dual";
    }

    @Override
    public String getSelectSequenceNextValString(String sequenceName) {
        return sequenceName + ".nextval";
    }

    @Override
    public String getCreateSequenceString(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    @Override
    protected String getCreateSequenceString(String sequenceName, int initialValue, int incrementSize) {
        if (initialValue < 0 && incrementSize > 0) {
            return String.format("%s minvalue %d start with %d increment by %d", this.getCreateSequenceString(sequenceName), initialValue, initialValue, incrementSize);
        }
        if (initialValue > 0 && incrementSize < 0) {
            return String.format("%s maxvalue %d start with %d increment by %d", this.getCreateSequenceString(sequenceName), initialValue, initialValue, incrementSize);
        }
        return String.format("%s start with %d increment by  %d", this.getCreateSequenceString(sequenceName), initialValue, incrementSize);
    }

    @Override
    public String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName;
    }

    @Override
    public String getCascadeConstraintsString() {
        return " cascade constraints";
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public String getForUpdateNowaitString() {
        return " for update nowait";
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public boolean supportsPooledSequences() {
        return true;
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public String getForUpdateString(String aliases) {
        return this.getForUpdateString() + " of " + aliases;
    }

    @Override
    public String getForUpdateNowaitString(String aliases) {
        return this.getForUpdateString() + " of " + aliases + " nowait";
    }

    @Override
    public boolean bindLimitParametersInReverseOrder() {
        return true;
    }

    @Override
    public boolean useMaxForLimit() {
        return true;
    }

    @Override
    public boolean forUpdateOfColumns() {
        return true;
    }

    @Override
    public String getQuerySequencesString() {
        return "select * from all_sequences";
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceInformationExtractorOracleDatabaseImpl.INSTANCE;
    }

    @Override
    public String getSelectGUIDString() {
        return "select rawtohex(sys_guid()) from dual";
    }

    @Override
    public ViolatedConstraintNameExtracter getViolatedConstraintNameExtracter() {
        return EXTRACTER;
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return new SQLExceptionConversionDelegate(){

            @Override
            public JDBCException convert(SQLException sqlException, String message, String sql) {
                int errorCode = JdbcExceptionHelper.extractErrorCode(sqlException);
                if (errorCode == 30006) {
                    throw new LockTimeoutException(message, sqlException, sql);
                }
                if (errorCode == 54) {
                    throw new LockTimeoutException(message, sqlException, sql);
                }
                if (4021 == errorCode) {
                    throw new LockTimeoutException(message, sqlException, sql);
                }
                if (60 == errorCode) {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                if (4020 == errorCode) {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                if (1013 == errorCode) {
                    throw new QueryTimeoutException(message, sqlException, sql);
                }
                if (1407 == errorCode) {
                    String constraintName = Oracle8iDialect.this.getViolatedConstraintNameExtracter().extractConstraintName(sqlException);
                    return new ConstraintViolationException(message, sqlException, sql, constraintName);
                }
                return null;
            }
        };
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        statement.registerOutParameter(col, OracleTypesHelper.INSTANCE.getOracleCursorTypeSqlType());
        return ++col;
    }

    @Override
    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        ps.execute();
        return (ResultSet)ps.getObject(1);
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean supportsCommentOn() {
        return true;
    }

    @Override
    public SqmMutationStrategy getDefaultIdTableStrategy() {
        return new GlobalTemporaryTableStrategy(this.generateIdTableSupport());
    }

    private IdTableSupport generateIdTableSupport() {
        return new StandardIdTableSupport(this.generateIdTableExporter()){

            @Override
            protected Identifier determineIdTableName(Identifier baseName) {
                Identifier name = super.determineIdTableName(baseName);
                return name.getText().length() > 30 ? new Identifier(name.getText().substring(0, 30), false) : name;
            }
        };
    }

    private Exporter<IdTable> generateIdTableExporter() {
        return new GlobalTempTableExporter(){

            @Override
            protected String getCreateOptions() {
                return "on commit delete rows";
            }
        };
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public boolean supportsEmptyInList() {
        return false;
    }

    @Override
    public boolean supportsExistsInSelect() {
        return false;
    }

    @Override
    public int getInExpressionCountLimit() {
        return 1000;
    }

    @Override
    public boolean forceLobAsLastValue() {
        return true;
    }

    @Override
    public boolean isEmptyStringTreatedAsNull() {
        return true;
    }

    @Override
    public boolean useFollowOnLocking(String sql, QueryOptions queryOptions) {
        if (StringHelper.isEmpty(sql) || queryOptions == null) {
            return true;
        }
        return DISTINCT_KEYWORD_PATTERN.matcher(sql = sql.toLowerCase(Locale.ROOT)).find() || GROUP_BY_KEYWORD_PATTERN.matcher(sql).find() || UNION_KEYWORD_PATTERN.matcher(sql).find() || queryOptions.hasLimit() && (ORDER_BY_KEYWORD_PATTERN.matcher(sql).find() || queryOptions.getLimit().getFirstRow() != null);
    }

    @Override
    public String getNotExpression(String expression) {
        return "not (" + expression + ")";
    }

    @Override
    public String getQueryHintString(String sql, String hints) {
        String statementType = this.statementType(sql);
        int pos = sql.indexOf(statementType);
        if (pos > -1) {
            StringBuilder buffer = new StringBuilder(sql.length() + hints.length() + 8);
            if (pos > 0) {
                buffer.append(sql.substring(0, pos));
            }
            buffer.append(statementType).append(" /*+ ").append(hints).append(" */").append(sql.substring(pos + statementType.length()));
            sql = buffer.toString();
        }
        return sql;
    }

    @Override
    public int getMaxAliasLength() {
        return 20;
    }

    @Override
    public CallableStatementSupport getCallableStatementSupport() {
        return StandardCallableStatementSupport.REF_CURSOR_INSTANCE;
    }

    @Override
    public boolean canCreateSchema() {
        return false;
    }

    @Override
    public String getCurrentSchemaCommand() {
        return "SELECT SYS_CONTEXT('USERENV', 'CURRENT_SCHEMA') FROM DUAL";
    }

    @Override
    public boolean supportsPartitionBy() {
        return true;
    }

    protected String statementType(String sql) {
        Matcher matcher = SQL_STATEMENT_TYPE_PATTERN.matcher(sql);
        if (matcher.matches() && matcher.groupCount() == 1) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException("Can't determine SQL statement type for statement: " + sql);
    }

    @Override
    public boolean supportsNoWait() {
        return true;
    }
}

