/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.OracleTypesHelper;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.NvlFunctionTemplate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtracter;
import org.hibernate.exception.spi.ViolatedConstraintNameExtracter;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.naming.Identifier;
import org.hibernate.query.sqm.mutation.spi.SqmMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.idtable.GlobalTempTableExporter;
import org.hibernate.query.sqm.mutation.spi.idtable.GlobalTemporaryTableStrategy;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTable;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableSupport;
import org.hibernate.query.sqm.mutation.spi.idtable.StandardIdTableSupport;
import org.hibernate.query.sqm.produce.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.produce.function.spi.ConcatFunctionTemplate;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorOracleDatabaseImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.type.spi.StandardSpiBasicTypes;
import org.jboss.logging.Logger;

@Deprecated
public class Oracle9Dialect
extends Dialect {
    private static final int PARAM_LIST_SIZE_LIMIT = 1000;
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)Oracle9Dialect.class.getName());
    private static final ViolatedConstraintNameExtracter EXTRACTER = new TemplatedViolatedConstraintNameExtracter(){

        @Override
        protected String doExtractConstraintName(SQLException sqle) throws NumberFormatException {
            int errorCode = JdbcExceptionHelper.extractErrorCode(sqle);
            if (errorCode == 1 || errorCode == 2291 || errorCode == 2292) {
                return this.extractUsingTemplate("constraint (", ") violated", sqle.getMessage());
            }
            if (errorCode == 1400) {
                return null;
            }
            return null;
        }
    };

    public Oracle9Dialect() {
        LOG.deprecatedOracle9Dialect();
        this.registerColumnType(-7, "number(1,0)");
        this.registerColumnType(-5, "number(19,0)");
        this.registerColumnType(5, "number(5,0)");
        this.registerColumnType(-6, "number(3,0)");
        this.registerColumnType(4, "number(10,0)");
        this.registerColumnType(1, "char(1 char)");
        this.registerColumnType(12, 4000L, "varchar2($l char)");
        this.registerColumnType(12, "long");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double precision");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "date");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(-3, 2000L, "raw($l)");
        this.registerColumnType(-3, "long raw");
        this.registerColumnType(2, "number($p,$s)");
        this.registerColumnType(3, "number($p,$s)");
        this.registerColumnType(2004, "blob");
        this.registerColumnType(2005, "clob");
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_get_generated_keys", "false");
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_streams_for_binary", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_versioned_data", "false");
    }

    @Override
    public void initializeFunctionRegistry(SqmFunctionRegistry registry) {
        super.initializeFunctionRegistry(registry);
        CommonFunctionFactory.abs(registry);
        CommonFunctionFactory.sign(registry);
        CommonFunctionFactory.acos(registry);
        CommonFunctionFactory.asin(registry);
        CommonFunctionFactory.atan(registry);
        CommonFunctionFactory.cos(registry);
        CommonFunctionFactory.cosh(registry);
        CommonFunctionFactory.exp(registry);
        CommonFunctionFactory.ln(registry);
        CommonFunctionFactory.sin(registry);
        CommonFunctionFactory.sinh(registry);
        CommonFunctionFactory.stddev(registry);
        CommonFunctionFactory.sqrt(registry);
        CommonFunctionFactory.tan(registry);
        CommonFunctionFactory.tanh(registry);
        CommonFunctionFactory.variance(registry);
        CommonFunctionFactory.round(registry);
        CommonFunctionFactory.trunc(registry);
        CommonFunctionFactory.ceil(registry);
        CommonFunctionFactory.floor(registry);
        registry.namedTemplateBuilder("chr").setInvariantType(StandardSpiBasicTypes.CHARACTER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("initcap").setInvariantType(StandardSpiBasicTypes.STRING).setExactArgumentCount(1).register();
        CommonFunctionFactory.lower(registry);
        registry.namedTemplateBuilder("ltrim").setInvariantType(StandardSpiBasicTypes.STRING).setArgumentCountBetween(1, 2).register();
        registry.namedTemplateBuilder("rtrim").setInvariantType(StandardSpiBasicTypes.STRING).setArgumentCountBetween(1, 2).register();
        CommonFunctionFactory.soundex(registry);
        CommonFunctionFactory.upper(registry);
        registry.namedTemplateBuilder("ascii").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("to_char").setInvariantType(StandardSpiBasicTypes.STRING).setArgumentCountBetween(1, 3).register();
        registry.namedTemplateBuilder("to_date").setInvariantType(StandardSpiBasicTypes.TIMESTAMP).setArgumentCountBetween(1, 3).register();
        registry.registerNoArgs("current_date", StandardSpiBasicTypes.DATE);
        registry.registerNoArgs("current_time", StandardSpiBasicTypes.TIME);
        registry.namedTemplateBuilder("current_timestamp").setInvariantType(StandardSpiBasicTypes.TIMESTAMP).setArgumentCountBetween(0, 1).register();
        registry.namedTemplateBuilder("last_day").setInvariantType(StandardSpiBasicTypes.DATE).setExactArgumentCount(1).register();
        registry.registerNoArgs("sysdate", StandardSpiBasicTypes.DATE);
        registry.registerNoArgs("systimestamp", StandardSpiBasicTypes.TIMESTAMP);
        registry.registerNoArgs("uid", StandardSpiBasicTypes.INTEGER);
        registry.registerNoArgs("user", StandardSpiBasicTypes.STRING);
        registry.registerNoArgs("rowid", StandardSpiBasicTypes.LONG);
        registry.registerNoArgs("rownum", StandardSpiBasicTypes.LONG);
        registry.register("concat", new ConcatFunctionTemplate("", "||", ""));
        registry.namedTemplateBuilder("instr").setInvariantType(StandardSpiBasicTypes.INTEGER).setArgumentCountBetween(2, 4).register();
        registry.namedTemplateBuilder("instrb").setInvariantType(StandardSpiBasicTypes.INTEGER).setArgumentCountBetween(2, 4).register();
        registry.namedTemplateBuilder("lpad").setInvariantType(StandardSpiBasicTypes.STRING).setArgumentCountBetween(2, 3).register();
        registry.namedTemplateBuilder("replace").setInvariantType(StandardSpiBasicTypes.STRING).setArgumentCountBetween(2, 3).register();
        registry.namedTemplateBuilder("rpad").setInvariantType(StandardSpiBasicTypes.STRING).setArgumentCountBetween(2, 3).register();
        registry.namedTemplateBuilder("substr").setInvariantType(StandardSpiBasicTypes.STRING).setArgumentCountBetween(2, 3).register();
        registry.namedTemplateBuilder("substrb").setInvariantType(StandardSpiBasicTypes.STRING).setArgumentCountBetween(2, 3).register();
        registry.namedTemplateBuilder("translate").setInvariantType(StandardSpiBasicTypes.STRING).setExactArgumentCount(3).register();
        registry.registerAlternateKey("substring", "substr");
        registry.registerPattern("locate", "instr(?2,?1)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("bit_length", "vsize(?1)*8", StandardSpiBasicTypes.INTEGER);
        registry.register("coalesce", new NvlFunctionTemplate());
        registry.namedTemplateBuilder("atan2").setInvariantType(StandardSpiBasicTypes.FLOAT).setExactArgumentCount(1).register();
        CommonFunctionFactory.log(registry);
        CommonFunctionFactory.mod(registry);
        registry.namedTemplateBuilder("nvl").setExactArgumentCount(2).register();
        registry.namedTemplateBuilder("nvl2").setExactArgumentCount(3).register();
        registry.namedTemplateBuilder("power").setInvariantType(StandardSpiBasicTypes.FLOAT).setExactArgumentCount(2).register();
        registry.namedTemplateBuilder("add_months").setInvariantType(StandardSpiBasicTypes.DATE).setExactArgumentCount(2).register();
        registry.namedTemplateBuilder("months_between").setInvariantType(StandardSpiBasicTypes.FLOAT).setExactArgumentCount(2).register();
        registry.namedTemplateBuilder("next_day").setInvariantType(StandardSpiBasicTypes.DATE).setExactArgumentCount(2).register();
        registry.registerAlternateKey("str", "to_char");
    }

    @Override
    public String getAddColumnString() {
        return "add";
    }

    @Override
    public String getSequenceNextValString(String sequenceName) {
        return "select " + this.getSelectSequenceNextValString(sequenceName) + " from dual";
    }

    @Override
    public String getSelectSequenceNextValString(String sequenceName) {
        return sequenceName + ".nextval";
    }

    @Override
    public String getCreateSequenceString(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    @Override
    public String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName;
    }

    @Override
    public String getCascadeConstraintsString() {
        return " cascade constraints";
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public String getForUpdateNowaitString() {
        return " for update nowait";
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public boolean supportsPooledSequences() {
        return true;
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public String getLimitString(String sql, boolean hasOffset) {
        sql = sql.trim();
        boolean isForUpdate = false;
        if (sql.toLowerCase(Locale.ROOT).endsWith(" for update")) {
            sql = sql.substring(0, sql.length() - 11);
            isForUpdate = true;
        }
        StringBuilder pagingSelect = new StringBuilder(sql.length() + 100);
        if (hasOffset) {
            pagingSelect.append("select * from ( select row_.*, rownum rownum_ from ( ");
        } else {
            pagingSelect.append("select * from ( ");
        }
        pagingSelect.append(sql);
        if (hasOffset) {
            pagingSelect.append(" ) row_ where rownum <= ?) where rownum_ > ?");
        } else {
            pagingSelect.append(" ) where rownum <= ?");
        }
        if (isForUpdate) {
            pagingSelect.append(" for update");
        }
        return pagingSelect.toString();
    }

    @Override
    public String getForUpdateString(String aliases) {
        return this.getForUpdateString() + " of " + aliases;
    }

    @Override
    public String getForUpdateNowaitString(String aliases) {
        return this.getForUpdateString() + " of " + aliases + " nowait";
    }

    @Override
    public boolean bindLimitParametersInReverseOrder() {
        return true;
    }

    @Override
    public boolean useMaxForLimit() {
        return true;
    }

    @Override
    public boolean forUpdateOfColumns() {
        return true;
    }

    @Override
    public String getQuerySequencesString() {
        return "select * from all_sequences";
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceInformationExtractorOracleDatabaseImpl.INSTANCE;
    }

    @Override
    public String getSelectGUIDString() {
        return "select rawtohex(sys_guid()) from dual";
    }

    @Override
    public ViolatedConstraintNameExtracter getViolatedConstraintNameExtracter() {
        return EXTRACTER;
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        statement.registerOutParameter(col, OracleTypesHelper.INSTANCE.getOracleCursorTypeSqlType());
        return ++col;
    }

    @Override
    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        ps.execute();
        return (ResultSet)ps.getObject(1);
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean supportsCommentOn() {
        return true;
    }

    @Override
    public SqmMutationStrategy getDefaultIdTableStrategy() {
        return new GlobalTemporaryTableStrategy(this.generateIdTableSupport());
    }

    private IdTableSupport generateIdTableSupport() {
        return new StandardIdTableSupport(this.generateIdTableExporter()){

            @Override
            protected Identifier determineIdTableName(Identifier baseName) {
                Identifier name = super.determineIdTableName(baseName);
                return name.getText().length() > 30 ? new Identifier(name.getText().substring(0, 30), false) : name;
            }
        };
    }

    private Exporter<IdTable> generateIdTableExporter() {
        return new GlobalTempTableExporter(){

            @Override
            public String getCreateCommand() {
                return "create global temporary table";
            }

            @Override
            public String getCreateOptions() {
                return "on commit delete rows";
            }
        };
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select systimestamp from dual";
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public boolean supportsEmptyInList() {
        return false;
    }

    @Override
    public boolean supportsExistsInSelect() {
        return false;
    }

    @Override
    public int getInExpressionCountLimit() {
        return 1000;
    }

    @Override
    public String getNotExpression(String expression) {
        return "not (" + expression + ")";
    }

    @Override
    public boolean canCreateSchema() {
        return false;
    }

    @Override
    public boolean supportsNoWait() {
        return true;
    }
}

