/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.PessimisticLockException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.LocateEmulationUsingPositionAndSubstring;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.identity.PostgreSQL81IdentityColumnSupport;
import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitHelper;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtracter;
import org.hibernate.exception.spi.ViolatedConstraintNameExtracter;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.procedure.internal.PostgresCallableStatementSupport;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.query.sqm.mutation.spi.SqmMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.idtable.LocalTempTableExporter;
import org.hibernate.query.sqm.mutation.spi.idtable.LocalTemporaryTableStrategy;
import org.hibernate.query.sqm.mutation.spi.idtable.StandardIdTableSupport;
import org.hibernate.query.sqm.produce.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.spi.ConcatFunctionTemplate;
import org.hibernate.type.descriptor.sql.spi.BlobSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.ClobSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.spi.StandardSpiBasicTypes;

public class PostgreSQL81Dialect
extends Dialect {
    private static final AbstractLimitHandler LIMIT_HANDLER = new AbstractLimitHandler(){

        @Override
        public String processSql(String sql, RowSelection selection) {
            boolean hasOffset = LimitHelper.hasFirstRow(selection);
            return sql + (hasOffset ? " limit ? offset ?" : " limit ?");
        }

        @Override
        public boolean supportsLimit() {
            return true;
        }

        @Override
        public boolean bindLimitParametersInReverseOrder() {
            return true;
        }
    };
    private static final ViolatedConstraintNameExtracter EXTRACTER = new TemplatedViolatedConstraintNameExtracter(){

        @Override
        protected String doExtractConstraintName(SQLException sqle) throws NumberFormatException {
            int sqlState = Integer.valueOf(JdbcExceptionHelper.extractSqlState(sqle));
            switch (sqlState) {
                case 23514: {
                    return this.extractUsingTemplate("violates check constraint \"", "\"", sqle.getMessage());
                }
                case 23505: {
                    return this.extractUsingTemplate("violates unique constraint \"", "\"", sqle.getMessage());
                }
                case 23503: {
                    return this.extractUsingTemplate("violates foreign key constraint \"", "\"", sqle.getMessage());
                }
                case 23502: {
                    return this.extractUsingTemplate("null value in column \"", "\" violates not-null constraint", sqle.getMessage());
                }
                case 23001: {
                    return null;
                }
            }
            return null;
        }
    };

    public PostgreSQL81Dialect() {
        this.registerColumnType(-7, "bool");
        this.registerColumnType(-5, "int8");
        this.registerColumnType(5, "int2");
        this.registerColumnType(-6, "int2");
        this.registerColumnType(4, "int4");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(6, "float4");
        this.registerColumnType(8, "float8");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(-3, "bytea");
        this.registerColumnType(-2, "bytea");
        this.registerColumnType(-1, "text");
        this.registerColumnType(-4, "bytea");
        this.registerColumnType(2005, "text");
        this.registerColumnType(2004, "oid");
        this.registerColumnType(2, "numeric($p, $s)");
        this.registerColumnType(1111, "uuid");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
        this.getDefaultProperties().setProperty("hibernate.jdbc.lob.non_contextual_creation", "true");
    }

    @Override
    public void initializeFunctionRegistry(SqmFunctionRegistry registry) {
        super.initializeFunctionRegistry(registry);
        CommonFunctionFactory.abs(registry);
        CommonFunctionFactory.sign(registry);
        CommonFunctionFactory.acos(registry);
        CommonFunctionFactory.asin(registry);
        CommonFunctionFactory.atan(registry);
        CommonFunctionFactory.cos(registry);
        CommonFunctionFactory.cot(registry);
        CommonFunctionFactory.exp(registry);
        CommonFunctionFactory.ln(registry);
        CommonFunctionFactory.sin(registry);
        CommonFunctionFactory.sqrt(registry);
        registry.namedTemplateBuilder("cbrt").setInvariantType(StandardSpiBasicTypes.DOUBLE).setExactArgumentCount(1).register();
        CommonFunctionFactory.tan(registry);
        CommonFunctionFactory.radians(registry);
        CommonFunctionFactory.degrees(registry);
        CommonFunctionFactory.stddev(registry);
        CommonFunctionFactory.variance(registry);
        registry.registerNoArgs("random", StandardSpiBasicTypes.DOUBLE);
        registry.registerAlternateKey("rand", "random");
        CommonFunctionFactory.round(registry);
        CommonFunctionFactory.trunc(registry);
        CommonFunctionFactory.ceil(registry);
        CommonFunctionFactory.floor(registry);
        registry.namedTemplateBuilder("ltrim").setInvariantType(StandardSpiBasicTypes.STRING).setArgumentCountBetween(1, 2).register();
        registry.namedTemplateBuilder("rtrim").setInvariantType(StandardSpiBasicTypes.STRING).setArgumentCountBetween(1, 2).register();
        registry.namedTemplateBuilder("chr").setInvariantType(StandardSpiBasicTypes.CHARACTER).setExactArgumentCount(1).register();
        CommonFunctionFactory.lower(registry);
        CommonFunctionFactory.upper(registry);
        registry.namedTemplateBuilder("substr").setInvariantType(StandardSpiBasicTypes.STRING).setArgumentCountBetween(2, 3).register();
        registry.namedTemplateBuilder("initcap").setInvariantType(StandardSpiBasicTypes.STRING).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("to_ascii").setInvariantType(StandardSpiBasicTypes.STRING).setArgumentCountBetween(1, 2).register();
        registry.namedTemplateBuilder("quote_ident").setInvariantType(StandardSpiBasicTypes.STRING).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("quote_literal").setInvariantType(StandardSpiBasicTypes.STRING).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("md5").setInvariantType(StandardSpiBasicTypes.STRING).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("ascii").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("char_length").setInvariantType(StandardSpiBasicTypes.LONG).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("bit_length").setInvariantType(StandardSpiBasicTypes.LONG).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("octet_length").setInvariantType(StandardSpiBasicTypes.LONG).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("age").setArgumentCountBetween(1, 2).register();
        registry.registerNoArgs("current_date", StandardSpiBasicTypes.DATE);
        registry.registerNoArgs("current_time", StandardSpiBasicTypes.TIME);
        registry.registerNoArgs("current_timestamp", StandardSpiBasicTypes.TIMESTAMP);
        registry.namedTemplateBuilder("date_trunc").setInvariantType(StandardSpiBasicTypes.TIMESTAMP).setExactArgumentCount(2).register();
        registry.registerNoArgs("localtime", StandardSpiBasicTypes.TIME);
        registry.registerNoArgs("localtimestamp", StandardSpiBasicTypes.TIMESTAMP);
        registry.noArgsBuilder("now").setInvariantType(StandardSpiBasicTypes.TIMESTAMP).setUseParenthesesWhenNoArgs(true).register();
        registry.noArgsBuilder("timeofday").setInvariantType(StandardSpiBasicTypes.STRING).setUseParenthesesWhenNoArgs(true).register();
        registry.registerNoArgs("current_user", StandardSpiBasicTypes.STRING);
        registry.registerNoArgs("session_user", StandardSpiBasicTypes.STRING);
        registry.registerNoArgs("user", StandardSpiBasicTypes.STRING);
        registry.noArgsBuilder("current_database").setInvariantType(StandardSpiBasicTypes.STRING).setUseParenthesesWhenNoArgs(true).register();
        registry.noArgsBuilder("current_schema").setInvariantType(StandardSpiBasicTypes.STRING).setUseParenthesesWhenNoArgs(true).register();
        registry.namedTemplateBuilder("to_char").setInvariantType(StandardSpiBasicTypes.STRING).setExactArgumentCount(2).register();
        registry.namedTemplateBuilder("to_date").setInvariantType(StandardSpiBasicTypes.DATE).setExactArgumentCount(2).register();
        registry.namedTemplateBuilder("to_timestamp").setInvariantType(StandardSpiBasicTypes.TIMESTAMP).setExactArgumentCount(2).register();
        registry.namedTemplateBuilder("to_number").setInvariantType(StandardSpiBasicTypes.BIG_DECIMAL).setExactArgumentCount(2).register();
        registry.register("concat", ConcatFunctionTemplate.INSTANCE);
        registry.namedTemplateBuilder("lpad").setInvariantType(StandardSpiBasicTypes.STRING).setArgumentCountBetween(2, 3).register();
        registry.namedTemplateBuilder("replace").setInvariantType(StandardSpiBasicTypes.STRING).setArgumentCountBetween(2, 3).register();
        registry.namedTemplateBuilder("rpad").setInvariantType(StandardSpiBasicTypes.STRING).setArgumentCountBetween(2, 3).register();
        registry.namedTemplateBuilder("translate").setInvariantType(StandardSpiBasicTypes.STRING).setExactArgumentCount(3).register();
        registry.registerAlternateKey("substring", "substr");
        registry.register("locate", new LocateEmulationUsingPositionAndSubstring());
        registry.namedTemplateBuilder("coalesce").setArgumentsValidator(StandardArgumentsValidators.min(2)).register();
        registry.registerPattern("str", "cast(?1 as varchar)", StandardSpiBasicTypes.STRING);
        registry.namedTemplateBuilder("atan2").setInvariantType(StandardSpiBasicTypes.FLOAT).setExactArgumentCount(2).register();
        CommonFunctionFactory.log(registry);
        CommonFunctionFactory.mod(registry);
        registry.namedTemplateBuilder("power").setInvariantType(StandardSpiBasicTypes.FLOAT).setExactArgumentCount(2).register();
    }

    @Override
    public SqlTypeDescriptor getSqlTypeDescriptorOverride(int sqlCode) {
        SqlTypeDescriptor descriptor;
        switch (sqlCode) {
            case 2004: {
                descriptor = BlobSqlDescriptor.BLOB_BINDING;
                break;
            }
            case 2005: {
                descriptor = ClobSqlDescriptor.CLOB_BINDING;
                break;
            }
            default: {
                descriptor = super.getSqlTypeDescriptorOverride(sqlCode);
            }
        }
        return descriptor;
    }

    @Override
    public String getAddColumnString() {
        return "add column";
    }

    @Override
    public String getSequenceNextValString(String sequenceName) {
        return "select " + this.getSelectSequenceNextValString(sequenceName);
    }

    @Override
    public String getSelectSequenceNextValString(String sequenceName) {
        return "nextval ('" + sequenceName + "')";
    }

    @Override
    public String getCreateSequenceString(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    @Override
    public String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName;
    }

    @Override
    public String getCascadeConstraintsString() {
        return " cascade";
    }

    @Override
    public boolean dropConstraints() {
        return true;
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public String getQuerySequencesString() {
        return "select * from information_schema.sequences";
    }

    @Override
    public LimitHandler getLimitHandler() {
        return LIMIT_HANDLER;
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public String getLimitString(String sql, boolean hasOffset) {
        return sql + (hasOffset ? " limit ? offset ?" : " limit ?");
    }

    @Override
    public boolean bindLimitParametersInReverseOrder() {
        return true;
    }

    @Override
    public String getForUpdateString(String aliases) {
        return this.getForUpdateString() + " of " + aliases;
    }

    @Override
    public String getForUpdateString(String aliases, LockOptions lockOptions) {
        LockMode lockMode;
        if ("".equals(aliases)) {
            lockMode = lockOptions.getLockMode();
            Iterator<Map.Entry<String, LockMode>> itr = lockOptions.getAliasLockIterator();
            while (itr.hasNext()) {
                Map.Entry<String, LockMode> entry = itr.next();
                LockMode lm = entry.getValue();
                if (!lm.greaterThan(lockMode)) continue;
                aliases = entry.getKey();
            }
        }
        if ((lockMode = lockOptions.getAliasSpecificLockMode(aliases)) == null) {
            lockMode = lockOptions.getLockMode();
        }
        switch (lockMode) {
            case UPGRADE: {
                return this.getForUpdateString(aliases);
            }
            case PESSIMISTIC_READ: {
                return this.getReadLockString(aliases, lockOptions.getTimeOut());
            }
            case PESSIMISTIC_WRITE: {
                return this.getWriteLockString(aliases, lockOptions.getTimeOut());
            }
            case UPGRADE_NOWAIT: 
            case FORCE: 
            case PESSIMISTIC_FORCE_INCREMENT: {
                return this.getForUpdateNowaitString(aliases);
            }
            case UPGRADE_SKIPLOCKED: {
                return this.getForUpdateSkipLockedString(aliases);
            }
        }
        return "";
    }

    @Override
    public String getNoColumnsInsertString() {
        return "default values";
    }

    @Override
    public String getCaseInsensitiveLike() {
        return "ilike";
    }

    @Override
    public boolean supportsCaseInsensitiveLike() {
        return true;
    }

    @Override
    public String getNativeIdentifierGeneratorStrategy() {
        return "sequence";
    }

    @Override
    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    @Override
    public boolean useInputStreamToInsertBlob() {
        return false;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public String getSelectClauseNullString(int sqlType) {
        String typeName = this.getTypeName(sqlType, 1L, 1, 0);
        int loc = typeName.indexOf(40);
        if (loc > -1) {
            typeName = typeName.substring(0, loc);
        }
        return "null::" + typeName;
    }

    @Override
    public boolean supportsCommentOn() {
        return true;
    }

    @Override
    public SqmMutationStrategy getDefaultIdTableStrategy() {
        return new LocalTemporaryTableStrategy(new StandardIdTableSupport(new LocalTempTableExporter(){

            @Override
            protected String getCreateOptions() {
                return "on commit drop";
            }
        }));
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select now()";
    }

    @Override
    public boolean requiresParensForTupleDistinctCounts() {
        return true;
    }

    @Override
    public String toBooleanValueString(boolean bool) {
        return bool ? "true" : "false";
    }

    @Override
    public ViolatedConstraintNameExtracter getViolatedConstraintNameExtracter() {
        return EXTRACTER;
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return new SQLExceptionConversionDelegate(){

            @Override
            public JDBCException convert(SQLException sqlException, String message, String sql) {
                String sqlState = JdbcExceptionHelper.extractSqlState(sqlException);
                if ("40P01".equals(sqlState)) {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                if ("55P03".equals(sqlState)) {
                    return new PessimisticLockException(message, sqlException, sql);
                }
                return null;
            }
        };
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        statement.registerOutParameter(col++, 1111);
        return col;
    }

    @Override
    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        ps.execute();
        return (ResultSet)ps.getObject(1);
    }

    @Override
    public boolean supportsPooledSequences() {
        return true;
    }

    @Override
    protected String getCreateSequenceString(String sequenceName, int initialValue, int incrementSize) {
        if (initialValue < 0 && incrementSize > 0) {
            return String.format("%s minvalue %d start %d increment %d", this.getCreateSequenceString(sequenceName), initialValue, initialValue, incrementSize);
        }
        if (initialValue > 0 && incrementSize < 0) {
            return String.format("%s maxvalue %d start %d increment %d", this.getCreateSequenceString(sequenceName), initialValue, initialValue, incrementSize);
        }
        return String.format("%s start %d increment %d", this.getCreateSequenceString(sequenceName), initialValue, incrementSize);
    }

    @Override
    public boolean supportsEmptyInList() {
        return false;
    }

    @Override
    public boolean supportsExpectedLobUsagePattern() {
        return true;
    }

    @Override
    public boolean supportsLobValueChangePropogation() {
        return false;
    }

    @Override
    public boolean supportsUnboundedLobLocatorMaterialization() {
        return false;
    }

    @Override
    public String getForUpdateString() {
        return " for update";
    }

    @Override
    public String getWriteLockString(int timeout) {
        if (timeout == 0) {
            return " for update nowait";
        }
        return " for update";
    }

    @Override
    public String getWriteLockString(String aliases, int timeout) {
        if (timeout == 0) {
            return String.format(" for update of %s nowait", aliases);
        }
        return " for update of " + aliases;
    }

    @Override
    public String getReadLockString(int timeout) {
        if (timeout == 0) {
            return " for share nowait";
        }
        return " for share";
    }

    @Override
    public String getReadLockString(String aliases, int timeout) {
        if (timeout == 0) {
            return String.format(" for share of %s nowait", aliases);
        }
        return " for share of " + aliases;
    }

    @Override
    public boolean supportsRowValueConstructorSyntax() {
        return true;
    }

    @Override
    public String getForUpdateNowaitString() {
        return this.getForUpdateString() + " nowait ";
    }

    @Override
    public String getForUpdateNowaitString(String aliases) {
        return this.getForUpdateString(aliases) + " nowait ";
    }

    @Override
    public CallableStatementSupport getCallableStatementSupport() {
        return PostgresCallableStatementSupport.INSTANCE;
    }

    @Override
    public ResultSet getResultSet(CallableStatement statement, int position) throws SQLException {
        if (position != 1) {
            throw new UnsupportedOperationException("PostgreSQL only supports REF_CURSOR parameters as the first parameter");
        }
        return (ResultSet)statement.getObject(1);
    }

    @Override
    public ResultSet getResultSet(CallableStatement statement, String name) throws SQLException {
        throw new UnsupportedOperationException("PostgreSQL only supports accessing REF_CURSOR parameters by position");
    }

    @Override
    public boolean qualifyIndexName() {
        return false;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return new PostgreSQL81IdentityColumnSupport();
    }

    @Override
    public boolean supportsNationalizedTypes() {
        return false;
    }

    @Override
    public boolean supportsNoWait() {
        return true;
    }

    @Override
    public boolean supportsJdbcConnectionLobCreation(DatabaseMetaData databaseMetaData) {
        return false;
    }
}

