/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.PostgreSQL81Dialect;
import org.hibernate.query.sqm.mutation.spi.SqmMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.idtable.LocalTempTableExporter;
import org.hibernate.query.sqm.mutation.spi.idtable.LocalTemporaryTableStrategy;
import org.hibernate.query.sqm.mutation.spi.idtable.StandardIdTableSupport;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.AbstractJdbcValueBinder;
import org.hibernate.sql.AbstractJdbcValueExtractor;
import org.hibernate.sql.JdbcValueBinder;
import org.hibernate.sql.JdbcValueExtractor;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.spi.AbstractTemplateSqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.spi.JdbcLiteralFormatter;
import org.hibernate.type.spi.TypeConfiguration;

public class PostgreSQL82Dialect
extends PostgreSQL81Dialect {
    @Override
    public boolean supportsIfExistsBeforeTableName() {
        return true;
    }

    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        typeContributions.contributeSqlTypeDescriptor(PostgresUUIDType.INSTANCE);
    }

    @Override
    public SqmMutationStrategy getDefaultIdTableStrategy() {
        return new LocalTemporaryTableStrategy(new StandardIdTableSupport(new LocalTempTableExporter(){

            @Override
            public String getCreateCommand() {
                return "create temporary table";
            }
        }));
    }

    @Override
    public String getDropSequenceString(String sequenceName) {
        return "drop sequence if exists " + sequenceName;
    }

    @Override
    public boolean supportsValuesList() {
        return true;
    }

    @Override
    public boolean supportsRowValueConstructorSyntaxInInList() {
        return true;
    }

    private static class PostgresUUIDType
    extends AbstractTemplateSqlTypeDescriptor {
        public static final PostgresUUIDType INSTANCE = new PostgresUUIDType();
        public static final int JDBC_TYPE_CODE = 3975;

        private PostgresUUIDType() {
        }

        @Override
        public int getJdbcTypeCode() {
            return 3975;
        }

        @Override
        public boolean canBeRemapped() {
            return true;
        }

        public <J> BasicJavaDescriptor<J> getJdbcRecommendedJavaTypeMapping(TypeConfiguration typeConfiguration) {
            return (BasicJavaDescriptor)typeConfiguration.getJavaTypeDescriptorRegistry().getOrMakeJavaDescriptor(UUID.class);
        }

        @Override
        public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaTypeDescriptor<T> javaTypeDescriptor) {
            return null;
        }

        @Override
        protected <X> JdbcValueBinder<X> createBinder(final BasicJavaDescriptor<X> javaTypeDescriptor, TypeConfiguration typeConfiguration) {
            return new AbstractJdbcValueBinder<X>(javaTypeDescriptor, this){

                @Override
                protected void doBind(PreparedStatement st, int index, X value, ExecutionContext executionContext) throws SQLException {
                    st.setObject(index, (Object)javaTypeDescriptor.unwrap(value, UUID.class, executionContext.getSession()), 1111);
                }

                @Override
                protected void doBind(CallableStatement st, String name, X value, ExecutionContext executionContext) throws SQLException {
                    st.setObject(name, (Object)javaTypeDescriptor.unwrap(value, UUID.class, executionContext.getSession()), 1111);
                }
            };
        }

        @Override
        protected <X> JdbcValueExtractor<X> createExtractor(final BasicJavaDescriptor<X> javaTypeDescriptor, TypeConfiguration typeConfiguration) {
            return new AbstractJdbcValueExtractor<X>(javaTypeDescriptor, this){

                @Override
                protected X doExtract(ResultSet rs, int position, ExecutionContext executionContext) throws SQLException {
                    return javaTypeDescriptor.wrap(rs.getObject(position), executionContext.getSession());
                }

                @Override
                protected X doExtract(CallableStatement statement, int position, ExecutionContext executionContext) throws SQLException {
                    return javaTypeDescriptor.wrap(statement.getObject(position), executionContext.getSession());
                }

                @Override
                protected X doExtract(CallableStatement statement, String name, ExecutionContext executionContext) throws SQLException {
                    return javaTypeDescriptor.wrap(statement.getObject(name), executionContext.getSession());
                }
            };
        }
    }
}

