/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.LockMode;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.OptimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.OptimisticLockingStrategy;
import org.hibernate.dialect.lock.PessimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.PessimisticReadUpdateLockingStrategy;
import org.hibernate.dialect.lock.PessimisticWriteUpdateLockingStrategy;
import org.hibernate.dialect.lock.SelectLockingStrategy;
import org.hibernate.dialect.lock.UpdateLockingStrategy;
import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitHelper;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.model.domain.spi.Lockable;
import org.hibernate.query.sqm.produce.function.SqmFunctionRegistry;
import org.hibernate.sql.CaseFragment;
import org.hibernate.sql.DecodeCaseFragment;
import org.hibernate.type.spi.StandardSpiBasicTypes;
import org.jboss.logging.Logger;

public class RDMSOS2200Dialect
extends Dialect {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)RDMSOS2200Dialect.class.getName());
    private static final AbstractLimitHandler LIMIT_HANDLER = new AbstractLimitHandler(){

        @Override
        public String processSql(String sql, RowSelection selection) {
            boolean hasOffset = LimitHelper.hasFirstRow(selection);
            if (hasOffset) {
                throw new UnsupportedOperationException("query result offset is not supported");
            }
            return sql + " fetch first " + this.getMaxOrLimit(selection) + " rows only ";
        }

        @Override
        public boolean supportsLimit() {
            return true;
        }

        @Override
        public boolean supportsLimitOffset() {
            return false;
        }

        @Override
        public boolean supportsVariableLimit() {
            return false;
        }
    };
    private static final AbstractLimitHandler LEGACY_LIMIT_HANDLER = new AbstractLimitHandler(){

        @Override
        public String processSql(String sql, RowSelection selection) {
            return sql + " fetch first " + this.getMaxOrLimit(selection) + " rows only ";
        }

        @Override
        public boolean supportsLimit() {
            return true;
        }

        @Override
        public boolean supportsLimitOffset() {
            return false;
        }

        @Override
        public boolean supportsVariableLimit() {
            return false;
        }
    };

    public RDMSOS2200Dialect() {
        LOG.rdmsOs2200Dialect();
        this.registerColumnType(-7, "SMALLINT");
        this.registerColumnType(-6, "SMALLINT");
        this.registerColumnType(-5, "NUMERIC(21,0)");
        this.registerColumnType(5, "SMALLINT");
        this.registerColumnType(1, "CHARACTER(1)");
        this.registerColumnType(8, "DOUBLE PRECISION");
        this.registerColumnType(6, "FLOAT");
        this.registerColumnType(7, "REAL");
        this.registerColumnType(4, "INTEGER");
        this.registerColumnType(2, "NUMERIC(21,$l)");
        this.registerColumnType(3, "NUMERIC(21,$l)");
        this.registerColumnType(91, "DATE");
        this.registerColumnType(92, "TIME");
        this.registerColumnType(93, "TIMESTAMP");
        this.registerColumnType(12, "CHARACTER($l)");
        this.registerColumnType(2004, "BLOB($l)");
    }

    @Override
    public void initializeFunctionRegistry(SqmFunctionRegistry registry) {
        super.initializeFunctionRegistry(registry);
        registry.registerNamed("abs");
        registry.registerNamed("sign", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("ascii", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("char_length", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("character_length", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("concat", "concat(?1, ?2)", StandardSpiBasicTypes.STRING);
        registry.registerNamed("instr", StandardSpiBasicTypes.STRING);
        registry.registerNamed("lpad", StandardSpiBasicTypes.STRING);
        registry.registerNamed("replace", StandardSpiBasicTypes.STRING);
        registry.registerNamed("rpad", StandardSpiBasicTypes.STRING);
        registry.registerNamed("substr", StandardSpiBasicTypes.STRING);
        registry.registerNamed("lcase");
        registry.registerNamed("lower");
        registry.registerNamed("ltrim");
        registry.registerNamed("reverse");
        registry.registerNamed("rtrim");
        registry.registerPattern("trim", "ltrim(rtrim(?1))", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("soundex");
        registry.registerNamed("space", StandardSpiBasicTypes.STRING);
        registry.registerNamed("ucase");
        registry.registerNamed("upper");
        registry.registerNamed("acos", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("asin", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("atan", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("cos", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("cosh", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("cot", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("exp", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("ln", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("log", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("log10", StandardSpiBasicTypes.DOUBLE);
        registry.registerNoArgs("pi", StandardSpiBasicTypes.DOUBLE);
        registry.registerNoArgs("rand", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("sin", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("sinh", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("sqrt", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("tan", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("tanh", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("round");
        registry.registerNamed("trunc");
        registry.registerNamed("ceil");
        registry.registerNamed("floor");
        registry.registerNamed("chr", StandardSpiBasicTypes.CHARACTER);
        registry.registerNamed("initcap");
        registry.registerNoArgs("user", StandardSpiBasicTypes.STRING);
        registry.registerNoArgs("current_date", StandardSpiBasicTypes.DATE);
        registry.registerNoArgs("current_time", StandardSpiBasicTypes.TIME);
        registry.registerNoArgs("current_timestamp", StandardSpiBasicTypes.TIMESTAMP);
        registry.registerNoArgs("curdate", StandardSpiBasicTypes.DATE);
        registry.registerNoArgs("curtime", StandardSpiBasicTypes.TIME);
        registry.registerNamed("days", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("dayofmonth", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("dayname", StandardSpiBasicTypes.STRING);
        registry.registerNamed("dayofweek", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("dayofyear", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("hour", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("last_day", StandardSpiBasicTypes.DATE);
        registry.registerNamed("microsecond", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("minute", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("month", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("monthname", StandardSpiBasicTypes.STRING);
        registry.registerNoArgs("now", StandardSpiBasicTypes.TIMESTAMP);
        registry.registerNamed("quarter", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("second", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("time", StandardSpiBasicTypes.TIME);
        registry.registerNamed("timestamp", StandardSpiBasicTypes.TIMESTAMP);
        registry.registerNamed("week", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("year", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("atan2", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("mod", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("nvl");
        registry.registerNamed("power", StandardSpiBasicTypes.DOUBLE);
    }

    @Override
    public boolean qualifyIndexName() {
        return false;
    }

    @Override
    public boolean forUpdateOfColumns() {
        return false;
    }

    @Override
    public String getForUpdateString() {
        return "";
    }

    @Override
    public boolean supportsCascadeDelete() {
        return false;
    }

    @Override
    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    @Override
    public String getAddColumnString() {
        return "add";
    }

    @Override
    public String getNullColumnString() {
        return " null";
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public String getSequenceNextValString(String sequenceName) {
        return "select permuted_id('NEXT',31) from rdms.rdms_dummy where key_col = 1 ";
    }

    @Override
    public String getCreateSequenceString(String sequenceName) {
        return "";
    }

    @Override
    public String getDropSequenceString(String sequenceName) {
        return "";
    }

    @Override
    public String getCascadeConstraintsString() {
        return " including contents";
    }

    @Override
    public CaseFragment createCaseFragment() {
        return new DecodeCaseFragment();
    }

    @Override
    public LimitHandler getLimitHandler() {
        if (this.isLegacyLimitHandlerBehaviorEnabled()) {
            return LEGACY_LIMIT_HANDLER;
        }
        return LIMIT_HANDLER;
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsLimitOffset() {
        return false;
    }

    @Override
    public String getLimitString(String sql, int offset, int limit) {
        if (offset > 0) {
            throw new UnsupportedOperationException("query result offset is not supported");
        }
        return sql + " fetch first " + limit + " rows only ";
    }

    @Override
    public boolean supportsVariableLimit() {
        return false;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        if (lockMode == LockMode.PESSIMISTIC_FORCE_INCREMENT) {
            return new PessimisticForceIncrementLockingStrategy(lockable, lockMode);
        }
        if (lockMode == LockMode.PESSIMISTIC_WRITE) {
            return new PessimisticWriteUpdateLockingStrategy(lockable, lockMode);
        }
        if (lockMode == LockMode.PESSIMISTIC_READ) {
            return new PessimisticReadUpdateLockingStrategy(lockable, lockMode);
        }
        if (lockMode == LockMode.OPTIMISTIC) {
            return new OptimisticLockingStrategy(lockable, lockMode);
        }
        if (lockMode == LockMode.OPTIMISTIC_FORCE_INCREMENT) {
            return new OptimisticForceIncrementLockingStrategy(lockable, lockMode);
        }
        if (lockMode.greaterThan(LockMode.READ)) {
            return new UpdateLockingStrategy(lockable, lockMode);
        }
        return new SelectLockingStrategy(lockable, lockMode);
    }
}

