/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.DatabaseMetaData;
import org.hibernate.dialect.Dialect;
import org.hibernate.naming.Identifier;
import org.hibernate.query.sqm.mutation.spi.SqmMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTable;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableSupport;
import org.hibernate.query.sqm.mutation.spi.idtable.LocalTempTableExporter;
import org.hibernate.query.sqm.mutation.spi.idtable.LocalTemporaryTableStrategy;
import org.hibernate.query.sqm.mutation.spi.idtable.StandardIdTableSupport;
import org.hibernate.query.sqm.produce.function.SqmFunctionRegistry;
import org.hibernate.sql.CaseFragment;
import org.hibernate.sql.DecodeCaseFragment;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorSAPDBDatabaseImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.type.spi.StandardSpiBasicTypes;

public class SAPDBDialect
extends Dialect {
    public SAPDBDialect() {
        this.registerColumnType(-7, "boolean");
        this.registerColumnType(-5, "fixed(19,0)");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(-6, "fixed(3,0)");
        this.registerColumnType(4, "int");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double precision");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(-3, "long byte");
        this.registerColumnType(2, "fixed($p,$s)");
        this.registerColumnType(2005, "long varchar");
        this.registerColumnType(2004, "long byte");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
    }

    @Override
    public void initializeFunctionRegistry(SqmFunctionRegistry registry) {
        super.initializeFunctionRegistry(registry);
        registry.registerNamed("abs");
        registry.registerNamed("sign", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("exp", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("ln", StandardSpiBasicTypes.DOUBLE);
        registry.namedTemplateBuilder("log", "ln").setInvariantType(StandardSpiBasicTypes.DOUBLE).register();
        registry.registerNoArgs("pi", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("power");
        registry.registerNamed("acos", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("asin", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("atan", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("cos", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("cosh", StandardSpiBasicTypes.DOUBLE);
        registry.namedTemplateBuilder("cot", "cos").setInvariantType(StandardSpiBasicTypes.DOUBLE).register();
        registry.registerNamed("sin", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("sinh", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("tan", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("tanh", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("radians", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("degrees", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("atan2", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("round");
        registry.registerNamed("trunc");
        registry.registerNamed("ceil");
        registry.registerNamed("floor");
        registry.registerNamed("greatest");
        registry.registerNamed("least");
        registry.registerNamed("time", StandardSpiBasicTypes.TIME);
        registry.registerNamed("timestamp", StandardSpiBasicTypes.TIMESTAMP);
        registry.registerNamed("date", StandardSpiBasicTypes.DATE);
        registry.registerNamed("microsecond", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("second", "second(?1)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("minute", "minute(?1)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("hour", "hour(?1)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("day", "day(?1)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("month", "month(?1)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("year", "year(?1)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("extract", "?1(?3)", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("dayname", StandardSpiBasicTypes.STRING);
        registry.registerNamed("monthname", StandardSpiBasicTypes.STRING);
        registry.registerNamed("dayofmonth", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("dayofweek", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("dayofyear", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("weekofyear", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("replace", StandardSpiBasicTypes.STRING);
        registry.registerNamed("translate", StandardSpiBasicTypes.STRING);
        registry.registerNamed("lpad", StandardSpiBasicTypes.STRING);
        registry.registerNamed("rpad", StandardSpiBasicTypes.STRING);
        registry.registerNamed("substr", StandardSpiBasicTypes.STRING);
        registry.registerNamed("initcap", StandardSpiBasicTypes.STRING);
        registry.registerNamed("lower", StandardSpiBasicTypes.STRING);
        registry.registerNamed("ltrim", StandardSpiBasicTypes.STRING);
        registry.registerNamed("rtrim", StandardSpiBasicTypes.STRING);
        registry.registerNamed("lfill", StandardSpiBasicTypes.STRING);
        registry.registerNamed("rfill", StandardSpiBasicTypes.STRING);
        registry.registerNamed("soundex", StandardSpiBasicTypes.STRING);
        registry.registerNamed("upper", StandardSpiBasicTypes.STRING);
        registry.registerNamed("ascii", StandardSpiBasicTypes.STRING);
        registry.registerNamed("index", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("value");
        registry.registerVarArgs("concat", StandardSpiBasicTypes.STRING, "(", "||", ")");
        registry.registerAlternateKey("substring", "substr");
        registry.registerAlternateKey("locate", "index");
        registry.registerAlternateKey("coalesce", "value");
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public String getAddColumnString() {
        return "add";
    }

    @Override
    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        StringBuilder res = new StringBuilder(30).append(" foreign key ").append(constraintName).append(" (").append(String.join((CharSequence)", ", foreignKey)).append(") references ").append(referencedTable);
        if (!referencesPrimaryKey) {
            res.append(" (").append(String.join((CharSequence)", ", primaryKey)).append(')');
        }
        return res.toString();
    }

    @Override
    public String getAddForeignKeyConstraintString(String constraintName, String foreignKeyDefinition) {
        return foreignKeyDefinition;
    }

    @Override
    public String getAddPrimaryKeyConstraintString(String constraintName) {
        return " primary key ";
    }

    @Override
    public String getNullColumnString() {
        return " null";
    }

    @Override
    public String getSequenceNextValString(String sequenceName) {
        return "select " + this.getSelectSequenceNextValString(sequenceName) + " from dual";
    }

    @Override
    public String getSelectSequenceNextValString(String sequenceName) {
        return sequenceName + ".nextval";
    }

    @Override
    public String getCreateSequenceString(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    @Override
    public String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName;
    }

    @Override
    public String getQuerySequencesString() {
        return "select * from domain.sequences";
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceInformationExtractorSAPDBDatabaseImpl.INSTANCE;
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public CaseFragment createCaseFragment() {
        return new DecodeCaseFragment();
    }

    @Override
    public SqmMutationStrategy getDefaultIdTableStrategy() {
        return new LocalTemporaryTableStrategy(this.generateIdTableSupport());
    }

    private IdTableSupport generateIdTableSupport() {
        return new StandardIdTableSupport(this.generateIdTableExporter()){

            @Override
            protected Identifier determineIdTableName(Identifier baseName) {
                return new Identifier("temp." + super.determineIdTableName(baseName).getText(), false);
            }
        };
    }

    private Exporter<IdTable> generateIdTableExporter() {
        return new LocalTempTableExporter(){

            @Override
            protected String getCreateOptions() {
                return "ignore rollback";
            }
        };
    }

    @Override
    public boolean supportsJdbcConnectionLobCreation(DatabaseMetaData databaseMetaData) {
        return false;
    }
}

