/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.Locale;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.dialect.AbstractTransactSQLDialect;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.identity.SQLServerIdentityColumnSupport;
import org.hibernate.dialect.pagination.LegacyLimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.TopLimitHandler;
import org.hibernate.query.sqm.produce.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.produce.function.spi.AnsiTrimEmulationFunctionTemplate;
import org.hibernate.type.descriptor.sql.spi.SmallIntSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.spi.StandardSpiBasicTypes;

public class SQLServerDialect
extends AbstractTransactSQLDialect {
    private static final int PARAM_LIST_SIZE_LIMIT = 2100;
    private final LimitHandler limitHandler;

    public SQLServerDialect() {
        this.registerColumnType(-3, "image");
        this.registerColumnType(-3, 8000L, "varbinary($l)");
        this.registerColumnType(-4, "image");
        this.registerColumnType(-1, "text");
        this.registerColumnType(16, "bit");
        this.registerKeyword("top");
        this.registerKeyword("key");
        this.limitHandler = new TopLimitHandler(false, false);
    }

    @Override
    public void initializeFunctionRegistry(SqmFunctionRegistry registry) {
        super.initializeFunctionRegistry(registry);
        registry.registerPattern("second", "datepart(second, ?1)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("minute", "datepart(minute, ?1)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("hour", "datepart(hour, ?1)", StandardSpiBasicTypes.INTEGER);
        registry.namedTemplateBuilder("locate", "charindex").setInvariantType(StandardSpiBasicTypes.INTEGER).setArgumentCountBetween(2, 3).register();
        registry.registerPattern("extract", "datepart(?1, ?3)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("mod", "?1 % ?2", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("bit_length", "datalength(?1) * 8", StandardSpiBasicTypes.INTEGER);
        registry.register("trim", new AnsiTrimEmulationFunctionTemplate());
    }

    @Override
    public String getNoColumnsInsertString() {
        return "default values";
    }

    static int getAfterSelectInsertPoint(String sql) {
        int selectIndex = sql.toLowerCase(Locale.ROOT).indexOf("select");
        int selectDistinctIndex = sql.toLowerCase(Locale.ROOT).indexOf("select distinct");
        return selectIndex + (selectDistinctIndex == selectIndex ? 15 : 6);
    }

    @Override
    public String getLimitString(String querySelect, int offset, int limit) {
        if (offset > 0) {
            throw new UnsupportedOperationException("query result offset is not supported");
        }
        return new StringBuilder(querySelect.length() + 8).append(querySelect).insert(SQLServerDialect.getAfterSelectInsertPoint(querySelect), " top " + limit).toString();
    }

    @Override
    public LimitHandler getLimitHandler() {
        if (this.isLegacyLimitHandlerBehaviorEnabled()) {
            return new LegacyLimitHandler(this);
        }
        return this.getDefaultLimitHandler();
    }

    protected LimitHandler getDefaultLimitHandler() {
        return this.limitHandler;
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean useMaxForLimit() {
        return true;
    }

    @Override
    public boolean supportsLimitOffset() {
        return false;
    }

    @Override
    public boolean supportsVariableLimit() {
        return false;
    }

    @Override
    public char closeQuote() {
        return ']';
    }

    @Override
    public String getCurrentSchemaCommand() {
        return "SELECT SCHEMA_NAME()";
    }

    @Override
    public char openQuote() {
        return '[';
    }

    @Override
    public String appendLockHint(LockOptions lockOptions, String tableName) {
        LockMode mode = lockOptions.getLockMode();
        switch (mode) {
            case UPGRADE: 
            case UPGRADE_NOWAIT: 
            case PESSIMISTIC_WRITE: 
            case WRITE: {
                return tableName + " with (updlock, rowlock)";
            }
            case PESSIMISTIC_READ: {
                return tableName + " with (holdlock, rowlock)";
            }
            case UPGRADE_SKIPLOCKED: {
                return tableName + " with (updlock, rowlock, readpast)";
            }
        }
        return tableName;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select current_timestamp";
    }

    @Override
    public boolean areStringComparisonsCaseInsensitive() {
        return true;
    }

    @Override
    public boolean supportsResultSetPositionQueryMethodsOnForwardOnlyCursor() {
        return false;
    }

    @Override
    public boolean supportsCircularCascadeDeleteConstraints() {
        return false;
    }

    @Override
    public boolean supportsLobValueChangePropogation() {
        return false;
    }

    @Override
    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return false;
    }

    @Override
    public boolean doesRepeatableReadCauseReadersToBlockWriters() {
        return false;
    }

    @Override
    protected SqlTypeDescriptor getSqlTypeDescriptorOverride(int sqlCode) {
        return sqlCode == -6 ? SmallIntSqlDescriptor.INSTANCE : super.getSqlTypeDescriptorOverride(sqlCode);
    }

    @Override
    public int getInExpressionCountLimit() {
        return 2100;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return new SQLServerIdentityColumnSupport();
    }
}

