/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.SQLException;
import java.util.Map;
import org.hibernate.JDBCException;
import org.hibernate.LockOptions;
import org.hibernate.dialect.SybaseASE15Dialect;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.SybaseASE157LimitHandler;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.query.sqm.produce.function.SqmFunctionRegistry;
import org.hibernate.sql.ForUpdateFragment;
import org.hibernate.type.spi.StandardSpiBasicTypes;

public class SybaseASE157Dialect
extends SybaseASE15Dialect {
    private static final SybaseASE157LimitHandler LIMIT_HANDLER = new SybaseASE157LimitHandler();

    @Override
    public void initializeFunctionRegistry(SqmFunctionRegistry registry) {
        super.initializeFunctionRegistry(registry);
        registry.registerPattern("create_locator", "create_locator(?1, ?2)", StandardSpiBasicTypes.BINARY);
        registry.registerPattern("locator_literal", "locator_literal(?1, ?2)", StandardSpiBasicTypes.BINARY);
        registry.registerPattern("locator_valid", "locator_valid(?1)", StandardSpiBasicTypes.BOOLEAN);
        registry.registerPattern("return_lob", "return_lob(?1, ?2)", StandardSpiBasicTypes.BINARY);
        registry.registerPattern("setdata", "setdata(?1, ?2, ?3)", StandardSpiBasicTypes.BOOLEAN);
        registry.registerPattern("charindex", "charindex(?1, ?2, ?3)", StandardSpiBasicTypes.INTEGER);
    }

    @Override
    public String getTableTypeString() {
        return " lock datarows";
    }

    @Override
    public boolean supportsExpectedLobUsagePattern() {
        return true;
    }

    @Override
    public boolean supportsLobValueChangePropogation() {
        return false;
    }

    @Override
    public boolean forUpdateOfColumns() {
        return true;
    }

    @Override
    public String getForUpdateString() {
        return " for update";
    }

    @Override
    public String getForUpdateString(String aliases) {
        return this.getForUpdateString() + " of " + aliases;
    }

    @Override
    public String appendLockHint(LockOptions mode, String tableName) {
        return tableName;
    }

    @Override
    public String applyLocksToSql(String sql, LockOptions aliasedLockOptions, Map<String, String[]> keyColumnNames) {
        return sql + new ForUpdateFragment(this, aliasedLockOptions, keyColumnNames).toFragmentString();
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return new SQLExceptionConversionDelegate(){

            @Override
            public JDBCException convert(SQLException sqlException, String message, String sql) {
                String sqlState = JdbcExceptionHelper.extractSqlState(sqlException);
                int errorCode = JdbcExceptionHelper.extractErrorCode(sqlException);
                if ("JZ0TO".equals(sqlState) || "JZ006".equals(sqlState)) {
                    throw new LockTimeoutException(message, sqlException, sql);
                }
                if (515 == errorCode && "ZZZZZ".equals(sqlState)) {
                    String constraintName = SybaseASE157Dialect.this.getViolatedConstraintNameExtracter().extractConstraintName(sqlException);
                    return new ConstraintViolationException(message, sqlException, sql, constraintName);
                }
                return null;
            }
        };
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsLimitOffset() {
        return false;
    }

    @Override
    public LimitHandler getLimitHandler() {
        return LIMIT_HANDLER;
    }
}

