/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.dialect.SybaseDialect;
import org.hibernate.query.sqm.produce.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.produce.function.spi.AnsiTrimEmulationFunctionTemplate;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.spi.TinyIntSqlDescriptor;
import org.hibernate.type.spi.StandardSpiBasicTypes;

public class SybaseASE15Dialect
extends SybaseDialect {
    public SybaseASE15Dialect() {
        this.registerColumnType(-4, "image");
        this.registerColumnType(-1, "text");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(91, "date");
        this.registerColumnType(3, "numeric($p,$s)");
        this.registerColumnType(92, "time");
        this.registerColumnType(7, "real");
        this.registerColumnType(16, "tinyint");
        this.registerSybaseKeywords();
    }

    @Override
    public void initializeFunctionRegistry(SqmFunctionRegistry registry) {
        super.initializeFunctionRegistry(registry);
        registry.registerPattern("second", "datepart(second, ?1)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("minute", "datepart(minute, ?1)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("hour", "datepart(hour, ?1)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("extract", "datepart(?1, ?3)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("mod", "?1 % ?2", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("bit_length", "datalength(?1) * 8", StandardSpiBasicTypes.INTEGER);
        registry.register("trim", new AnsiTrimEmulationFunctionTemplate("ltrim", "rtrim", "str_replace"));
        registry.registerPattern("atan2", "atn2(?1, ?2)", StandardSpiBasicTypes.DOUBLE);
        registry.registerPattern("atn2", "atn2(?1, ?2)", StandardSpiBasicTypes.DOUBLE);
        registry.registerPattern("biginttohex", "biginttohext(?1)", StandardSpiBasicTypes.STRING);
        registry.registerPattern("char_length", "char_length(?1)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("charindex", "charindex(?1, ?2)", StandardSpiBasicTypes.INTEGER);
        registry.varArgsBuilder("coalesce", "coalesce(", ",", ")").register();
        registry.registerPattern("col_length", "col_length(?1, ?2)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("col_name", "col_name(?1, ?2)", StandardSpiBasicTypes.STRING);
        registry.registerNoArgs("current_time", StandardSpiBasicTypes.TIME);
        registry.registerNoArgs("current_date", StandardSpiBasicTypes.DATE);
        registry.registerPattern("data_pages", "data_pages(?1, ?2)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("data_pages", "data_pages(?1, ?2, ?3)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("data_pages", "data_pages(?1, ?2, ?3, ?4)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("datalength", "datalength(?1)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("dateadd", "dateadd(?1, ?2, ?3)", StandardSpiBasicTypes.TIMESTAMP);
        registry.registerPattern("datediff", "datediff(?1, ?2, ?3)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("datepart", "datepart(?1, ?2)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("datetime", "datetime", StandardSpiBasicTypes.TIMESTAMP);
        registry.registerPattern("db_id", "db_id(?1)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("difference", "difference(?1,?2)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("db_name", "db_name(?1)", StandardSpiBasicTypes.STRING);
        registry.registerPattern("has_role", "has_role(?1, ?2)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("hextobigint", "hextobigint(?1)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("hextoint", "hextoint(?1)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("host_id", "host_id", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("host_name", "host_name", StandardSpiBasicTypes.STRING);
        registry.registerPattern("inttohex", "inttohex(?1)", StandardSpiBasicTypes.STRING);
        registry.registerPattern("is_quiesced", "is_quiesced(?1)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("is_sec_service_on", "is_sec_service_on(?1)", StandardSpiBasicTypes.BOOLEAN);
        registry.registerPattern("object_id", "object_id(?1)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("object_name", "object_name(?1)", StandardSpiBasicTypes.STRING);
        registry.registerPattern("pagesize", "pagesize(?1)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("pagesize", "pagesize(?1, ?2)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("pagesize", "pagesize(?1, ?2, ?3)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("partition_id", "partition_id(?1, ?2)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("partition_id", "partition_id(?1, ?2, ?3)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("partition_name", "partition_name(?1, ?2)", StandardSpiBasicTypes.STRING);
        registry.registerPattern("partition_name", "partition_name(?1, ?2, ?3)", StandardSpiBasicTypes.STRING);
        registry.registerPattern("patindex", "patindex", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("proc_role", "proc_role", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("role_name", "role_name", StandardSpiBasicTypes.STRING);
        registry.registerPattern("row_count", "row_count", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("rand2", "rand2(?1)", StandardSpiBasicTypes.DOUBLE);
        registry.registerPattern("rand2", "rand2", StandardSpiBasicTypes.DOUBLE);
        registry.registerPattern("replicate", "replicate(?1,?2)", StandardSpiBasicTypes.STRING);
        registry.registerPattern("role_contain", "role_contain", StandardSpiBasicTypes.BOOLEAN);
        registry.registerPattern("role_id", "role_id", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("reserved_pages", "reserved_pages", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("right", "right", StandardSpiBasicTypes.STRING);
        registry.registerPattern("show_role", "show_role", StandardSpiBasicTypes.STRING);
        registry.registerPattern("show_sec_services", "show_sec_services", StandardSpiBasicTypes.STRING);
        registry.registerVarArgs("sortkey", StandardSpiBasicTypes.BINARY, "sortkey(", ",", ")");
        registry.registerPattern("soundex", "sounded", StandardSpiBasicTypes.STRING);
        registry.registerPattern("stddev", "stddev", StandardSpiBasicTypes.DOUBLE);
        registry.registerPattern("stddev_pop", "stddev_pop", StandardSpiBasicTypes.DOUBLE);
        registry.registerPattern("stddev_samp", "stddev_samp", StandardSpiBasicTypes.DOUBLE);
        registry.registerPattern("stuff", "stuff", StandardSpiBasicTypes.STRING);
        registry.registerVarArgs("substring", StandardSpiBasicTypes.STRING, "substring(", ",", ")");
        registry.registerPattern("suser_id", "suser_id", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("suser_name", "suser_name", StandardSpiBasicTypes.STRING);
        registry.registerPattern("tempdb_id", "tempdb_id", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("textvalid", "textvalid", StandardSpiBasicTypes.BOOLEAN);
        registry.registerPattern("to_unichar", "to_unichar(?1)", StandardSpiBasicTypes.STRING);
        registry.registerPattern("tran_dumptable_status", "ran_dumptable_status(?1)", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("uhighsurr", "uhighsurr", StandardSpiBasicTypes.BOOLEAN);
        registry.registerPattern("ulowsurr", "ulowsurr", StandardSpiBasicTypes.BOOLEAN);
        registry.registerPattern("uscalar", "uscalar", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("used_pages", "used_pages", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("user_id", "user_id", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("user_name", "user_name", StandardSpiBasicTypes.STRING);
        registry.registerPattern("valid_name", "valid_name", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("valid_user", "valid_user", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("variance", "variance", StandardSpiBasicTypes.DOUBLE);
        registry.registerPattern("var_pop", "var_pop", StandardSpiBasicTypes.DOUBLE);
        registry.registerPattern("var_samp", "var_samp", StandardSpiBasicTypes.DOUBLE);
        registry.registerNoArgs("sysdate", StandardSpiBasicTypes.TIMESTAMP);
    }

    private void registerSybaseKeywords() {
        this.registerKeyword("add");
        this.registerKeyword("all");
        this.registerKeyword("alter");
        this.registerKeyword("and");
        this.registerKeyword("any");
        this.registerKeyword("arith_overflow");
        this.registerKeyword("as");
        this.registerKeyword("asc");
        this.registerKeyword("at");
        this.registerKeyword("authorization");
        this.registerKeyword("avg");
        this.registerKeyword("begin");
        this.registerKeyword("between");
        this.registerKeyword("break");
        this.registerKeyword("browse");
        this.registerKeyword("bulk");
        this.registerKeyword("by");
        this.registerKeyword("cascade");
        this.registerKeyword("case");
        this.registerKeyword("char_convert");
        this.registerKeyword("check");
        this.registerKeyword("checkpoint");
        this.registerKeyword("close");
        this.registerKeyword("clustered");
        this.registerKeyword("coalesce");
        this.registerKeyword("commit");
        this.registerKeyword("compute");
        this.registerKeyword("confirm");
        this.registerKeyword("connect");
        this.registerKeyword("constraint");
        this.registerKeyword("continue");
        this.registerKeyword("controlrow");
        this.registerKeyword("convert");
        this.registerKeyword("count");
        this.registerKeyword("count_big");
        this.registerKeyword("create");
        this.registerKeyword("current");
        this.registerKeyword("cursor");
        this.registerKeyword("database");
        this.registerKeyword("dbcc");
        this.registerKeyword("deallocate");
        this.registerKeyword("declare");
        this.registerKeyword("decrypt");
        this.registerKeyword("default");
        this.registerKeyword("delete");
        this.registerKeyword("desc");
        this.registerKeyword("determnistic");
        this.registerKeyword("disk");
        this.registerKeyword("distinct");
        this.registerKeyword("drop");
        this.registerKeyword("dummy");
        this.registerKeyword("dump");
        this.registerKeyword("else");
        this.registerKeyword("encrypt");
        this.registerKeyword("end");
        this.registerKeyword("endtran");
        this.registerKeyword("errlvl");
        this.registerKeyword("errordata");
        this.registerKeyword("errorexit");
        this.registerKeyword("escape");
        this.registerKeyword("except");
        this.registerKeyword("exclusive");
        this.registerKeyword("exec");
        this.registerKeyword("execute");
        this.registerKeyword("exist");
        this.registerKeyword("exit");
        this.registerKeyword("exp_row_size");
        this.registerKeyword("external");
        this.registerKeyword("fetch");
        this.registerKeyword("fillfactor");
        this.registerKeyword("for");
        this.registerKeyword("foreign");
        this.registerKeyword("from");
        this.registerKeyword("goto");
        this.registerKeyword("grant");
        this.registerKeyword("group");
        this.registerKeyword("having");
        this.registerKeyword("holdlock");
        this.registerKeyword("identity");
        this.registerKeyword("identity_gap");
        this.registerKeyword("identity_start");
        this.registerKeyword("if");
        this.registerKeyword("in");
        this.registerKeyword("index");
        this.registerKeyword("inout");
        this.registerKeyword("insensitive");
        this.registerKeyword("insert");
        this.registerKeyword("install");
        this.registerKeyword("intersect");
        this.registerKeyword("into");
        this.registerKeyword("is");
        this.registerKeyword("isolation");
        this.registerKeyword("jar");
        this.registerKeyword("join");
        this.registerKeyword("key");
        this.registerKeyword("kill");
        this.registerKeyword("level");
        this.registerKeyword("like");
        this.registerKeyword("lineno");
        this.registerKeyword("load");
        this.registerKeyword("lock");
        this.registerKeyword("materialized");
        this.registerKeyword("max");
        this.registerKeyword("max_rows_per_page");
        this.registerKeyword("min");
        this.registerKeyword("mirror");
        this.registerKeyword("mirrorexit");
        this.registerKeyword("modify");
        this.registerKeyword("national");
        this.registerKeyword("new");
        this.registerKeyword("noholdlock");
        this.registerKeyword("nonclustered");
        this.registerKeyword("nonscrollable");
        this.registerKeyword("non_sensitive");
        this.registerKeyword("not");
        this.registerKeyword("null");
        this.registerKeyword("nullif");
        this.registerKeyword("numeric_truncation");
        this.registerKeyword("of");
        this.registerKeyword("off");
        this.registerKeyword("offsets");
        this.registerKeyword("on");
        this.registerKeyword("once");
        this.registerKeyword("online");
        this.registerKeyword("only");
        this.registerKeyword("open");
        this.registerKeyword("option");
        this.registerKeyword("or");
        this.registerKeyword("order");
        this.registerKeyword("out");
        this.registerKeyword("output");
        this.registerKeyword("over");
        this.registerKeyword("artition");
        this.registerKeyword("perm");
        this.registerKeyword("permanent");
        this.registerKeyword("plan");
        this.registerKeyword("prepare");
        this.registerKeyword("primary");
        this.registerKeyword("print");
        this.registerKeyword("privileges");
        this.registerKeyword("proc");
        this.registerKeyword("procedure");
        this.registerKeyword("processexit");
        this.registerKeyword("proxy_table");
        this.registerKeyword("public");
        this.registerKeyword("quiesce");
        this.registerKeyword("raiserror");
        this.registerKeyword("read");
        this.registerKeyword("readpast");
        this.registerKeyword("readtext");
        this.registerKeyword("reconfigure");
        this.registerKeyword("references");
        this.registerKeyword("remove");
        this.registerKeyword("reorg");
        this.registerKeyword("replace");
        this.registerKeyword("replication");
        this.registerKeyword("reservepagegap");
        this.registerKeyword("return");
        this.registerKeyword("returns");
        this.registerKeyword("revoke");
        this.registerKeyword("role");
        this.registerKeyword("rollback");
        this.registerKeyword("rowcount");
        this.registerKeyword("rows");
        this.registerKeyword("rule");
        this.registerKeyword("save");
        this.registerKeyword("schema");
        this.registerKeyword("scroll");
        this.registerKeyword("scrollable");
        this.registerKeyword("select");
        this.registerKeyword("semi_sensitive");
        this.registerKeyword("set");
        this.registerKeyword("setuser");
        this.registerKeyword("shared");
        this.registerKeyword("shutdown");
        this.registerKeyword("some");
        this.registerKeyword("statistics");
        this.registerKeyword("stringsize");
        this.registerKeyword("stripe");
        this.registerKeyword("sum");
        this.registerKeyword("syb_identity");
        this.registerKeyword("syb_restree");
        this.registerKeyword("syb_terminate");
        this.registerKeyword("top");
        this.registerKeyword("table");
        this.registerKeyword("temp");
        this.registerKeyword("temporary");
        this.registerKeyword("textsize");
        this.registerKeyword("to");
        this.registerKeyword("tracefile");
        this.registerKeyword("tran");
        this.registerKeyword("transaction");
        this.registerKeyword("trigger");
        this.registerKeyword("truncate");
        this.registerKeyword("tsequal");
        this.registerKeyword("union");
        this.registerKeyword("unique");
        this.registerKeyword("unpartition");
        this.registerKeyword("update");
        this.registerKeyword("use");
        this.registerKeyword("user");
        this.registerKeyword("user_option");
        this.registerKeyword("using");
        this.registerKeyword("values");
        this.registerKeyword("varying");
        this.registerKeyword("view");
        this.registerKeyword("waitfor");
        this.registerKeyword("when");
        this.registerKeyword("where");
        this.registerKeyword("while");
        this.registerKeyword("with");
        this.registerKeyword("work");
        this.registerKeyword("writetext");
        this.registerKeyword("xmlextract");
        this.registerKeyword("xmlparse");
        this.registerKeyword("xmltest");
        this.registerKeyword("xmlvalidate");
    }

    @Override
    public boolean supportsCascadeDelete() {
        return false;
    }

    @Override
    public int getMaxAliasLength() {
        return 30;
    }

    @Override
    public boolean areStringComparisonsCaseInsensitive() {
        return true;
    }

    @Override
    public String getCurrentTimestampSQLFunctionName() {
        return "getdate()";
    }

    @Override
    public boolean supportsExpectedLobUsagePattern() {
        return false;
    }

    @Override
    public String getCrossJoinSeparator() {
        return ", ";
    }

    @Override
    protected SqlTypeDescriptor getSqlTypeDescriptorOverride(int sqlCode) {
        return sqlCode == 16 ? TinyIntSqlDescriptor.INSTANCE : super.getSqlTypeDescriptorOverride(sqlCode);
    }

    @Override
    public boolean supportsLockTimeouts() {
        return false;
    }
}

