/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.model.domain.spi.AllowableFunctionReturnType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.spi.AbstractSelfRenderingFunctionTemplate;
import org.hibernate.query.sqm.produce.function.spi.SelfRenderingFunctionSupport;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.sql.ast.consume.spi.SqlAppender;
import org.hibernate.sql.ast.consume.spi.SqlAstWalker;
import org.hibernate.sql.ast.tree.expression.Expression;

public class ConvertFunctionTemplate
extends AbstractSelfRenderingFunctionTemplate
implements SelfRenderingFunctionSupport {
    public ConvertFunctionTemplate() {
        super(StandardArgumentsValidators.between(2, 3));
    }

    @Override
    public void render(SqlAppender sqlAppender, List<Expression> sqlAstArguments, SqlAstWalker walker, SessionFactoryImplementor sessionFactory) {
        int argCount = sqlAstArguments.size();
        if (argCount == 2) {
            sqlAppender.appendSql("{fn convert(");
            sqlAstArguments.get(0).accept(walker);
            sqlAppender.appendSql(", ");
            sqlAstArguments.get(1).accept(walker);
            sqlAppender.appendSql(")}");
        } else if (argCount != 3) {
            sqlAppender.appendSql("convert(");
            sqlAstArguments.get(0).accept(walker);
            sqlAppender.appendSql(", ");
            sqlAstArguments.get(1).accept(walker);
            sqlAppender.appendSql(",");
            sqlAstArguments.get(2).accept(walker);
            sqlAppender.appendSql(")");
        } else {
            throw new QueryException("convert() requires two or three arguments");
        }
    }

    @Override
    protected SelfRenderingFunctionSupport getRenderingFunctionSupport(List<SqmExpression> arguments, AllowableFunctionReturnType impliedResultType) {
        int argCount = arguments.size();
        if (argCount < 2 || argCount > 3) {
            throw new QueryException("convert() requires two or three arguments");
        }
        return this;
    }
}

