/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.metamodel.model.domain.spi.AllowableFunctionReturnType;
import org.hibernate.query.sqm.produce.function.SqmFunctionTemplate;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.function.SqmSubstringFunction;
import org.hibernate.sql.ast.produce.metamodel.spi.BasicValuedExpressableType;
import org.hibernate.type.spi.StandardSpiBasicTypes;

public class DB2SubstringFunctionTemplate
implements SqmFunctionTemplate {
    private static final Set<String> possibleStringUnits = new HashSet<String>(Arrays.asList("CODEUNITS16", "CODEUNITS32", "OCTETS"));

    protected String getRenderedName(List arguments) {
        String lastArgument = (String)arguments.get(arguments.size() - 1);
        if (lastArgument != null && possibleStringUnits.contains(lastArgument.toUpperCase())) {
            return "substring";
        }
        return "substr";
    }

    @Override
    public SqmExpression makeSqmFunctionExpression(List<SqmExpression> arguments, AllowableFunctionReturnType impliedResultType) {
        return new DB2SubstringFunction(this.getRenderedName(arguments), StandardSpiBasicTypes.STRING, arguments.get(1), arguments.get(2), null);
    }

    public static class DB2SubstringFunction
    extends SqmSubstringFunction {
        String functionName;

        public DB2SubstringFunction(String functionName, BasicValuedExpressableType resultType, SqmExpression source, SqmExpression startPosition, SqmExpression length) {
            super(resultType, source, startPosition, length);
            this.functionName = functionName;
        }

        @Override
        public String getFunctionName() {
            return this.functionName;
        }
    }
}

