/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.model.domain.spi.AllowableFunctionReturnType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.produce.function.spi.AbstractSelfRenderingFunctionTemplate;
import org.hibernate.query.sqm.produce.function.spi.SelfRenderingFunctionSupport;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.sql.ast.consume.spi.SqlAppender;
import org.hibernate.sql.ast.consume.spi.SqlAstWalker;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.spi.StandardSpiBasicTypes;

public class IngresSubstringFunction
extends AbstractSelfRenderingFunctionTemplate
implements SelfRenderingFunctionSupport {
    public static final IngresSubstringFunction INSTANCE = new IngresSubstringFunction();

    public IngresSubstringFunction() {
        super(StandardFunctionReturnTypeResolvers.invariant(StandardSpiBasicTypes.STRING), StandardArgumentsValidators.between(2, 3));
    }

    @Override
    protected SelfRenderingFunctionSupport getRenderingFunctionSupport(List<SqmExpression> arguments, AllowableFunctionReturnType resolvedReturnType) {
        return this;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<Expression> sqlAstArguments, SqlAstWalker walker, SessionFactoryImplementor sessionFactory) {
        sqlAppender.appendSql("substring(");
        sqlAstArguments.get(0).accept(walker);
        sqlAppender.appendSql(" from ");
        sqlAstArguments.get(1).accept(walker);
        if (sqlAstArguments.size() == 3) {
            sqlAppender.appendSql(" for ");
            sqlAstArguments.get(2).accept(walker);
        }
        sqlAppender.appendSql(")");
    }
}

