/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.Arrays;
import java.util.List;
import org.hibernate.dialect.function.SqmFunctionProducer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.model.domain.spi.AllowableFunctionReturnType;
import org.hibernate.query.BinaryArithmeticOperator;
import org.hibernate.query.sqm.produce.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.produce.function.SqmFunctionTemplate;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.internal.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.produce.function.spi.AbstractSqmFunctionTemplate;
import org.hibernate.query.sqm.produce.function.spi.SelfRenderingFunctionSupport;
import org.hibernate.query.sqm.produce.function.spi.SqmFunctionRegistryAware;
import org.hibernate.query.sqm.tree.expression.LiteralHelper;
import org.hibernate.query.sqm.tree.expression.SqmBinaryArithmetic;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmTuple;
import org.hibernate.query.sqm.tree.expression.function.SqmNonStandardFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmSubstringFunction;
import org.hibernate.sql.ast.consume.spi.SqlAppender;
import org.hibernate.sql.ast.consume.spi.SqlAstWalker;
import org.hibernate.sql.ast.produce.metamodel.spi.BasicValuedExpressableType;
import org.hibernate.sql.ast.produce.spi.SqlAstFunctionProducer;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.hibernate.type.spi.StandardSpiBasicTypes;

public class LocateEmulationUsingPositionAndSubstring
extends AbstractSqmFunctionTemplate
implements SqmFunctionRegistryAware {
    private final SqmFunctionProducer positionFunctionProducer;
    private final SqmFunctionProducer substringFunctionProducer;
    private SqmFunctionRegistry registry;

    public LocateEmulationUsingPositionAndSubstring() {
        this((SqmFunctionRegistry registry, AllowableFunctionReturnType type, List<SqmExpression> arguments) -> {
            SqmFunctionTemplate template = registry.findFunctionTemplate("substring");
            if (template == null) {
                return new SqmSubstringFunction((BasicValuedExpressableType)type, (SqmExpression)arguments.get(1), (SqmExpression)arguments.get(2), null);
            }
            return template.makeSqmFunctionExpression(arguments, type);
        });
    }

    public LocateEmulationUsingPositionAndSubstring(SqmFunctionProducer substringFunctionProducer) {
        this((SqmFunctionRegistry registry, AllowableFunctionReturnType type, List<SqmExpression> arguments) -> {
            SqmFunctionTemplate template = registry.findFunctionTemplate("substring");
            if (template == null) {
                return new PositionFunction((SqmExpression)arguments.get(0), (SqmExpression)arguments.get(1), type);
            }
            return template.makeSqmFunctionExpression(arguments, type);
        }, substringFunctionProducer);
    }

    public LocateEmulationUsingPositionAndSubstring(SqmFunctionProducer positionFunctionProducer, SqmFunctionProducer substringFunctionProducer) {
        super(StandardArgumentsValidators.between(2, 3));
        this.positionFunctionProducer = positionFunctionProducer;
        this.substringFunctionProducer = substringFunctionProducer;
    }

    @Override
    protected SqmExpression generateSqmFunctionExpression(List<SqmExpression> arguments, AllowableFunctionReturnType impliedResultType) {
        if (arguments.size() == 2) {
            return this.build3ArgVariation(arguments, impliedResultType);
        }
        return this.build2ArgVariation(arguments, impliedResultType);
    }

    private SqmExpression build3ArgVariation(List<SqmExpression> arguments, AllowableFunctionReturnType impliedResultType) {
        SqmExpression pattern = arguments.get(0);
        SqmExpression string = arguments.get(1);
        SqmExpression start = arguments.get(2);
        SqmExpression substringCall = this.substringFunctionProducer.produce(this.registry, StandardSpiBasicTypes.INTEGER, Arrays.asList(string, start));
        SqmExpression positionCall = this.positionFunctionProducer.produce(this.registry, StandardSpiBasicTypes.INTEGER, Arrays.asList(pattern, substringCall));
        SqmBinaryArithmetic startMinusOne = new SqmBinaryArithmetic(start, BinaryArithmeticOperator.SUBTRACT, LiteralHelper.INTEGER_ONE, StandardSpiBasicTypes.INTEGER);
        SqmBinaryArithmetic positionPluStartMinusOne = new SqmBinaryArithmetic(positionCall, BinaryArithmeticOperator.ADD, startMinusOne, StandardSpiBasicTypes.INTEGER);
        return new SqmTuple((SqmExpression)positionPluStartMinusOne);
    }

    private SqmExpression build2ArgVariation(List<SqmExpression> arguments, AllowableFunctionReturnType impliedResultType) {
        return new PositionFunction(arguments.get(0), arguments.get(1), impliedResultType);
    }

    @Override
    public void injectRegistry(SqmFunctionRegistry registry) {
        this.registry = registry;
    }

    public static class PositionFunction
    extends SelfRenderingSqmFunction
    implements SelfRenderingFunctionSupport,
    SqlAstFunctionProducer,
    SqmNonStandardFunction {
        public PositionFunction(SqmExpression pattern, SqmExpression string, AllowableFunctionReturnType resultType) {
            super(null, Arrays.asList(pattern, string), resultType == null ? StandardSpiBasicTypes.STRING : resultType);
        }

        @Override
        public SelfRenderingFunctionSupport getRenderingSupport() {
            return this;
        }

        @Override
        public void render(SqlAppender sqlAppender, List<Expression> sqlAstArguments, SqlAstWalker walker, SessionFactoryImplementor sessionFactory) {
            sqlAppender.appendSql("position(");
            sqlAstArguments.get(0).accept(walker);
            sqlAppender.appendSql(" in ");
            sqlAstArguments.get(1).accept(walker);
            sqlAppender.appendSql(")");
        }

        @Override
        public JavaTypeDescriptor getJavaTypeDescriptor() {
            return this.getExpressableType().getJavaTypeDescriptor();
        }
    }
}

