/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.model.domain.spi.AllowableFunctionReturnType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.internal.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.produce.function.spi.AbstractSqmFunctionTemplate;
import org.hibernate.query.sqm.produce.function.spi.SelfRenderingFunctionSupport;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.function.SqmNonStandardFunction;
import org.hibernate.sql.ast.consume.spi.SqlAppender;
import org.hibernate.sql.ast.consume.spi.SqlAstWalker;
import org.hibernate.sql.ast.produce.spi.SqlAstFunctionProducer;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;

public class NvlFunctionTemplate
extends AbstractSqmFunctionTemplate {
    public static final NvlFunctionTemplate INSTANCE = new NvlFunctionTemplate();
    public static final String NAME = "nvl";

    public NvlFunctionTemplate() {
        super(StandardArgumentsValidators.exactly(2));
    }

    @Override
    protected SqmExpression generateSqmFunctionExpression(List<SqmExpression> arguments, AllowableFunctionReturnType impliedResultType) {
        return new SqmNvlFunction(arguments.get(0), arguments.get(1), impliedResultType);
    }

    public static class SqmNvlFunction
    extends SelfRenderingSqmFunction
    implements SelfRenderingFunctionSupport,
    SqlAstFunctionProducer,
    SqmNonStandardFunction {
        public SqmNvlFunction(SqmExpression arg1, SqmExpression arg2, AllowableFunctionReturnType impliedResultType) {
            super(Arrays.asList(arg1, arg2), impliedResultType);
        }

        @Override
        public String getFunctionName() {
            return NvlFunctionTemplate.NAME;
        }

        @Override
        public boolean hasArguments() {
            return true;
        }

        @Override
        public String asLoggableText() {
            return String.format(Locale.ROOT, "%s( %s, %s )", NvlFunctionTemplate.NAME, this.getSqmArguments().get(0), this.getSqmArguments().get(1));
        }

        @Override
        public void render(SqlAppender sqlAppender, List<Expression> sqlAstArguments, SqlAstWalker walker, SessionFactoryImplementor sessionFactory) {
            sqlAppender.appendSql("nvl(");
            boolean firstPass = true;
            for (Expression sqlAstArgument : sqlAstArguments) {
                if (!firstPass) {
                    sqlAppender.appendSql(",");
                }
                sqlAstArgument.accept(walker);
                if (!firstPass) continue;
                firstPass = false;
            }
            sqlAppender.appendSql(")");
        }

        @Override
        public JavaTypeDescriptor getJavaTypeDescriptor() {
            return this.getExpressableType().getJavaTypeDescriptor();
        }
    }
}

