/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.List;
import org.hibernate.dialect.function.TemplateRenderer;
import org.hibernate.metamodel.model.domain.spi.AllowableFunctionReturnType;
import org.hibernate.query.sqm.produce.function.SqmFunctionTemplate;
import org.hibernate.query.sqm.produce.function.internal.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.type.Type;

public class SQLFunctionTemplate
implements SqmFunctionTemplate {
    private final Type type;
    private final TemplateRenderer renderer;
    private final boolean hasParenthesesIfNoArgs;

    public SQLFunctionTemplate(Type type, String template) {
        this(type, template, true);
    }

    public SQLFunctionTemplate(Type type, String template, boolean hasParenthesesIfNoArgs) {
        this.type = type;
        this.renderer = new TemplateRenderer(template);
        this.hasParenthesesIfNoArgs = hasParenthesesIfNoArgs;
    }

    public String toString() {
        return this.renderer.getTemplate();
    }

    @Override
    public SqmExpression makeSqmFunctionExpression(List<SqmExpression> arguments, AllowableFunctionReturnType impliedResultType) {
        return new SelfRenderingSqmFunction(this.renderer::render, arguments, impliedResultType);
    }
}

