/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.lock;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.StaleObjectStateException;
import org.hibernate.dialect.lock.AbstractSelectLockingStrategy;
import org.hibernate.dialect.lock.PessimisticEntityLockException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.model.domain.spi.EntityIdentifier;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.Lockable;
import org.hibernate.metamodel.model.domain.spi.VersionDescriptor;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.sql.SimpleSelect;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.exec.spi.BasicExecutionContext;
import org.hibernate.type.spi.TypeConfiguration;

public class PessimisticWriteSelectLockingStrategy
extends AbstractSelectLockingStrategy {
    public PessimisticWriteSelectLockingStrategy(Lockable lockable, LockMode lockMode) {
        super(lockable, lockMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock(Serializable id, Object version, Object object, int timeout, SharedSessionContractImplementor session) {
        String sql = this.determineSql(timeout);
        BasicExecutionContext executionContext = new BasicExecutionContext(session);
        SessionFactoryImplementor factory = session.getFactory();
        TypeConfiguration typeConfiguration = factory.getTypeConfiguration();
        try {
            try {
                PreparedStatement st = session.getJdbcCoordinator().getStatementPreparer().prepareStatement(sql);
                try {
                    AtomicInteger count = new AtomicInteger();
                    EntityIdentifier identifierDescriptor = this.getLockable().getHierarchy().getIdentifierDescriptor();
                    identifierDescriptor.dehydrate(id, (jdbcValue, type, boundColumn) -> {
                        try {
                            type.getJdbcValueBinder().bind(st, count.getAndIncrement(), jdbcValue, executionContext);
                        }
                        catch (SQLException e) {
                            throw session.getJdbcServices().getSqlExceptionHelper().convert(e, "Could not bind id value(s) to lock entity: " + MessageHelper.infoString((EntityTypeDescriptor)this.getLockable(), id, session.getFactory()), sql);
                        }
                    }, Clause.WHERE, session);
                    VersionDescriptor versionDescriptor = this.getLockable().getHierarchy().getVersionDescriptor();
                    if (versionDescriptor != null) {
                        versionDescriptor.dehydrate(versionDescriptor.unresolve(version, session), (jdbcValue, type, boundColumn) -> {
                            try {
                                type.getJdbcValueBinder().bind(st, count.getAndIncrement(), jdbcValue, executionContext);
                            }
                            catch (SQLException e) {
                                throw session.getJdbcServices().getSqlExceptionHelper().convert(e, "Could not bind version value(s) to lock entity: " + MessageHelper.infoString((EntityTypeDescriptor)this.getLockable(), id, session.getFactory()), sql);
                            }
                        }, Clause.WHERE, session);
                    }
                    ResultSet rs = session.getJdbcCoordinator().getResultSetReturn().extract(st);
                    try {
                        if (!rs.next()) {
                            if (factory.getStatistics().isStatisticsEnabled()) {
                                factory.getStatistics().optimisticFailure(this.getLockable().getEntityName());
                            }
                            throw new StaleObjectStateException(this.getLockable().getEntityName(), id);
                        }
                    }
                    finally {
                        session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(rs, st);
                    }
                }
                finally {
                    session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(st);
                    session.getJdbcCoordinator().afterStatementExecution();
                }
            }
            catch (SQLException e) {
                throw session.getJdbcServices().getSqlExceptionHelper().convert(e, "could not lock: " + MessageHelper.infoString((EntityTypeDescriptor)this.getLockable(), id, session.getFactory()), sql);
            }
        }
        catch (JDBCException e) {
            throw new PessimisticEntityLockException(object, "could not obtain pessimistic lock", e);
        }
    }

    @Override
    protected String generateLockString(int lockTimeout) {
        SessionFactoryImplementor factory = this.getLockable().getFactory();
        LockOptions lockOptions = new LockOptions(this.getLockMode());
        lockOptions.setTimeOut(lockTimeout);
        SimpleSelect select = new SimpleSelect(factory.getDialect()).setLockOptions(lockOptions).setTableName(this.getLockable().getRootTableName()).addColumn(this.getLockable().getRootTableIdentifierColumnNames()[0]).addCondition(this.getLockable().getRootTableIdentifierColumnNames(), "=?");
        if (StringHelper.isNotEmpty(this.getLockable().getVersionColumnName())) {
            select.addCondition(this.getLockable().getVersionColumnName(), "=?");
        }
        if (factory.getSessionFactoryOptions().isCommentsEnabled()) {
            select.setComment((Object)((Object)this.getLockMode()) + " lock " + this.getLockable().getEntityName());
        }
        return select.toStatementString();
    }
}

