/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.lock;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.StaleObjectStateException;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.model.domain.spi.EntityIdentifier;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.Lockable;
import org.hibernate.metamodel.model.domain.spi.VersionDescriptor;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.sql.Update;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.exec.spi.BasicExecutionContext;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class UpdateLockingStrategy
implements LockingStrategy {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)UpdateLockingStrategy.class.getName());
    private final Lockable lockable;
    private final LockMode lockMode;
    private final String sql;

    public UpdateLockingStrategy(Lockable lockable, LockMode lockMode) {
        this.lockable = lockable;
        this.lockMode = lockMode;
        if (lockMode.lessThan(LockMode.UPGRADE)) {
            throw new HibernateException("[" + (Object)((Object)lockMode) + "] not valid for update statement");
        }
        if (StringHelper.isEmpty(lockable.getVersionColumnName())) {
            LOG.writeLocksNotSupported(lockable.getEntityName());
            this.sql = null;
        } else {
            this.sql = this.generateLockString();
        }
    }

    public Lockable getLockable() {
        return this.lockable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock(Serializable id, Object version, Object object, int timeout, SharedSessionContractImplementor session) throws StaleObjectStateException, JDBCException {
        if (StringHelper.isEmpty(this.lockable.getVersionColumnName())) {
            throw new HibernateException("write locks via update not supported for non-versioned entities [" + this.lockable.getEntityName() + "]");
        }
        BasicExecutionContext executionContext = new BasicExecutionContext(session);
        SessionFactoryImplementor factory = session.getFactory();
        TypeConfiguration typeConfiguration = factory.getTypeConfiguration();
        PreparedStatement st = session.getJdbcCoordinator().getStatementPreparer().prepareStatement(this.sql);
        try {
            AtomicInteger count = new AtomicInteger();
            VersionDescriptor versionDescriptor = this.lockable.getHierarchy().getVersionDescriptor();
            versionDescriptor.dehydrate(versionDescriptor.unresolve(version, session), (jdbcValue, type, boundColumn) -> {
                try {
                    type.getJdbcValueBinder().bind(st, count.getAndIncrement(), jdbcValue, executionContext);
                }
                catch (SQLException e) {
                    throw session.getJdbcServices().getSqlExceptionHelper().convert(e, "Could not bind version value(s) to lock entity: " + MessageHelper.infoString((EntityTypeDescriptor)this.getLockable(), id, session.getFactory()), this.sql);
                }
            }, Clause.WHERE, session);
            EntityIdentifier identifierDescriptor = this.lockable.getHierarchy().getIdentifierDescriptor();
            identifierDescriptor.dehydrate(id, (jdbcValue, type, boundColumn) -> {
                try {
                    type.getJdbcValueBinder().bind(st, count.getAndIncrement(), jdbcValue, executionContext);
                }
                catch (SQLException e) {
                    throw session.getJdbcServices().getSqlExceptionHelper().convert(e, "Could not bind id value(s) to lock entity: " + MessageHelper.infoString((EntityTypeDescriptor)this.getLockable(), id, session.getFactory()), this.sql);
                }
            }, Clause.WHERE, session);
            int affected = session.getJdbcCoordinator().getResultSetReturn().executeUpdate(st);
            if (affected < 0) {
                if (factory.getStatistics().isStatisticsEnabled()) {
                    factory.getStatistics().optimisticFailure(this.lockable.getEntityName());
                }
                throw new StaleObjectStateException(this.lockable.getEntityName(), id);
            }
        }
        finally {
            session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(st);
            session.getJdbcCoordinator().afterStatementExecution();
        }
    }

    protected String generateLockString() {
        SessionFactoryImplementor factory = this.lockable.getFactory();
        Update update = new Update(factory.getDialect());
        update.setTableName(this.lockable.getRootTableName());
        update.addPrimaryKeyColumns(this.lockable.getRootTableIdentifierColumnNames());
        update.setVersionColumnName(this.lockable.getVersionColumnName());
        update.addColumn(this.lockable.getVersionColumnName());
        if (factory.getSessionFactoryOptions().isCommentsEnabled()) {
            update.setComment((Object)((Object)this.lockMode) + " lock " + this.lockable.getEntityName());
        }
        return update.toStatementString();
    }

    protected LockMode getLockMode() {
        return this.lockMode;
    }
}

