/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.unique;

import java.util.Collection;
import java.util.Map;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.unique.DefaultUniqueDelegate;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.model.relational.spi.ExportableTable;
import org.hibernate.metamodel.model.relational.spi.PhysicalColumn;
import org.hibernate.metamodel.model.relational.spi.UniqueKey;

public class DB2UniqueDelegate
extends DefaultUniqueDelegate {
    public DB2UniqueDelegate(Dialect dialect) {
        super(dialect);
    }

    @Override
    public String getAlterTableToAddUniqueKeyCommand(UniqueKey uniqueKey, JdbcServices jdbcServices) {
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        if (this.hasNullable(uniqueKey)) {
            return DB2UniqueDelegate.buildSqlCreateIndexString(this.dialect, uniqueKey.getName().getText(), jdbcEnvironment.getQualifiedObjectNameFormatter().format(((ExportableTable)uniqueKey.getTable()).getQualifiedTableName(), jdbcEnvironment.getDialect()), uniqueKey.getColumns(), uniqueKey.getColumnOrderMap(), true);
        }
        return super.getAlterTableToAddUniqueKeyCommand(uniqueKey, jdbcServices);
    }

    @Override
    public String getAlterTableToDropUniqueKeyCommand(UniqueKey uniqueKey, JdbcServices jdbcServices) {
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        if (this.hasNullable(uniqueKey)) {
            return this.buildSqlDropIndexString(uniqueKey.getName().getText(), jdbcEnvironment.getQualifiedObjectNameFormatter().format(((ExportableTable)uniqueKey.getTable()).getQualifiedTableName(), jdbcEnvironment.getDialect()));
        }
        return super.getAlterTableToDropUniqueKeyCommand(uniqueKey, jdbcServices);
    }

    private boolean hasNullable(UniqueKey uniqueKey) {
        for (PhysicalColumn column : uniqueKey.getColumns()) {
            if (!column.isNullable()) continue;
            return true;
        }
        return false;
    }

    private String buildSqlDropIndexString(String name, String tableName) {
        return "drop index " + StringHelper.qualify(tableName, name);
    }

    public static String buildSqlCreateIndexString(Dialect dialect, String name, String tableName, Collection<PhysicalColumn> columns, Map<PhysicalColumn, String> columnOrderMap, boolean unique) {
        StringBuilder buf = new StringBuilder("create").append(unique ? " unique" : "").append(" index ").append(dialect.qualifyIndexName() ? name : StringHelper.unqualify(name)).append(" on ").append(tableName).append(" (");
        boolean isFirst = true;
        for (PhysicalColumn column : columns) {
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append(", ");
            }
            buf.append(column.getName().render(dialect));
            if (!columnOrderMap.containsKey(column)) continue;
            buf.append(" ").append(columnOrderMap.get(column));
        }
        buf.append(")");
        return buf.toString();
    }
}

