/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.unique;

import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.ExportableTable;
import org.hibernate.metamodel.model.relational.spi.PhysicalColumn;
import org.hibernate.metamodel.model.relational.spi.UniqueKey;

public class DefaultUniqueDelegate
implements UniqueDelegate {
    protected final Dialect dialect;

    public DefaultUniqueDelegate(Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public String getColumnDefinitionUniquenessFragment(Column column) {
        return "";
    }

    @Override
    public String getTableCreationUniqueConstraintsFragment(ExportableTable table) {
        return "";
    }

    @Override
    public String getAlterTableToAddUniqueKeyCommand(UniqueKey uniqueKey, JdbcServices jdbcServices) {
        String tableName = jdbcServices.getJdbcEnvironment().getQualifiedObjectNameFormatter().format(((ExportableTable)uniqueKey.getTable()).getQualifiedTableName(), this.dialect);
        String constraintName = uniqueKey.getName().render(this.dialect);
        return this.dialect.getAlterTableString(tableName) + " add constraint " + constraintName + " " + this.uniqueConstraintSql(uniqueKey);
    }

    @Override
    public String getAlterTableToDropUniqueKeyCommand(UniqueKey uniqueKey, JdbcServices jdbcServices) {
        String tableName = jdbcServices.getJdbcEnvironment().getQualifiedObjectNameFormatter().format(((ExportableTable)uniqueKey.getTable()).getQualifiedTableName(), this.dialect);
        StringBuilder buf = new StringBuilder(this.dialect.getAlterTableString(tableName));
        buf.append(this.getDropUnique());
        if (this.dialect.supportsIfExistsBeforeConstraintName()) {
            buf.append("if exists ");
        }
        buf.append(uniqueKey.getName().render(this.dialect));
        if (this.dialect.supportsIfExistsAfterConstraintName()) {
            buf.append(" if exists");
        }
        return buf.toString();
    }

    protected String getDropUnique() {
        return " drop constraint ";
    }

    protected String uniqueConstraintSql(UniqueKey uniqueKey) {
        StringBuilder sb = new StringBuilder();
        sb.append("unique (");
        boolean isFirst = true;
        for (PhysicalColumn column : uniqueKey.getColumns()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(column.getName().render(this.dialect));
            if (!uniqueKey.getColumnOrderMap().containsKey(column)) continue;
            sb.append(" ").append(uniqueKey.getColumnOrderMap().get(column));
        }
        return sb.append(')').toString();
    }
}

