/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Type;
import org.hibernate.HibernateException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.model.domain.CollectionDomainType;
import org.hibernate.metamodel.model.domain.internal.SingularPersistentAttributeEmbedded;
import org.hibernate.metamodel.model.domain.internal.SingularPersistentAttributeEntity;
import org.hibernate.metamodel.model.domain.internal.entity.SingleTableEntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.BasicTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.CollectionElement;
import org.hibernate.metamodel.model.domain.spi.EmbeddedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.EmbeddedValuedNavigable;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.NonIdPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.PersistentAttributeDescriptor;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.domain.spi.PluralPersistentAttribute;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.sql.ast.produce.metamodel.spi.Joinable;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.descriptor.java.spi.EntityJavaDescriptor;

public final class Cascade {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(Cascade.class);

    private Cascade() {
    }

    public static void cascade(CascadingAction action, CascadePoint cascadePoint, EventSource eventSource, EntityTypeDescriptor descriptor, Object parent) throws HibernateException {
        Cascade.cascade(action, cascadePoint, eventSource, descriptor, parent, null);
    }

    public static void cascade(CascadingAction action, CascadePoint cascadePoint, EventSource eventSource, EntityTypeDescriptor descriptor, Object parent, Object anything) throws HibernateException {
        if (descriptor.hasCascades() || action.requiresNoCascadeChecking()) {
            boolean traceEnabled = LOG.isTraceEnabled();
            if (traceEnabled) {
                LOG.tracev("Processing cascade {0} for: {1}", action, descriptor.getEntityName());
            }
            List persistentAttributes = descriptor.getPersistentAttributes();
            boolean hasUninitializedLazyProperties = descriptor.hasUninitializedLazyProperties(parent);
            boolean componentPathStackDepth = false;
            Object[] propertyValues = descriptor.getPropertyValues(parent);
            for (int i = 0; i < persistentAttributes.size(); ++i) {
                boolean isUninitializedProperty;
                NonIdPersistentAttribute attribute = (NonIdPersistentAttribute)persistentAttributes.get(i);
                CascadeStyle style = attribute.getCascadeStyle();
                boolean bl = isUninitializedProperty = hasUninitializedLazyProperties && !descriptor.getBytecodeEnhancementMetadata().isAttributeLoaded(parent, attribute.getName());
                if (style.doCascade(action)) {
                    Object child;
                    if (isUninitializedProperty) {
                        if (attribute.isCollection()) {
                            throw new NotYetImplementedFor6Exception("cascade uninitialized Collection Property");
                        }
                        if (!action.performOnLazyProperty()) continue;
                        LazyAttributeLoadingInterceptor interceptor = descriptor.getBytecodeEnhancementMetadata().extractInterceptor(parent);
                        child = interceptor.fetchAttribute(parent, attribute.getName());
                    } else {
                        child = propertyValues[i];
                    }
                    Cascade.cascadeProperty(action, cascadePoint, eventSource, 0, parent, child, attribute, style, attribute.getName(), anything, false);
                    continue;
                }
                if (action.requiresNoCascadeChecking()) {
                    action.noCascade(eventSource, parent, descriptor, attribute, i);
                }
                if (!action.deleteOrphans() || isUninitializedProperty) continue;
                Cascade.cascadeLogicalOneToOneOrphanRemoval(action, eventSource, 0, parent, attribute.getPropertyAccess().getGetter().get(parent), attribute, style, attribute.getName(), false);
            }
            if (traceEnabled) {
                LOG.tracev("Done processing cascade {0} for: {1}", action, descriptor.getEntityName());
            }
        }
    }

    private static void cascadeCollectionElementProperty(CascadingAction action, CascadePoint cascadePoint, EventSource eventSource, int componentPathStackDepth, Object parent, Object child, PluralPersistentAttribute attribute, CascadeStyle style, String propertyName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
        if (child != null) {
            Type elementType = attribute.getElementType();
            if (EmbeddedTypeDescriptor.class.isInstance(elementType)) {
                Cascade.cascadeComponent(action, cascadePoint, eventSource, componentPathStackDepth, parent, child, (EmbeddedValuedNavigable)((Object)attribute.getCollectionDescriptor().getElementDescriptor()), anything);
            } else if (!BasicTypeDescriptor.class.isInstance(elementType) && SingleTableEntityTypeDescriptor.class.isInstance(elementType)) {
                SingleTableEntityTypeDescriptor singleTableEntityTypeDescriptor = (SingleTableEntityTypeDescriptor)elementType;
                String entityName = singleTableEntityTypeDescriptor.getPersistenceType() == Type.PersistenceType.ENTITY ? singleTableEntityTypeDescriptor.getEntityName() : null;
                Cascade.cascadeToOne(action, eventSource, parent, child, entityName, style, anything, isCascadeDeleteEnabled);
            }
        }
    }

    private static void cascadeProperty(CascadingAction action, CascadePoint cascadePoint, EventSource eventSource, int componentPathStackDepth, Object parent, Object child, PersistentAttributeDescriptor attribute, CascadeStyle style, String propertyName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
        if (child != null) {
            if (attribute instanceof SingularPersistentAttributeEmbedded) {
                Cascade.cascadeComponent(action, cascadePoint, eventSource, componentPathStackDepth, parent, child, (EmbeddedValuedNavigable)((Object)attribute), anything);
            } else if (Joinable.class.isInstance(attribute) && Cascade.cascadeAssociationNow(cascadePoint, (Joinable)((Object)attribute))) {
                Cascade.cascadeAssociation(action, cascadePoint, eventSource, componentPathStackDepth, parent, child, attribute, style, anything, isCascadeDeleteEnabled);
            }
        }
        Cascade.cascadeLogicalOneToOneOrphanRemoval(action, eventSource, componentPathStackDepth, parent, child, attribute, style, propertyName, isCascadeDeleteEnabled);
    }

    private static void cascadeLogicalOneToOneOrphanRemoval(CascadingAction action, EventSource eventSource, int componentPathStackDepth, Object parent, Object child, PersistentAttributeDescriptor attribute, CascadeStyle style, String propertyName, boolean isCascadeDeleteEnabled) throws HibernateException {
        EntityEntry entry;
        if (Cascade.isLogicalOneToOne(attribute) && style.hasOrphanDelete() && action.deleteOrphans() && (entry = eventSource.getPersistenceContext().getEntry(parent)) != null && entry.getStatus() != Status.SAVING) {
            Object loadedValue = componentPathStackDepth == 0 ? entry.getLoadedValue(propertyName) : null;
            if (child == null || loadedValue != null && child != loadedValue) {
                EntityEntry valueEntry = eventSource.getPersistenceContext().getEntry(loadedValue);
                if (valueEntry == null && loadedValue instanceof HibernateProxy) {
                    loadedValue = eventSource.getPersistenceContext().unproxyAndReassociate(loadedValue);
                    valueEntry = eventSource.getPersistenceContext().getEntry(loadedValue);
                    if (child == loadedValue) {
                        return;
                    }
                }
                if (valueEntry != null) {
                    String entityName = valueEntry.getDescriptor().getEntityName();
                    if (LOG.isTraceEnabled()) {
                        Object id = valueEntry.getDescriptor().getIdentifier(loadedValue);
                        String description = MessageHelper.infoString(entityName, id);
                        LOG.tracev("Deleting orphaned entity instance: {0}", description);
                    }
                    if (attribute instanceof Joinable && ((Joinable)((Object)attribute)).getForeignKeyDirection().equals((Object)ForeignKeyDirection.TO_PARENT)) {
                        eventSource.removeOrphanBeforeUpdates(entityName, loadedValue);
                    } else {
                        eventSource.delete(entityName, loadedValue, isCascadeDeleteEnabled, new HashSet());
                    }
                }
            }
        }
    }

    private static boolean isLogicalOneToOne(PersistentAttributeDescriptor attribute) {
        return attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_ONE;
    }

    private static boolean cascadeAssociationNow(CascadePoint cascadePoint, Joinable attribute) {
        return attribute.getForeignKeyDirection().cascadeNow(cascadePoint);
    }

    private static void cascadeComponent(CascadingAction action, CascadePoint cascadePoint, EventSource eventSource, int componentPathStackDepth, Object parent, Object child, EmbeddedValuedNavigable attribute, Object anything) {
        Object[] children = null;
        EmbeddedTypeDescriptor embeddedDescriptor = attribute.getEmbeddedDescriptor();
        List<NonIdPersistentAttribute> attributes = embeddedDescriptor.getPersistentAttributes();
        for (int i = 0; i < attributes.size(); ++i) {
            PersistentAttributeDescriptor subattribute = attributes.get(i);
            CascadeStyle componentPropertyStyle = embeddedDescriptor.getCascadeStyle(i);
            String subPropertyName = subattribute.getName();
            if (!componentPropertyStyle.doCascade(action)) continue;
            if (children == null) {
                children = embeddedDescriptor.getPropertyValues(child);
            }
            Cascade.cascadeProperty(action, cascadePoint, eventSource, componentPathStackDepth + 1, parent, children[i], subattribute, componentPropertyStyle, subPropertyName, anything, false);
        }
    }

    private static void cascadeAssociation(CascadingAction action, CascadePoint cascadePoint, EventSource eventSource, int componentPathStackDepth, Object parent, Object child, PersistentAttributeDescriptor attribute, CascadeStyle style, Object anything, boolean isCascadeDeleteEnabled) {
        if (SingularPersistentAttributeEntity.class.isInstance(attribute)) {
            String entityName = attribute.getPersistenceType() == Type.PersistenceType.ENTITY ? ((SingularPersistentAttributeEntity)attribute).getEntityName() : null;
            Cascade.cascadeToOne(action, eventSource, parent, child, entityName, style, anything, isCascadeDeleteEnabled);
        } else if (PluralPersistentAttribute.class.isInstance(attribute)) {
            Cascade.cascadeCollection(action, cascadePoint, eventSource, componentPathStackDepth, parent, child, style, anything, (PluralPersistentAttribute)attribute);
        }
    }

    private static void cascadeCollection(CascadingAction action, CascadePoint cascadePoint, EventSource eventSource, int componentPathStackDepth, Object parent, Object child, CascadeStyle style, Object anything, PluralPersistentAttribute attribute) {
        CollectionDomainType.Element collectionElement = attribute.getPersistentCollectionDescriptor().getElementDescriptor();
        PersistentCollectionDescriptor descriptor = eventSource.getFactory().getMetamodel().findCollectionDescriptor(attribute.getNavigableRole());
        CascadePoint elementsCascadePoint = cascadePoint;
        if (cascadePoint == CascadePoint.AFTER_INSERT_BEFORE_DELETE) {
            elementsCascadePoint = CascadePoint.AFTER_INSERT_BEFORE_DELETE_VIA_COLLECTION;
        }
        if (collectionElement.getClassification() != CollectionElement.ElementClassification.BASIC) {
            Cascade.cascadeCollectionElements(action, elementsCascadePoint, eventSource, componentPathStackDepth, parent, child, attribute, style, (CollectionElement)collectionElement, anything, descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cascadeToOne(CascadingAction action, EventSource eventSource, Object parent, Object child, String entityName, CascadeStyle style, Object anything, boolean isCascadeDeleteEnabled) {
        if (style.reallyDoCascade(action)) {
            eventSource.getPersistenceContext().addChildParent(child, parent);
            try {
                action.cascade(eventSource, child, entityName, anything, isCascadeDeleteEnabled);
            }
            finally {
                eventSource.getPersistenceContext().removeChildParent(child);
            }
        }
    }

    private static void cascadeCollectionElements(CascadingAction action, CascadePoint cascadePoint, EventSource eventSource, int componentPathStackDepth, Object parent, Object child, PluralPersistentAttribute attribute, CascadeStyle style, CollectionElement collectionElement, Object anything, PersistentCollectionDescriptor descriptor) throws HibernateException {
        boolean deleteOrphans;
        boolean reallyDoCascade;
        boolean bl = reallyDoCascade = style.reallyDoCascade(action) && child != PersistentCollectionDescriptor.UNFETCHED_COLLECTION;
        if (reallyDoCascade) {
            boolean traceEnabled = LOG.isTraceEnabled();
            if (traceEnabled) {
                LOG.tracev("Cascade {0} for collection: {1}", action, attribute.getNavigableName());
            }
            Iterator itr = action.getCascadableChildrenIterator(eventSource, descriptor, child);
            while (itr.hasNext()) {
                Cascade.cascadeCollectionElementProperty(action, cascadePoint, eventSource, componentPathStackDepth, parent, itr.next(), attribute, style, null, anything, descriptor.isCascadeDeleteEnabled());
            }
            if (traceEnabled) {
                LOG.tracev("Done cascade {0} for collection: {1}", action, attribute.getNavigableName());
            }
        }
        boolean bl2 = deleteOrphans = style.hasOrphanDelete() && action.deleteOrphans() && collectionElement.getJavaTypeDescriptor() instanceof EntityJavaDescriptor && child instanceof PersistentCollection;
        if (deleteOrphans) {
            boolean traceEnabled = LOG.isTraceEnabled();
            if (traceEnabled) {
                LOG.tracev("Deleting orphans for collection: {0}", attribute.getNavigableName());
            }
            String entityName = ((EntityJavaDescriptor)collectionElement.getJavaTypeDescriptor()).getEntityName();
            Cascade.deleteOrphans(eventSource, entityName, (PersistentCollection)child);
            if (traceEnabled) {
                LOG.tracev("Done deleting orphans for collection: {0}", attribute.getNavigableName());
            }
        }
    }

    private static void deleteOrphans(EventSource eventSource, String entityName, PersistentCollection pc) throws HibernateException {
        CollectionEntry ce;
        Collection orphans = pc.wasInitialized() ? ((ce = eventSource.getPersistenceContext().getCollectionEntry(pc)) == null ? Collections.EMPTY_LIST : ce.getOrphans(entityName, pc)) : pc.getQueuedOrphans(entityName);
        for (Object orphan : orphans) {
            if (orphan == null) continue;
            LOG.tracev("Deleting orphaned entity instance: {0}", entityName);
            eventSource.delete(entityName, orphan, false, new HashSet());
        }
    }
}

