/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.DelayedPostInsertIdentifier;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.domain.spi.PluralPersistentAttribute;
import org.hibernate.pretty.MessageHelper;
import org.jboss.logging.Logger;

public final class Collections {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)Collections.class.getName());

    public static void processUnreachableCollection(PersistentCollection coll, SessionImplementor session) {
        if (coll.getOwner() == null) {
            Collections.processNeverReferencedCollection(coll, session);
        } else {
            Collections.processDereferencedCollection(coll, session);
        }
    }

    private static void processDereferencedCollection(PersistentCollection coll, SessionImplementor session) {
        boolean hasOrphanDelete;
        PersistenceContext persistenceContext = session.getPersistenceContext();
        CollectionEntry entry = persistenceContext.getCollectionEntry(coll);
        PersistentCollectionDescriptor loadedDescriptor = entry.getLoadedCollectionDescriptor();
        if (loadedDescriptor != null && LOG.isDebugEnabled()) {
            LOG.debugf("Collection dereferenced: %s", MessageHelper.collectionInfoString(loadedDescriptor, coll, entry.getLoadedKey(), (SharedSessionContractImplementor)session));
        }
        boolean bl = hasOrphanDelete = loadedDescriptor != null && loadedDescriptor.hasOrphanDelete();
        if (hasOrphanDelete) {
            EntityKey key;
            Object owner;
            EntityTypeDescriptor ownerEntityDescriptor = Collections.getOwnerEntityDescriptor(loadedDescriptor, session.getSessionFactory());
            Object ownerId = ownerEntityDescriptor.getIdentifier(coll.getOwner());
            if (ownerId == null) {
                EntityEntry ownerEntry;
                if (session.getFactory().getSessionFactoryOptions().isIdentifierRollbackEnabled() && (ownerEntry = persistenceContext.getEntry(coll.getOwner())) != null) {
                    ownerId = ownerEntry.getId();
                }
                if (ownerId == null) {
                    throw new AssertionFailure("Unable to determine collection owner identifier for orphan-delete processing");
                }
            }
            if ((owner = persistenceContext.getEntity(key = session.generateEntityKey(ownerId, ownerEntityDescriptor))) == null) {
                throw new AssertionFailure("collection owner not associated with session: " + loadedDescriptor.getNavigableRole());
            }
            EntityEntry e = persistenceContext.getEntry(owner);
            if (e != null && e.getStatus() != Status.DELETED && e.getStatus() != Status.GONE) {
                throw new HibernateException("A collection with cascade=\"all-delete-orphan\" was no longer referenced by the owning entity instance: " + loadedDescriptor.getNavigableRole());
            }
        }
        entry.setCurrentDescriptor(null);
        entry.setCurrentKey(null);
        Collections.prepareCollectionForUpdate(coll, entry);
    }

    private static void processNeverReferencedCollection(PersistentCollection coll, SessionImplementor session) throws HibernateException {
        PersistenceContext persistenceContext = session.getPersistenceContext();
        CollectionEntry entry = persistenceContext.getCollectionEntry(coll);
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Found collection with unloaded owner: %s", MessageHelper.collectionInfoString(entry.getLoadedCollectionDescriptor(), coll, entry.getLoadedKey(), (SharedSessionContractImplementor)session));
        }
        entry.setCurrentDescriptor(entry.getLoadedCollectionDescriptor());
        entry.setCurrentKey(entry.getLoadedKey());
        Collections.prepareCollectionForUpdate(coll, entry);
    }

    public static void processReachableCollection(PersistentCollection collection, PluralPersistentAttribute collectionAttribute, Object entity, SessionImplementor session) {
        collection.setOwner(entity);
        CollectionEntry ce = session.getPersistenceContext().getCollectionEntry(collection);
        if (ce == null) {
            throw new HibernateException("Found two representations of same collection: " + collectionAttribute.getNavigableName());
        }
        SessionFactoryImplementor factory = session.getFactory();
        ce.setCurrentDescriptor(collectionAttribute.getCollectionDescriptor());
        ce.setCurrentKey(collectionAttribute.getCollectionDescriptor().getKeyOfOwner(entity, session));
        EntityTypeDescriptor ownerEntityDescriptor = Collections.getOwnerEntityDescriptor(collectionAttribute.getCollectionDescriptor(), factory);
        boolean isBytecodeEnhanced = ownerEntityDescriptor.getBytecodeEnhancementMetadata().isEnhancedForLazyLoading();
        if (isBytecodeEnhanced && !collection.wasInitialized()) {
            LOG.debugf("Skipping uninitialized bytecode-lazy collection: %s", MessageHelper.collectionInfoString(collectionAttribute.getCollectionDescriptor(), collection, ce.getCurrentKey(), (SharedSessionContractImplementor)session));
            ce.setReached(true);
            ce.setProcessed(true);
        } else {
            if (ce.isReached()) {
                throw new HibernateException("Found shared references to a collection: " + collectionAttribute.getCollectionDescriptor().getNavigableRole().getFullPath());
            }
            ce.setReached(true);
            if (LOG.isDebugEnabled()) {
                if (collection.wasInitialized()) {
                    LOG.debugf("Collection found: %s, was: %s (initialized)", MessageHelper.collectionInfoString(collectionAttribute.getCollectionDescriptor(), collection, ce.getCurrentKey(), (SharedSessionContractImplementor)session), MessageHelper.collectionInfoString(ce.getLoadedCollectionDescriptor(), collection, ce.getLoadedKey(), (SharedSessionContractImplementor)session));
                } else {
                    LOG.debugf("Collection found: %s, was: %s (uninitialized)", MessageHelper.collectionInfoString(collectionAttribute.getCollectionDescriptor(), collection, ce.getCurrentKey(), (SharedSessionContractImplementor)session), MessageHelper.collectionInfoString(ce.getLoadedCollectionDescriptor(), collection, ce.getLoadedKey(), (SharedSessionContractImplementor)session));
                }
            }
            Collections.prepareCollectionForUpdate(collection, ce);
        }
    }

    private static EntityTypeDescriptor getOwnerEntityDescriptor(PersistentCollectionDescriptor descriptor, SessionFactoryImplementor factory) {
        return descriptor.findFirstEntityDescriptor();
    }

    private static void prepareCollectionForUpdate(PersistentCollection collection, CollectionEntry entry) {
        if (entry.isProcessed()) {
            throw new AssertionFailure("collection was processed twice by flush()");
        }
        entry.setProcessed(true);
        PersistentCollectionDescriptor loadedDescriptor = entry.getLoadedCollectionDescriptor();
        PersistentCollectionDescriptor currentDescriptor = entry.getCurrentDescriptor();
        if (loadedDescriptor != null || currentDescriptor != null) {
            boolean ownerChanged;
            boolean keyChanged = currentDescriptor != null && entry != null && !currentDescriptor.getKeyJavaTypeDescriptor().areEqual(entry.getLoadedKey(), entry.getCurrentKey()) && !(entry.getLoadedKey() instanceof DelayedPostInsertIdentifier);
            boolean bl = ownerChanged = loadedDescriptor != currentDescriptor || keyChanged;
            if (ownerChanged) {
                boolean orphanDeleteAndRoleChanged;
                boolean bl2 = orphanDeleteAndRoleChanged = loadedDescriptor != null && currentDescriptor != null && loadedDescriptor.hasOrphanDelete();
                if (orphanDeleteAndRoleChanged) {
                    throw new HibernateException("Don't change the reference to a collection with delete-orphan enabled : " + loadedDescriptor.getNavigableRole().getFullPath());
                }
                if (currentDescriptor != null) {
                    entry.setDorecreate(true);
                }
                if (loadedDescriptor != null) {
                    entry.setDoremove(true);
                    if (entry.isDorecreate()) {
                        LOG.trace("Forcing collection initialization");
                        collection.forceInitialization();
                    }
                }
            } else if (collection.isDirty()) {
                entry.setDoupdate(true);
            }
        }
    }

    private Collections() {
    }
}

