/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.util.Iterator;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.TransientObjectException;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.engine.internal.NonNullableTransientDependencies;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.internal.SingularPersistentAttributeEmbedded;
import org.hibernate.metamodel.model.domain.internal.SingularPersistentAttributeEntity;
import org.hibernate.metamodel.model.domain.spi.EmbeddedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.NonIdPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.SingularPersistentAttribute;
import org.hibernate.property.access.internal.PropertyAccessStrategyBackRefImpl;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

@Internal
public final class ForeignKeys<T> {
    public static boolean isNotTransient(String entityName, Object entity, Boolean assumed, SharedSessionContractImplementor session) {
        if (entity instanceof HibernateProxy) {
            return true;
        }
        if (session.getPersistenceContext().isEntryFor(entity)) {
            return true;
        }
        return !ForeignKeys.isTransient(entityName, entity, assumed, session);
    }

    public static boolean isTransient(String entityName, Object entity, Boolean assumed, SharedSessionContractImplementor session) {
        if (entity == LazyPropertyInitializer.UNFETCHED_PROPERTY) {
            return false;
        }
        Boolean isUnsaved = session.getInterceptor().isTransient(entity);
        if (isUnsaved != null) {
            return isUnsaved;
        }
        EntityTypeDescriptor descriptor = session.getEntityDescriptor(entityName, entity);
        isUnsaved = descriptor.isTransient(entity, session);
        if (isUnsaved != null) {
            return isUnsaved;
        }
        if (assumed != null) {
            return assumed;
        }
        Object[] snapshot = session.getPersistenceContext().getDatabaseSnapshot(descriptor.getIdentifier(entity), descriptor);
        return snapshot == null;
    }

    public static Object getEntityIdentifierIfNotUnsaved(String entityName, Object object, SharedSessionContractImplementor session) throws TransientObjectException {
        if (object == null) {
            return null;
        }
        Object id = session.getContextEntityIdentifier(object);
        if (id == null) {
            if (ForeignKeys.isTransient(entityName, object, Boolean.FALSE, session)) {
                throw new TransientObjectException("object references an unsaved transient instance - save the transient instance before flushing: " + (entityName == null ? session.guessEntityName(object) : entityName));
            }
            id = session.getEntityDescriptor(entityName, object).getHierarchy().getIdentifierDescriptor().extractIdentifier(object);
        }
        return id;
    }

    public static NonNullableTransientDependencies findNonNullableTransientEntities(String entityName, Object entity, Object[] values, boolean isEarlyInsert, SharedSessionContractImplementor session) {
        if (values == null) {
            return null;
        }
        NonNullableTransientDependencies nonNullableTransientEntities = new NonNullableTransientDependencies();
        Nullifier nullifier = new Nullifier(entity, false, isEarlyInsert, session);
        EntityTypeDescriptor descriptor = session.getEntityDescriptor(entityName, entity);
        descriptor.visitStateArrayContributors(stateArrayContributor -> {
            Object value = values[stateArrayContributor.getStateArrayPosition()];
            if (value == null) {
                return;
            }
            stateArrayContributor.collectNonNullableTransientEntities(value, nullifier, nonNullableTransientEntities, session);
        });
        return nonNullableTransientEntities.isEmpty() ? null : nonNullableTransientEntities;
    }

    private ForeignKeys() {
    }

    @Internal
    public static class Nullifier {
        private final boolean isDelete;
        private final boolean isEarlyInsert;
        private final SharedSessionContractImplementor session;
        private final Object self;

        public Nullifier(Object self, boolean isDelete, boolean isEarlyInsert, SharedSessionContractImplementor session) {
            this.isDelete = isDelete;
            this.isEarlyInsert = isEarlyInsert;
            this.session = session;
            this.self = self;
        }

        public void nullifyTransientReferences(Object[] values, List<NonIdPersistentAttribute<?, ?>> attributes) {
            int i = 0;
            for (NonIdPersistentAttribute<?, ?> attribute : attributes) {
                values[i] = this.nullifyTransientReferences(values[i], attribute);
                ++i;
            }
        }

        private Object nullifyTransientReferences(Object value, NonIdPersistentAttribute attribute) {
            if (value == null) {
                return null;
            }
            if (attribute instanceof SingularPersistentAttribute) {
                SingularPersistentAttribute.SingularAttributeClassification attributeClassification = ((SingularPersistentAttribute)((Object)attribute)).getAttributeTypeClassification();
                if (attributeClassification == SingularPersistentAttribute.SingularAttributeClassification.ONE_TO_ONE) {
                    return value;
                }
                if (attributeClassification == SingularPersistentAttribute.SingularAttributeClassification.MANY_TO_ONE) {
                    SingularPersistentAttributeEntity singularPersistentAttribute = (SingularPersistentAttributeEntity)attribute;
                    String entityName = singularPersistentAttribute.getEntityName();
                    return this.isNullifiable(entityName, value) ? null : value;
                }
                if (attributeClassification == SingularPersistentAttribute.SingularAttributeClassification.ANY) {
                    return this.isNullifiable(null, value) ? null : value;
                }
                if (attributeClassification == SingularPersistentAttribute.SingularAttributeClassification.EMBEDDED) {
                    SingularPersistentAttributeEmbedded embedded = (SingularPersistentAttributeEmbedded)attribute;
                    EmbeddedTypeDescriptor embeddedDescriptor = embedded.getEmbeddedDescriptor();
                    Iterator<NonIdPersistentAttribute> iterator = embeddedDescriptor.getDeclaredPersistentAttributes().iterator();
                    while (iterator.hasNext()) {
                        NonIdPersistentAttribute subAttribute;
                        Object subAttributeValue = value == PropertyAccessStrategyBackRefImpl.UNKNOWN ? new Object() : subAttribute.getPropertyAccess().getGetter().get(value);
                        Object replacement = this.nullifyTransientReferences(subAttributeValue, subAttribute = iterator.next());
                        if (replacement == subAttributeValue) continue;
                        subAttribute.getPropertyAccess().getSetter().set(value, replacement, null);
                    }
                    return value;
                }
            }
            return value;
        }

        public boolean isNullifiable(String entityName, Object object) throws HibernateException {
            if (object == LazyPropertyInitializer.UNFETCHED_PROPERTY) {
                return false;
            }
            if (object instanceof HibernateProxy) {
                LazyInitializer li = ((HibernateProxy)object).getHibernateLazyInitializer();
                if (li.getImplementation(this.session) == null) {
                    return false;
                }
                object = li.getImplementation(this.session);
            }
            if (object == this.self) {
                return this.isEarlyInsert || this.isDelete && this.session.getFactory().getDialect().hasSelfReferentialForeignKeyBug();
            }
            EntityEntry entityEntry = this.session.getPersistenceContext().getEntry(object);
            if (entityEntry == null) {
                return ForeignKeys.isTransient(entityName, object, null, this.session);
            }
            return entityEntry.isNullifiable(this.isEarlyInsert, this.session);
        }
    }
}

