/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.AssertionFailure;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.engine.internal.CacheHelper;
import org.hibernate.engine.internal.StatefulPersistenceContext;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.NaturalIdDescriptor;
import org.hibernate.stat.internal.StatsHelper;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.jboss.logging.Logger;

public class NaturalIdXrefDelegate {
    private static final Logger LOG = Logger.getLogger(NaturalIdXrefDelegate.class);
    private final StatefulPersistenceContext persistenceContext;
    private final ConcurrentHashMap<EntityTypeDescriptor, NaturalIdResolutionCache> naturalIdResolutionCacheMap = new ConcurrentHashMap();

    public NaturalIdXrefDelegate(StatefulPersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    protected SharedSessionContractImplementor session() {
        return this.persistenceContext.getSession();
    }

    public boolean cacheNaturalIdCrossReference(EntityTypeDescriptor descriptor, Object pk, Object[] naturalIdValues) {
        NaturalIdResolutionCache previousInstance;
        this.validateNaturalId(descriptor, naturalIdValues);
        NaturalIdResolutionCache entityNaturalIdResolutionCache = this.naturalIdResolutionCacheMap.get(descriptor);
        if (entityNaturalIdResolutionCache == null && (previousInstance = this.naturalIdResolutionCacheMap.putIfAbsent(descriptor, entityNaturalIdResolutionCache = new NaturalIdResolutionCache(descriptor))) != null) {
            entityNaturalIdResolutionCache = previousInstance;
        }
        return entityNaturalIdResolutionCache.cache(pk, naturalIdValues);
    }

    public Object[] removeNaturalIdCrossReference(EntityTypeDescriptor entityDescriptor, Object pk, Object[] naturalIdValues) {
        CachedNaturalId cachedNaturalId;
        entityDescriptor = this.locateDescriptorForKey(entityDescriptor);
        this.validateNaturalId(entityDescriptor, naturalIdValues);
        NaturalIdResolutionCache entityNaturalIdResolutionCache = this.naturalIdResolutionCacheMap.get(entityDescriptor);
        Object[] sessionCachedNaturalIdValues = null;
        if (entityNaturalIdResolutionCache != null && (cachedNaturalId = (CachedNaturalId)entityNaturalIdResolutionCache.pkToNaturalIdMap.remove(pk)) != null) {
            entityNaturalIdResolutionCache.naturalIdToPkMap.remove(cachedNaturalId);
            sessionCachedNaturalIdValues = cachedNaturalId.getValues();
        }
        if (entityDescriptor.hasNaturalIdentifier() && entityDescriptor.getHierarchy().getNaturalIdDescriptor().getCacheAccess() != null) {
            NaturalIdDataAccess cacheAccess = entityDescriptor.getHierarchy().getNaturalIdDescriptor().getCacheAccess();
            Object naturalIdCacheKey = cacheAccess.generateCacheKey(naturalIdValues, entityDescriptor.getHierarchy(), this.session());
            cacheAccess.evict(naturalIdCacheKey);
            if (sessionCachedNaturalIdValues != null && !Arrays.equals(sessionCachedNaturalIdValues, naturalIdValues)) {
                Object sessionNaturalIdCacheKey = cacheAccess.generateCacheKey(sessionCachedNaturalIdValues, entityDescriptor.getHierarchy(), this.session());
                cacheAccess.evict(sessionNaturalIdCacheKey);
            }
        }
        return sessionCachedNaturalIdValues;
    }

    public boolean sameAsCached(EntityTypeDescriptor descriptor, Object pk, Object[] naturalIdValues) {
        NaturalIdResolutionCache entityNaturalIdResolutionCache = this.naturalIdResolutionCacheMap.get(descriptor);
        return entityNaturalIdResolutionCache != null && entityNaturalIdResolutionCache.sameAsCached(pk, naturalIdValues);
    }

    protected EntityTypeDescriptor locateDescriptorForKey(EntityTypeDescriptor entityDescriptor) {
        return entityDescriptor.getHierarchy().getRootEntityType();
    }

    protected void validateNaturalId(EntityTypeDescriptor descriptor, Object[] naturalIdValues) {
        if (descriptor.getHierarchy().getNaturalIdDescriptor() == null) {
            throw new IllegalArgumentException("Entity did not define a natural-id");
        }
        if (descriptor.getHierarchy().getNaturalIdDescriptor().getAttributeInfos().size() != naturalIdValues.length) {
            throw new IllegalArgumentException("Mismatch between expected number of natural-id values and found.");
        }
    }

    public Object[] findCachedNaturalId(EntityTypeDescriptor descriptor, Object pk) {
        NaturalIdResolutionCache entityNaturalIdResolutionCache = this.naturalIdResolutionCacheMap.get(descriptor = this.locateDescriptorForKey(descriptor));
        if (entityNaturalIdResolutionCache == null) {
            return null;
        }
        CachedNaturalId cachedNaturalId = (CachedNaturalId)entityNaturalIdResolutionCache.pkToNaturalIdMap.get(pk);
        if (cachedNaturalId == null) {
            return null;
        }
        return cachedNaturalId.getValues();
    }

    public Object findCachedNaturalIdResolution(EntityTypeDescriptor entityDescriptor, Object[] naturalIdValues) {
        NaturalIdDataAccess cacheAccess;
        entityDescriptor = this.locateDescriptorForKey(entityDescriptor);
        this.validateNaturalId(entityDescriptor, naturalIdValues);
        NaturalIdResolutionCache entityNaturalIdResolutionCache = this.naturalIdResolutionCacheMap.get(entityDescriptor);
        Serializable pk = null;
        CachedNaturalId cachedNaturalId = new CachedNaturalId(entityDescriptor, naturalIdValues);
        if (entityNaturalIdResolutionCache != null) {
            pk = (Serializable)entityNaturalIdResolutionCache.naturalIdToPkMap.get(cachedNaturalId);
            if (pk != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Resolved natural key -> primary key resolution in session cache: " + entityDescriptor.getEntityName() + "#[" + Arrays.toString(naturalIdValues) + "]"));
                }
                return pk;
            }
            if (entityNaturalIdResolutionCache.containsInvalidNaturalIdReference(naturalIdValues)) {
                return PersistenceContext.NaturalIdHelper.INVALID_NATURAL_ID_REFERENCE;
            }
        }
        if ((cacheAccess = entityDescriptor.getHierarchy().getNaturalIdDescriptor().getCacheAccess()) == null) {
            return null;
        }
        if (entityDescriptor.hasNaturalIdentifier() && entityDescriptor.getHierarchy().getNaturalIdDescriptor().getCacheAccess() != null) {
            NaturalIdDataAccess naturalIdCacheAccessStrategy = entityDescriptor.getHierarchy().getNaturalIdDescriptor().getCacheAccess();
            Object naturalIdCacheKey = naturalIdCacheAccessStrategy.generateCacheKey(naturalIdValues, entityDescriptor.getHierarchy(), this.session());
            pk = CacheHelper.fromSharedCache(this.session(), naturalIdCacheKey, cacheAccess);
        }
        SessionFactoryImplementor factory = this.session().getFactory();
        if (pk != null) {
            NaturalIdResolutionCache existingCache;
            if (factory.getStatistics().isStatisticsEnabled()) {
                factory.getStatistics().naturalIdCacheHit(StatsHelper.INSTANCE.getRootEntityRole(entityDescriptor), cacheAccess.getRegion().getName());
            }
            if (LOG.isTraceEnabled()) {
                LOG.tracef("Found natural key [%s] -> primary key [%s] xref in second-level cache for %s", (Object)Arrays.toString(naturalIdValues), pk, (Object)entityDescriptor.getEntityName());
            }
            if (entityNaturalIdResolutionCache == null && (existingCache = this.naturalIdResolutionCacheMap.putIfAbsent(entityDescriptor, entityNaturalIdResolutionCache = new NaturalIdResolutionCache(entityDescriptor))) != null) {
                entityNaturalIdResolutionCache = existingCache;
            }
            entityNaturalIdResolutionCache.pkToNaturalIdMap.put(pk, cachedNaturalId);
            entityNaturalIdResolutionCache.naturalIdToPkMap.put(cachedNaturalId, pk);
        } else if (factory.getStatistics().isStatisticsEnabled()) {
            factory.getStatistics().naturalIdCacheMiss(entityDescriptor.getNavigableRole(), cacheAccess.getRegion().getName());
        }
        return pk;
    }

    public Collection<Object> getCachedPkResolutions(EntityTypeDescriptor descriptor) {
        descriptor = this.locateDescriptorForKey(descriptor);
        Set pks = null;
        NaturalIdResolutionCache entityNaturalIdResolutionCache = this.naturalIdResolutionCacheMap.get(descriptor);
        if (entityNaturalIdResolutionCache != null) {
            pks = entityNaturalIdResolutionCache.pkToNaturalIdMap.keySet();
        }
        if (pks == null || pks.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(pks);
    }

    public void stashInvalidNaturalIdReference(EntityTypeDescriptor descriptor, Object[] invalidNaturalIdValues) {
        NaturalIdResolutionCache entityNaturalIdResolutionCache = this.naturalIdResolutionCacheMap.get(descriptor = this.locateDescriptorForKey(descriptor));
        if (entityNaturalIdResolutionCache == null) {
            throw new AssertionFailure("Expecting NaturalIdResolutionCache to exist already for entity " + descriptor.getEntityName());
        }
        entityNaturalIdResolutionCache.stashInvalidNaturalIdReference(invalidNaturalIdValues);
    }

    public void unStashInvalidNaturalIdReferences() {
        for (NaturalIdResolutionCache naturalIdResolutionCache : this.naturalIdResolutionCacheMap.values()) {
            naturalIdResolutionCache.unStashInvalidNaturalIdReferences();
        }
    }

    public void clear() {
        this.naturalIdResolutionCacheMap.clear();
    }

    private static class NaturalIdResolutionCache
    implements Serializable {
        private final EntityTypeDescriptor descriptor;
        private Map<Object, CachedNaturalId> pkToNaturalIdMap = new ConcurrentHashMap<Object, CachedNaturalId>();
        private Map<CachedNaturalId, Object> naturalIdToPkMap = new ConcurrentHashMap<CachedNaturalId, Object>();
        private List<CachedNaturalId> invalidNaturalIdList;

        private NaturalIdResolutionCache(EntityTypeDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public EntityTypeDescriptor getDescriptor() {
            return this.descriptor;
        }

        public boolean sameAsCached(Object pk, Object[] naturalIdValues) {
            if (pk == null) {
                return false;
            }
            CachedNaturalId initial = this.pkToNaturalIdMap.get(pk);
            return initial != null && initial.isSame(naturalIdValues);
        }

        public boolean cache(Object pk, Object[] naturalIdValues) {
            if (pk == null) {
                return false;
            }
            CachedNaturalId initial = this.pkToNaturalIdMap.get(pk);
            if (initial != null) {
                if (initial.isSame(naturalIdValues)) {
                    return false;
                }
                this.naturalIdToPkMap.remove(initial);
            }
            CachedNaturalId cachedNaturalId = new CachedNaturalId(this.descriptor, naturalIdValues);
            this.pkToNaturalIdMap.put(pk, cachedNaturalId);
            this.naturalIdToPkMap.put(cachedNaturalId, pk);
            return true;
        }

        public void stashInvalidNaturalIdReference(Object[] invalidNaturalIdValues) {
            if (this.invalidNaturalIdList == null) {
                this.invalidNaturalIdList = new ArrayList<CachedNaturalId>();
            }
            this.invalidNaturalIdList.add(new CachedNaturalId(this.descriptor, invalidNaturalIdValues));
        }

        public boolean containsInvalidNaturalIdReference(Object[] naturalIdValues) {
            return this.invalidNaturalIdList != null && this.invalidNaturalIdList.contains(new CachedNaturalId(this.descriptor, naturalIdValues));
        }

        public void unStashInvalidNaturalIdReferences() {
            if (this.invalidNaturalIdList != null) {
                this.invalidNaturalIdList.clear();
            }
        }
    }

    private static class CachedNaturalId
    implements Serializable {
        private final EntityTypeDescriptor descriptor;
        private final Object[] values;
        private final JavaTypeDescriptor[] naturalIdTypes;
        private int hashCode;

        public CachedNaturalId(EntityTypeDescriptor entityDescriptor, Object[] values) {
            this.descriptor = entityDescriptor;
            this.values = values;
            int prime = 31;
            int hashCodeCalculation = 1;
            hashCodeCalculation = 31 * hashCodeCalculation + entityDescriptor.hashCode();
            NaturalIdDescriptor naturalIdDescriptor = entityDescriptor.getHierarchy().getNaturalIdDescriptor();
            int numberOfNaturalIdAttributes = naturalIdDescriptor.getAttributeInfos().size();
            this.naturalIdTypes = new JavaTypeDescriptor[numberOfNaturalIdAttributes];
            int i = 0;
            for (NaturalIdDescriptor.NaturalIdAttributeInfo attribute : naturalIdDescriptor.getAttributeInfos()) {
                this.naturalIdTypes[i] = attribute.getUnderlyingAttributeDescriptor().getJavaTypeDescriptor();
                int elementHashCode = values[i] == null ? 0 : attribute.getUnderlyingAttributeDescriptor().getJavaTypeDescriptor().extractHashCode(values[i]);
                hashCodeCalculation = 31 * hashCodeCalculation + elementHashCode;
                ++i;
            }
            this.hashCode = hashCodeCalculation;
        }

        public Object[] getValues() {
            return this.values;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CachedNaturalId other = (CachedNaturalId)obj;
            return this.descriptor.equals(other.descriptor) && this.isSame(other.values);
        }

        private boolean isSame(Object[] otherValues) {
            for (int i = 0; i < this.naturalIdTypes.length; ++i) {
                if (this.naturalIdTypes[i].areEqual(this.values[i], otherValues[i])) continue;
                return false;
            }
            return true;
        }
    }
}

