/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.util.Iterator;
import org.hibernate.PropertyValueException;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.engine.spi.CascadingActions;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.CollectionDomainType;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.model.domain.spi.BagPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.CollectionElementEmbedded;
import org.hibernate.metamodel.model.domain.spi.EmbeddedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.EmbeddedValuedNavigable;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.ManagedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.Navigable;

public final class Nullability {
    private final SharedSessionContractImplementor session;
    private final boolean checkNullability;

    public Nullability(SharedSessionContractImplementor session) {
        this.session = session;
        this.checkNullability = session.getFactory().getSessionFactoryOptions().isCheckNullability();
    }

    public void checkNullability(Object[] values, EntityTypeDescriptor entityDescriptor, boolean isUpdate) {
        this.checkNullability(values, entityDescriptor, isUpdate ? NullabilityCheckType.UPDATE : NullabilityCheckType.CREATE);
    }

    public void checkNullability(Object[] values, EntityTypeDescriptor entityDescriptor, NullabilityCheckType checkType) {
        if (!this.checkNullability) {
            return;
        }
        PathCollector collector = new PathCollector();
        this.checkNullabilityInternal(values, entityDescriptor, checkType, collector);
        if (collector.hasAny()) {
            throw new PropertyValueException("not-null property references a null or transient value", entityDescriptor.getEntityName(), collector.collectedString());
        }
    }

    private void checkNullabilityInternal(Object[] values, ManagedTypeDescriptor<?> managedTypeDescriptor, NullabilityCheckType checkType, PathCollector collector) {
        managedTypeDescriptor.visitStateArrayContributors(contributor -> {
            boolean check;
            switch (checkType) {
                case CREATE: {
                    check = contributor.isInsertable();
                    break;
                }
                case UPDATE: 
                case DELETE: {
                    check = contributor.isUpdatable();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown NullabilityCheckType value : " + (Object)((Object)checkType));
                }
            }
            if (!check) {
                return;
            }
            Object value = values[contributor.getStateArrayPosition()];
            if (value == LazyPropertyInitializer.UNFETCHED_PROPERTY) {
                return;
            }
            if (value == null) {
                if (!contributor.isNullable()) {
                    collector.add(contributor.getNavigableRole());
                }
            } else {
                this.checkSubElementsNullability((Navigable)contributor, value, checkType, collector);
            }
        });
    }

    private void checkSubElementsNullability(Navigable navigable, Object value, NullabilityCheckType checkType, PathCollector collector) {
        BagPersistentAttribute collection;
        CollectionDomainType.Element elementDescriptor;
        if (navigable instanceof EmbeddedValuedNavigable) {
            EmbeddedTypeDescriptor embeddedDescriptor = ((EmbeddedValuedNavigable)navigable).getEmbeddedDescriptor();
            this.checkNullabilityInternal(embeddedDescriptor.getPropertyValues(value), embeddedDescriptor, checkType, collector);
        } else if (navigable instanceof BagPersistentAttribute && (elementDescriptor = (collection = (BagPersistentAttribute)navigable).getPersistentCollectionDescriptor().getElementDescriptor()) instanceof CollectionElementEmbedded) {
            Iterator itr = CascadingActions.getLoadedElementsIterator(this.session, collection.getPersistentCollectionDescriptor(), value);
            while (itr.hasNext()) {
                Object elementValue = itr.next();
                if (elementValue == null) continue;
                EmbeddedTypeDescriptor embeddedDescriptor = ((CollectionElementEmbedded)elementDescriptor).getEmbeddedDescriptor();
                this.checkNullabilityInternal(embeddedDescriptor.getPropertyValues(value), embeddedDescriptor, checkType, collector);
            }
        }
    }

    private static class PathCollector {
        final StringBuilder collector = new StringBuilder();
        boolean any;

        private PathCollector() {
        }

        public void add(NavigableRole role) {
            if (this.any) {
                this.collector.append(", ");
            }
            this.collector.append(role.getFullPath());
            this.any = true;
        }

        public boolean hasAny() {
            return this.any;
        }

        public String collectedString() {
            return this.collector.toString();
        }
    }

    public static enum NullabilityCheckType {
        CREATE,
        UPDATE,
        DELETE;

    }
}

