/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.io.Serializable;
import org.hibernate.CacheMode;
import org.hibernate.LockMode;
import org.hibernate.annotations.Remove;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.profile.Fetch;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.jboss.logging.Logger;

@Deprecated
@Remove
public final class TwoPhaseLoad {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)TwoPhaseLoad.class.getName());

    private TwoPhaseLoad() {
    }

    public static void postHydrate(EntityTypeDescriptor descriptor, Serializable id, Object[] values, Object rowId, Object object, LockMode lockMode, SharedSessionContractImplementor session) {
        Object version = Versioning.getVersion(values, descriptor);
        session.getPersistenceContext().addEntry(object, Status.LOADING, values, rowId, id, version, lockMode, true, descriptor, false);
        if (version != null && LOG.isTraceEnabled()) {
            String versionStr = descriptor.getHierarchy().getVersionDescriptor() != null ? descriptor.getHierarchy().getVersionDescriptor().getJavaTypeDescriptor().extractLoggableRepresentation(version) : "null";
            LOG.tracef("Version: %s", versionStr);
        }
    }

    private static Boolean isEagerFetchProfile(SharedSessionContractImplementor session, String role) {
        LoadQueryInfluencers loadQueryInfluencers = session.getLoadQueryInfluencers();
        for (String fetchProfileName : loadQueryInfluencers.getEnabledFetchProfileNames()) {
            FetchProfile fp = session.getFactory().getFetchProfile(fetchProfileName);
            Fetch fetch = fp.getFetchByRole(role);
            if (fetch == null || Fetch.Style.JOIN != fetch.getStyle()) continue;
            return true;
        }
        return null;
    }

    public static void postLoad(Object entity, SharedSessionContractImplementor session, PostLoadEvent postLoadEvent) {
        if (session.isEventSource()) {
            PersistenceContext persistenceContext = session.getPersistenceContext();
            EntityEntry entityEntry = persistenceContext.getEntry(entity);
            postLoadEvent.setEntity(entity).setId(entityEntry.getId()).setDescriptor(entityEntry.getDescriptor());
            EventListenerGroup<PostLoadEventListener> listenerGroup = session.getFactory().getServiceRegistry().getService(EventListenerRegistry.class).getEventListenerGroup(EventType.POST_LOAD);
            for (PostLoadEventListener listener : listenerGroup.listeners()) {
                listener.onPostLoad(postLoadEvent);
            }
        }
    }

    private static boolean useMinimalPuts(SharedSessionContractImplementor session, EntityEntry entityEntry) {
        if (session.getFactory().getSessionFactoryOptions().isMinimalPutsEnabled()) {
            return session.getCacheMode() != CacheMode.REFRESH;
        }
        return false;
    }

    public static void addUninitializedEntity(EntityKey key, Object object, EntityTypeDescriptor descriptor, LockMode lockMode, SharedSessionContractImplementor session) {
        session.getPersistenceContext().addEntity(object, Status.LOADING, null, key, null, lockMode, true, descriptor, false);
    }

    public static void addUninitializedCachedEntity(EntityKey key, Object object, EntityTypeDescriptor descriptor, LockMode lockMode, Object version, SharedSessionContractImplementor session) {
        session.getPersistenceContext().addEntity(object, Status.LOADING, null, key, version, lockMode, true, descriptor, false);
    }
}

