/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.VersionDescriptor;
import org.hibernate.metamodel.model.domain.spi.VersionSupport;
import org.jboss.logging.Logger;

public final class Versioning {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)Versioning.class.getName());

    private Versioning() {
    }

    private static Object seed(VersionSupport versionType, SharedSessionContractImplementor session) {
        Object seed = versionType.seed(session);
        LOG.tracef("Seeding: %s", seed);
        return seed;
    }

    public static boolean seedVersion(Object[] fields, VersionDescriptor versionDescriptor, SharedSessionContractImplementor session) {
        int versionPosition = versionDescriptor.getStateArrayPosition();
        Object initialVersion = fields[versionPosition];
        if (initialVersion == null || initialVersion instanceof Number && ((Number)initialVersion).longValue() < 0L) {
            fields[versionPosition] = Versioning.seed(versionDescriptor.getVersionSupport(), session);
            return true;
        }
        LOG.tracev("Using initial version: {0}", initialVersion);
        return false;
    }

    public static Object increment(Object version, VersionSupport versionType, SharedSessionContractImplementor session) {
        Object next = versionType.next(version, session);
        if (LOG.isTraceEnabled()) {
            LOG.tracef("Incrementing: %s to %s", versionType.toLoggableString(version), versionType.toLoggableString(next));
        }
        return next;
    }

    public static void setVersion(Object[] fields, Object version, EntityTypeDescriptor descriptor) {
        VersionDescriptor versionDescriptor = descriptor.getHierarchy().getVersionDescriptor();
        if (versionDescriptor == null) {
            return;
        }
        int versionPosition = versionDescriptor.getStateArrayPosition();
        fields[versionPosition] = version;
    }

    public static Object getVersion(Object[] fields, EntityTypeDescriptor descriptor) {
        VersionDescriptor versionDescriptor = descriptor.getHierarchy().getVersionDescriptor();
        if (versionDescriptor == null) {
            return null;
        }
        int versionPosition = versionDescriptor.getStateArrayPosition();
        return fields[versionPosition];
    }

    public static boolean isVersionIncrementRequired(int[] dirtyProperties, boolean hasDirtyCollections, boolean[] propertyVersionability) {
        if (hasDirtyCollections) {
            return true;
        }
        for (int dirtyProperty : dirtyProperties) {
            if (!propertyVersionability[dirtyProperty]) continue;
            return true;
        }
        return false;
    }
}

