/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.profile;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.collection.spi.CollectionClassification;
import org.hibernate.engine.profile.Association;
import org.hibernate.engine.profile.Fetch;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.model.domain.spi.NonIdPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.PluralPersistentAttribute;

public class FetchProfile {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(FetchProfile.class);
    private final String name;
    private Map<String, Fetch> fetches = new HashMap<String, Fetch>();
    private boolean containsJoinFetchedCollection;
    private boolean containsJoinFetchedBag;
    private Fetch bagJoinFetch;

    public FetchProfile(String name) {
        this.name = name;
    }

    public void addFetch(Association association, String fetchStyleName) {
        this.addFetch(association, Fetch.Style.parse(fetchStyleName));
    }

    public void addFetch(Association association, Fetch.Style style) {
        this.addFetch(new Fetch(association, style));
    }

    public void addFetch(Fetch fetch) {
        String fetchAssociactionRole = fetch.getAssociation().getRole();
        NonIdPersistentAttribute attribute = fetch.getAssociation().getOwner().findPersistentAttribute(fetchAssociactionRole);
        if (PluralPersistentAttribute.class.isInstance(attribute)) {
            LOG.tracev("Handling request to add collection fetch [{0}]", fetchAssociactionRole);
            CollectionClassification collectionClassification = ((PluralPersistentAttribute)attribute).getPersistentCollectionDescriptor().getCollectionClassification();
            if (Fetch.Style.JOIN == fetch.getStyle()) {
                if (collectionClassification == CollectionClassification.BAG && this.containsJoinFetchedCollection) {
                    LOG.containsJoinFetchedCollection(fetchAssociactionRole);
                    return;
                }
                if (this.containsJoinFetchedBag) {
                    if (this.fetches.remove(this.bagJoinFetch.getAssociation().getRole()) != this.bagJoinFetch) {
                        LOG.unableToRemoveBagJoinFetch();
                    }
                    this.bagJoinFetch = null;
                    this.containsJoinFetchedBag = false;
                }
                this.containsJoinFetchedCollection = true;
            }
        }
        this.fetches.put(fetchAssociactionRole, fetch);
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Fetch> getFetches() {
        return this.fetches;
    }

    public Fetch getFetchByRole(String role) {
        return this.fetches.get(role);
    }

    public boolean isContainsJoinFetchedCollection() {
        return this.containsJoinFetchedCollection;
    }

    public boolean isContainsJoinFetchedBag() {
        return this.containsJoinFetchedBag;
    }
}

