/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.hibernate.EntityMode;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.CacheHelper;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.internal.CoreLogging;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.jboss.logging.Logger;

public class BatchFetchQueue {
    private static final Logger LOG = CoreLogging.logger(BatchFetchQueue.class);
    private final PersistenceContext context;
    private final Map<EntityKey, SubselectFetch> subselectsByEntityKey = new HashMap<EntityKey, SubselectFetch>(8);
    private final Map<String, LinkedHashSet<EntityKey>> batchLoadableEntityKeys = new HashMap<String, LinkedHashSet<EntityKey>>(8);
    private final Map<String, LinkedHashMap<CollectionEntry, PersistentCollection>> batchLoadableCollections = new HashMap<String, LinkedHashMap<CollectionEntry, PersistentCollection>>(8);

    public BatchFetchQueue(PersistenceContext context) {
        this.context = context;
    }

    public void clear() {
        this.batchLoadableEntityKeys.clear();
        this.batchLoadableCollections.clear();
        this.subselectsByEntityKey.clear();
    }

    public SubselectFetch getSubselect(EntityKey key) {
        return this.subselectsByEntityKey.get(key);
    }

    public void addSubselect(EntityKey key, SubselectFetch subquery) {
        this.subselectsByEntityKey.put(key, subquery);
    }

    public void removeSubselect(EntityKey key) {
        this.subselectsByEntityKey.remove(key);
    }

    public void addBatchLoadableEntityKey(EntityKey key) {
        if (key.isBatchLoadable()) {
            LinkedHashSet<EntityKey> set = this.batchLoadableEntityKeys.get(key.getEntityName());
            if (set == null) {
                set = new LinkedHashSet(8);
                this.batchLoadableEntityKeys.put(key.getEntityName(), set);
            }
            set.add(key);
        }
    }

    public void removeBatchLoadableEntityKey(EntityKey key) {
        LinkedHashSet<EntityKey> set;
        if (key.isBatchLoadable() && (set = this.batchLoadableEntityKeys.get(key.getEntityName())) != null) {
            set.remove(key);
        }
    }

    public boolean containsEntityKey(EntityKey key) {
        LinkedHashSet<EntityKey> set;
        if (key.isBatchLoadable() && (set = this.batchLoadableEntityKeys.get(key.getEntityName())) != null) {
            return set.contains(key);
        }
        return false;
    }

    public Object[] getEntityBatch(EntityTypeDescriptor entityDescriptor, Object id, int batchSize, EntityMode entityMode) {
        Object[] ids = new Serializable[batchSize];
        ids[0] = id;
        int i = 1;
        int end = -1;
        boolean checkForEnd = false;
        LinkedHashSet<EntityKey> set = this.batchLoadableEntityKeys.get(entityDescriptor.getEntityName());
        if (set != null) {
            for (EntityKey key : set) {
                if (checkForEnd && i == end) {
                    return ids;
                }
                if (entityDescriptor.getIdentifierDescriptor().getJavaTypeDescriptor().areEqual(id, key.getIdentifier())) {
                    end = i;
                } else if (!this.isCached(key, entityDescriptor)) {
                    ids[i++] = key.getIdentifier();
                }
                if (i != batchSize) continue;
                i = 1;
                if (end == -1) continue;
                checkForEnd = true;
            }
        }
        return ids;
    }

    private boolean isCached(EntityKey entityKey, EntityTypeDescriptor entityDescriptor) {
        SharedSessionContractImplementor session = this.context.getSession();
        if (!session.getCacheMode().isGetEnabled()) {
            return false;
        }
        if (!entityDescriptor.canReadFromCache()) {
            return false;
        }
        EntityDataAccess cacheAccess = entityDescriptor.getHierarchy().getEntityCacheAccess();
        Object key = cacheAccess.generateCacheKey(entityKey.getIdentifier(), entityDescriptor.getHierarchy(), session.getFactory(), session.getTenantIdentifier());
        return CacheHelper.fromSharedCache(session, key, cacheAccess) != null;
    }

    public void addBatchLoadableCollection(PersistentCollection collection, CollectionEntry ce) {
        PersistentCollectionDescriptor collectionDescriptor = ce.getLoadedCollectionDescriptor();
        LinkedHashMap<CollectionEntry, PersistentCollection<Object>> map = this.batchLoadableCollections.get(collectionDescriptor.getNavigableRole().getFullPath());
        if (map == null) {
            map = new LinkedHashMap(16);
            this.batchLoadableCollections.put(collectionDescriptor.getNavigableRole().getFullPath(), map);
        }
        map.put(ce, collection);
    }

    public void removeBatchLoadableCollection(CollectionEntry ce) {
        LinkedHashMap<CollectionEntry, PersistentCollection> map = this.batchLoadableCollections.get(ce.getLoadedCollectionDescriptor().getNavigableRole().getFullPath());
        if (map != null) {
            map.remove(ce);
        }
    }

    public Object[] getCollectionBatch(PersistentCollectionDescriptor persistentCollectionDescriptor, Serializable id, int batchSize) {
        Object[] keys = new Object[batchSize];
        keys[0] = id;
        int i = 1;
        int end = -1;
        boolean checkForEnd = false;
        LinkedHashMap<CollectionEntry, PersistentCollection> map = this.batchLoadableCollections.get(persistentCollectionDescriptor.getNavigableRole().getFullPath());
        if (map != null) {
            for (Map.Entry<CollectionEntry, PersistentCollection> me : map.entrySet()) {
                CollectionEntry ce = me.getKey();
                PersistentCollection collection = me.getValue();
                if (ce.getLoadedKey() == null) continue;
                if (collection.wasInitialized()) {
                    LOG.warn((Object)"Encountered initialized collection in BatchFetchQueue, this should not happen.");
                    continue;
                }
                if (checkForEnd && i == end) {
                    return keys;
                }
                boolean isEqual = persistentCollectionDescriptor.getCollectionKeyDescriptor().getJavaTypeDescriptor().areEqual(id, ce.getLoadedKey());
                if (isEqual) {
                    end = i;
                } else if (!this.isCached(ce.getLoadedKey(), persistentCollectionDescriptor)) {
                    keys[i++] = ce.getLoadedKey();
                }
                if (i != batchSize) continue;
                i = 1;
                if (end == -1) continue;
                checkForEnd = true;
            }
        }
        return keys;
    }

    private boolean isCached(Object collectionKey, PersistentCollectionDescriptor descriptor) {
        SharedSessionContractImplementor session = this.context.getSession();
        if (session.getCacheMode().isGetEnabled() && descriptor.hasCache()) {
            CollectionDataAccess cache = descriptor.getCacheAccess();
            Object cacheKey = cache.generateCacheKey(collectionKey, descriptor, session.getFactory(), session.getTenantIdentifier());
            return CacheHelper.fromSharedCache(session, cacheKey, cache) != null;
        }
        return false;
    }
}

