/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.collection.internal.AbstractPersistentCollection;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.pretty.MessageHelper;

public final class CollectionEntry
implements Serializable {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(CollectionEntry.class);
    private Serializable snapshot;
    private NavigableRole role;
    private transient PersistentCollectionDescriptor loadedCollectionDescriptor;
    private Object loadedKey;
    private transient boolean reached;
    private transient boolean processed;
    private transient boolean doupdate;
    private transient boolean doremove;
    private transient boolean dorecreate;
    private transient boolean ignore;
    private transient PersistentCollectionDescriptor currentDescriptor;
    private transient Object currentKey;
    private boolean fromMerge;

    public CollectionEntry(PersistentCollectionDescriptor collectionDescriptor, PersistentCollection collection) {
        this.ignore = false;
        collection.clearDirty();
        this.snapshot = collectionDescriptor.getMutabilityPlan().isMutable() ? collection.getSnapshot(collectionDescriptor) : null;
        collection.setSnapshot(null, this.role, this.snapshot);
    }

    public CollectionEntry(PersistentCollection collection, PersistentCollectionDescriptor loadedDescriptor, Object loadedKey, boolean ignore) {
        this.ignore = ignore;
        this.loadedKey = loadedKey;
        this.setLoadedDescriptor(loadedDescriptor);
        collection.setSnapshot(loadedKey, this.role, null);
    }

    public CollectionEntry(PersistentCollectionDescriptor loadedDescriptor, Object loadedKey) {
        this.ignore = false;
        this.loadedKey = loadedKey;
        this.setLoadedDescriptor(loadedDescriptor);
    }

    public CollectionEntry(PersistentCollection collection, SessionFactoryImplementor factory) throws MappingException {
        this.ignore = false;
        this.loadedKey = collection.getKey();
        this.setLoadedDescriptor(factory.getMetamodel().findCollectionDescriptor(collection.getRole()));
        this.snapshot = collection.getStoredSnapshot();
    }

    private CollectionEntry(NavigableRole role, Serializable snapshot, Serializable loadedKey, SessionFactoryImplementor factory) {
        this.role = role;
        this.snapshot = snapshot;
        this.loadedKey = loadedKey;
        if (role != null) {
            this.afterDeserialize(factory);
        }
    }

    private void dirty(PersistentCollection collection) throws HibernateException {
        if (!collection.wasInitialized()) {
            return;
        }
        if (collection.isDirty()) {
            return;
        }
        PersistentCollectionDescriptor loadedDescriptor = this.getLoadedCollectionDescriptor();
        if (loadedDescriptor == null) {
            return;
        }
        if (!loadedDescriptor.getDescribedAttribute().getMutabilityPlan().isMutable()) {
            return;
        }
        if (!collection.isDirectlyAccessible() || !loadedDescriptor.getElementDescriptor().isMutable()) {
            return;
        }
        if (collection.equalsSnapshot(loadedDescriptor)) {
            return;
        }
        collection.dirty();
    }

    public void preFlush(PersistentCollection collection) throws HibernateException {
        boolean nonMutableChange;
        if (this.loadedKey == null && collection.getKey() != null) {
            this.loadedKey = collection.getKey();
        }
        boolean bl = nonMutableChange = collection.isDirty() && this.getLoadedCollectionDescriptor() != null && !this.getLoadedCollectionDescriptor().getMutabilityPlan().isMutable();
        if (nonMutableChange) {
            throw new HibernateException("changed an immutable collection instance: " + MessageHelper.collectionInfoString(this.getLoadedCollectionDescriptor().getNavigableRole().getFullPath(), this.getLoadedKey()));
        }
        this.dirty(collection);
        if (LOG.isDebugEnabled() && collection.isDirty() && this.getLoadedCollectionDescriptor() != null) {
            LOG.debugf("Collection dirty: %s", MessageHelper.collectionInfoString(this.getLoadedCollectionDescriptor().getNavigableRole().getFullPath(), this.getLoadedKey()));
        }
        this.setReached(false);
        this.setProcessed(false);
        this.setDoupdate(false);
        this.setDoremove(false);
        this.setDorecreate(false);
    }

    public void postInitialize(PersistentCollection collection) throws HibernateException {
        this.snapshot = this.getLoadedCollectionDescriptor().getMutabilityPlan().isMutable() ? collection.getSnapshot(this.getLoadedCollectionDescriptor()) : null;
        collection.setSnapshot(this.loadedKey, this.role, this.snapshot);
        if (this.getLoadedCollectionDescriptor().getBatchSize() > 1) {
            ((AbstractPersistentCollection)collection).getSession().getPersistenceContext().getBatchFetchQueue().removeBatchLoadableCollection(this);
        }
    }

    public void postFlush(PersistentCollection collection) throws HibernateException {
        if (this.isIgnore()) {
            this.ignore = false;
        } else if (!this.isProcessed()) {
            throw new HibernateException(LOG.collectionNotProcessedByFlush(collection.getRole()));
        }
        collection.setSnapshot(this.loadedKey, this.role, this.snapshot);
    }

    public void afterAction(PersistentCollection collection) {
        boolean resnapshot;
        this.loadedKey = this.getCurrentKey();
        this.setLoadedDescriptor(this.getCurrentDescriptor());
        boolean bl = resnapshot = collection.wasInitialized() && (this.isDoremove() || this.isDorecreate() || this.isDoupdate());
        if (resnapshot) {
            this.snapshot = this.loadedCollectionDescriptor == null || !this.loadedCollectionDescriptor.getMutabilityPlan().isMutable() ? null : collection.getSnapshot(this.loadedCollectionDescriptor);
        }
        collection.postAction();
    }

    public Object getKey() {
        return this.getLoadedKey();
    }

    @Deprecated
    public String getRole() {
        return this.role.getFullPath();
    }

    public NavigableRole getNavigableRole() {
        return this.role;
    }

    public Serializable getSnapshot() {
        return this.snapshot;
    }

    public void resetStoredSnapshot(PersistentCollection collection, Serializable storedSnapshot) {
        LOG.debugf("Reset storedSnapshot to %s for %s", storedSnapshot, this);
        if (this.fromMerge) {
            return;
        }
        this.snapshot = storedSnapshot;
        collection.setSnapshot(this.loadedKey, this.role, this.snapshot);
        this.fromMerge = true;
    }

    private void setLoadedDescriptor(PersistentCollectionDescriptor collectionDescriptor) {
        this.loadedCollectionDescriptor = collectionDescriptor;
        this.setRole(collectionDescriptor == null ? null : collectionDescriptor.getNavigableRole());
    }

    void afterDeserialize(SessionFactoryImplementor factory) {
        this.loadedCollectionDescriptor = factory == null ? null : factory.getMetamodel().findCollectionDescriptor(this.role.getFullPath());
    }

    public boolean wasDereferenced() {
        return this.getLoadedKey() == null;
    }

    public boolean isReached() {
        return this.reached;
    }

    public void setReached(boolean reached) {
        this.reached = reached;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public boolean isDoupdate() {
        return this.doupdate;
    }

    public void setDoupdate(boolean doupdate) {
        this.doupdate = doupdate;
    }

    public boolean isDoremove() {
        return this.doremove;
    }

    public void setDoremove(boolean doremove) {
        this.doremove = doremove;
    }

    public boolean isDorecreate() {
        return this.dorecreate;
    }

    public void setDorecreate(boolean dorecreate) {
        this.dorecreate = dorecreate;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public PersistentCollectionDescriptor getCurrentDescriptor() {
        return this.currentDescriptor;
    }

    public void setCurrentDescriptor(PersistentCollectionDescriptor descriptor) {
        this.currentDescriptor = descriptor;
    }

    public Object getCurrentKey() {
        return this.currentKey;
    }

    public void setCurrentKey(Object currentKey) {
        this.currentKey = currentKey;
    }

    public PersistentCollectionDescriptor getLoadedCollectionDescriptor() {
        return this.loadedCollectionDescriptor;
    }

    public Object getLoadedKey() {
        return this.loadedKey;
    }

    private void setRole(NavigableRole role) {
        this.role = role;
    }

    public String toString() {
        String result = "CollectionEntry" + MessageHelper.collectionInfoString(this.loadedCollectionDescriptor.getNavigableRole().getFullPath(), this.loadedKey);
        if (this.currentDescriptor != null) {
            result = result + "->" + MessageHelper.collectionInfoString(this.currentDescriptor.getNavigableRole().getFullPath(), this.currentKey);
        }
        return result;
    }

    public Collection getOrphans(String entityName, PersistentCollection collection) throws HibernateException {
        if (this.snapshot == null) {
            throw new AssertionFailure("no collection snapshot for orphan delete");
        }
        return collection.getOrphans(this.snapshot, entityName);
    }

    public boolean isSnapshotEmpty(PersistentCollection collection) {
        return collection.wasInitialized() && (this.getLoadedCollectionDescriptor() == null || this.getLoadedCollectionDescriptor().getMutabilityPlan().isMutable()) && collection.isSnapshotEmpty(this.getSnapshot());
    }

    public void serialize(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.role);
        oos.writeObject(this.snapshot);
        oos.writeObject(this.loadedKey);
    }

    public static CollectionEntry deserialize(ObjectInputStream ois, SessionImplementor session) throws IOException, ClassNotFoundException {
        return new CollectionEntry((NavigableRole)ois.readObject(), (Serializable)ois.readObject(), (Serializable)ois.readObject(), session == null ? null : session.getFactory());
    }
}

