/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.hibernate.EntityMode;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public final class CollectionKey
implements Serializable {
    private final NavigableRole role;
    private final Object key;
    private final JavaTypeDescriptor keyType;
    private transient PersistentCollectionDescriptor collectionDescriptor;
    private final int hashCode;

    public CollectionKey(PersistentCollectionDescriptor collectionDescriptor, Object key) {
        this(collectionDescriptor.getNavigableRole(), key, collectionDescriptor.getKeyJavaTypeDescriptor(), collectionDescriptor);
    }

    public CollectionKey(PersistentCollectionDescriptor collectionDescriptor, Object key, EntityMode em) {
        this(collectionDescriptor.getNavigableRole(), key, collectionDescriptor.getKeyJavaTypeDescriptor(), collectionDescriptor);
    }

    private CollectionKey(NavigableRole role, Object key, JavaTypeDescriptor keyType, PersistentCollectionDescriptor collectionDescriptor) {
        this.role = role;
        this.key = key;
        this.keyType = keyType;
        this.collectionDescriptor = collectionDescriptor;
        this.hashCode = this.generateHashCode(collectionDescriptor);
    }

    private int generateHashCode(PersistentCollectionDescriptor collectionDescriptor) {
        int result = 17;
        result = 37 * result + this.role.hashCode();
        result = 37 * result + collectionDescriptor.getCollectionKeyDescriptor().extractHashCode(this.key);
        return result;
    }

    @Deprecated
    public String getRole() {
        return this.role.getFullPath();
    }

    public NavigableRole getNavigableRole() {
        return this.role;
    }

    public Object getKey() {
        return this.key;
    }

    public String toString() {
        return "CollectionKey" + MessageHelper.collectionInfoString(this.role.getFullPath(), this.key);
    }

    public String toLoggableString() {
        return MessageHelper.collectionInfoString(this.role.getFullPath(), this.key);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CollectionKey that = (CollectionKey)other;
        return that.role.equals(this.role) && this.collectionDescriptor.getCollectionKeyDescriptor().areEqual(that.key, this.key);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void serialize(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.role);
        oos.writeObject(this.key);
        oos.writeObject(this.keyType);
    }

    public static CollectionKey deserialize(ObjectInputStream ois, SessionImplementor session) throws IOException, ClassNotFoundException {
        NavigableRole role = (NavigableRole)ois.readObject();
        return new CollectionKey(role, ois.readObject(), (JavaTypeDescriptor)ois.readObject(), session.getSessionFactory().getMetamodel().findCollectionDescriptor(role));
    }
}

