/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Objects;
import org.hibernate.AssertionFailure;
import org.hibernate.engine.spi.EntityKeyCommon;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.model.domain.spi.EntityHierarchy;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;

public final class EntityKey
implements EntityKeyCommon,
Serializable {
    private final Object identifier;
    private final int hashCode;
    private final EntityTypeDescriptor entityDescriptor;

    public EntityKey(Object id, EntityTypeDescriptor entityDescriptor) {
        this.entityDescriptor = entityDescriptor;
        if (id == null) {
            throw new AssertionFailure("null identifier");
        }
        this.identifier = id;
        this.hashCode = this.generateHashCode();
    }

    private int generateHashCode() {
        int result = 17;
        EntityHierarchy hierarchy = this.entityDescriptor.getHierarchy();
        String rootEntityName = hierarchy.getRootEntityType().getEntityName();
        result = 37 * result + (rootEntityName != null ? rootEntityName.hashCode() : 0);
        result = 37 * result + hierarchy.getIdentifierDescriptor().extractHashCode(this.identifier);
        return result;
    }

    public boolean isBatchLoadable() {
        return this.entityDescriptor.isBatchLoadable();
    }

    public Object getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getEntityName() {
        return this.entityDescriptor.getEntityName();
    }

    @Override
    public Object getKeyValue() {
        return this.getIdentifier();
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.entityDescriptor.getJavaTypeDescriptor();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || EntityKey.class != other.getClass()) {
            return false;
        }
        EntityKey otherKey = (EntityKey)other;
        return this.samePersistentType(otherKey) && this.sameIdentifier(otherKey);
    }

    private boolean sameIdentifier(EntityKey otherKey) {
        return this.entityDescriptor.getHierarchy().getIdentifierDescriptor().areEqual(otherKey.identifier, this.identifier);
    }

    private boolean samePersistentType(EntityKey otherKey) {
        if (otherKey.entityDescriptor == this.entityDescriptor) {
            return true;
        }
        return Objects.equals(otherKey.entityDescriptor.getHierarchy().getRootEntityType().getEntityName(), this.entityDescriptor.getHierarchy().getRootEntityType().getEntityName());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "EntityKey" + MessageHelper.infoString(this.entityDescriptor, this.identifier, this.entityDescriptor.getFactory());
    }

    public void serialize(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.identifier);
        oos.writeObject(this.entityDescriptor.getEntityName());
    }

    public static EntityKey deserialize(ObjectInputStream ois, SessionFactoryImplementor sessionFactory) throws IOException, ClassNotFoundException {
        Serializable id = (Serializable)ois.readObject();
        String entityName = (String)ois.readObject();
        EntityTypeDescriptor entityDescriptor = sessionFactory.getMetamodel().getEntityDescriptor(entityName);
        return new EntityKey(id, entityDescriptor);
    }
}

