/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.hibernate.engine.spi.EntityKeyCommon;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metamodel.model.domain.RepresentationMode;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;

public class EntityUniqueKey
implements EntityKeyCommon,
Serializable {
    private final String uniqueKeyName;
    private final String entityName;
    private final Object key;
    private final JavaTypeDescriptor identifierJavaTypeDescriptor;
    private final JavaTypeDescriptor ukJavaTypeDescriptor;
    private final RepresentationMode representationMode;
    private final int hashCode;

    public EntityUniqueKey(String entityName, String uniqueKeyName, Object semiResolvedKey, JavaTypeDescriptor identifierJavaTypeDescriptor, JavaTypeDescriptor ukJavaTypeDescriptor, RepresentationMode representationMode) {
        this.uniqueKeyName = uniqueKeyName;
        this.entityName = entityName;
        this.key = semiResolvedKey;
        this.identifierJavaTypeDescriptor = identifierJavaTypeDescriptor;
        this.ukJavaTypeDescriptor = ukJavaTypeDescriptor;
        this.representationMode = representationMode;
        this.hashCode = this.generateHashCode();
    }

    @Override
    public String getEntityName() {
        return this.entityName;
    }

    @Override
    public Object getKeyValue() {
        return this.getKey();
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.ukJavaTypeDescriptor;
    }

    public Object getKey() {
        return this.key;
    }

    public String getUniqueKeyName() {
        return this.uniqueKeyName;
    }

    private int generateHashCode() {
        int result = 17;
        result = 37 * result + this.entityName.hashCode();
        result = 37 * result + this.uniqueKeyName.hashCode();
        result = 37 * result + this.identifierJavaTypeDescriptor.extractHashCode(this.key);
        return result;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object other) {
        EntityUniqueKey that = (EntityUniqueKey)other;
        return that != null && that.entityName.equals(this.entityName) && that.uniqueKeyName.equals(this.uniqueKeyName) && this.identifierJavaTypeDescriptor.areEqual(that.key, this.key);
    }

    public String toString() {
        return "EntityUniqueKey" + MessageHelper.infoString(this.entityName, this.uniqueKeyName, this.key);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        this.checkAbilityToSerialize();
        oos.defaultWriteObject();
    }

    private void checkAbilityToSerialize() {
        if (this.key != null && !Serializable.class.isAssignableFrom(this.key.getClass())) {
            throw new IllegalStateException("Cannot serialize an EntityUniqueKey which represents a non serializable property value [" + this.entityName + "." + this.uniqueKeyName + "]");
        }
    }

    public void serialize(ObjectOutputStream oos) throws IOException {
        this.checkAbilityToSerialize();
        oos.writeObject(this.uniqueKeyName);
        oos.writeObject(this.entityName);
        oos.writeObject(this.key);
        oos.writeObject(this.identifierJavaTypeDescriptor);
        oos.writeObject(this.ukJavaTypeDescriptor);
        oos.writeObject((Object)this.representationMode);
    }

    public static EntityUniqueKey deserialize(ObjectInputStream ois, SessionImplementor session) throws IOException, ClassNotFoundException {
        return new EntityUniqueKey((String)ois.readObject(), (String)ois.readObject(), ois.readObject(), (JavaTypeDescriptor)ois.readObject(), (JavaTypeDescriptor)ois.readObject(), (RepresentationMode)((Object)ois.readObject()));
    }
}

