/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.BatchFetchQueue;
import org.hibernate.engine.spi.CachedNaturalIdValueSource;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.internal.util.MarkerObject;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.sql.results.spi.LoadContexts;

public interface PersistenceContext {
    public static final Object NO_ROW = new MarkerObject("NO_ROW");

    public boolean isStateless();

    public SharedSessionContractImplementor getSession();

    public LoadContexts getLoadContexts();

    public void addUnownedCollection(CollectionKey var1, PersistentCollection var2);

    public PersistentCollection useUnownedCollection(CollectionKey var1);

    public BatchFetchQueue getBatchFetchQueue();

    public void clear();

    public boolean hasNonReadOnlyEntities();

    public void setEntryStatus(EntityEntry var1, Status var2);

    public void afterTransactionCompletion();

    public Object[] getDatabaseSnapshot(Object var1, EntityTypeDescriptor var2);

    public Object[] getCachedDatabaseSnapshot(EntityKey var1);

    public Object[] getNaturalIdSnapshot(Object var1, EntityTypeDescriptor var2);

    public void addEntity(EntityKey var1, Object var2);

    public Object getEntity(EntityKey var1);

    public boolean containsEntity(EntityKey var1);

    public Object removeEntity(EntityKey var1);

    public void addEntity(EntityUniqueKey var1, Object var2);

    public Object getEntity(EntityUniqueKey var1);

    public EntityEntry getEntry(Object var1);

    public EntityEntry removeEntry(Object var1);

    public boolean isEntryFor(Object var1);

    public CollectionEntry getCollectionEntry(PersistentCollection var1);

    public EntityEntry addEntity(Object var1, Status var2, Object[] var3, EntityKey var4, Object var5, LockMode var6, boolean var7, EntityTypeDescriptor var8, boolean var9);

    public EntityEntry addEntry(Object var1, Status var2, Object[] var3, Object var4, Object var5, Object var6, LockMode var7, boolean var8, EntityTypeDescriptor var9, boolean var10);

    public boolean containsCollection(PersistentCollection var1);

    public boolean containsProxy(Object var1);

    public boolean reassociateIfUninitializedProxy(Object var1) throws MappingException;

    public void reassociateProxy(Object var1, Object var2) throws MappingException;

    public Object unproxy(Object var1) throws HibernateException;

    public Object unproxyAndReassociate(Object var1) throws HibernateException;

    public void checkUniqueness(EntityKey var1, Object var2) throws HibernateException;

    public Object narrowProxy(Object var1, EntityTypeDescriptor var2, EntityKey var3, Object var4) throws HibernateException;

    public Object proxyFor(EntityTypeDescriptor var1, EntityKey var2, Object var3) throws HibernateException;

    public Object proxyFor(Object var1) throws HibernateException;

    public Object getCollectionOwner(Object var1, PersistentCollectionDescriptor var2) throws MappingException;

    public Object getLoadedCollectionOwnerOrNull(PersistentCollection var1);

    public Object getLoadedCollectionOwnerIdOrNull(PersistentCollection var1);

    public void addUninitializedCollection(PersistentCollectionDescriptor var1, PersistentCollection var2, Object var3);

    public void addUninitializedDetachedCollection(PersistentCollectionDescriptor var1, PersistentCollection var2);

    public void addNewCollection(PersistentCollectionDescriptor var1, PersistentCollection var2) throws HibernateException;

    public void addInitializedDetachedCollection(PersistentCollectionDescriptor var1, PersistentCollection var2) throws HibernateException;

    public CollectionEntry addInitializedCollection(PersistentCollectionDescriptor var1, PersistentCollection var2, Object var3) throws HibernateException;

    public PersistentCollection getCollection(CollectionKey var1);

    public void addNonLazyCollection(PersistentCollection var1);

    public void initializeNonLazyCollections() throws HibernateException;

    public PersistentCollection getCollectionHolder(Object var1);

    public void addCollectionHolder(PersistentCollection var1);

    public PersistentCollection removeCollectionHolder(Object var1);

    public Serializable getSnapshot(PersistentCollection var1);

    public CollectionEntry getCollectionEntryOrNull(Object var1);

    public Object getProxy(EntityKey var1);

    public void addProxy(EntityKey var1, Object var2);

    public Object removeProxy(EntityKey var1);

    public HashSet getNullifiableEntityKeys();

    public Map getEntitiesByKey();

    public Map.Entry<Object, EntityEntry>[] reentrantSafeEntityEntries();

    @Deprecated
    public Map getEntityEntries();

    public int getNumberOfManagedEntities();

    public Map getCollectionEntries();

    public Map getCollectionsByKey();

    public int getCascadeLevel();

    public int incrementCascadeLevel();

    public int decrementCascadeLevel();

    public boolean isFlushing();

    public void setFlushing(boolean var1);

    public void beforeLoad();

    public void afterLoad();

    public boolean isLoadFinished();

    public String toString();

    public Object getOwnerId(String var1, String var2, Object var3, Map var4);

    public Object getIndexInOwner(String var1, String var2, Object var3, Map var4);

    public void addNullProperty(EntityKey var1, String var2);

    public boolean isPropertyNull(EntityKey var1, String var2);

    public boolean isDefaultReadOnly();

    public void setDefaultReadOnly(boolean var1);

    public boolean isReadOnly(Object var1);

    public void setReadOnly(Object var1, boolean var2);

    public void replaceDelayedEntityIdentityInsertKeys(EntityKey var1, Object var2);

    public void addChildParent(Object var1, Object var2);

    public void removeChildParent(Object var1);

    public void registerInsertedKey(EntityTypeDescriptor var1, Object var2);

    public boolean wasInsertedDuringTransaction(EntityTypeDescriptor var1, Object var2);

    public NaturalIdHelper getNaturalIdHelper();

    public static interface NaturalIdHelper {
        public static final Object INVALID_NATURAL_ID_REFERENCE = new Object(){

            public String toString() {
                return "Invalid natural-id reference";
            }
        };

        public Object[] extractNaturalIdValues(Object[] var1, EntityTypeDescriptor var2);

        public Object[] extractNaturalIdValues(Object var1, EntityTypeDescriptor var2);

        public void cacheNaturalIdCrossReferenceFromLoad(EntityTypeDescriptor var1, Object var2, Object[] var3);

        public void manageLocalNaturalIdCrossReference(EntityTypeDescriptor var1, Object var2, Object[] var3, Object[] var4, CachedNaturalIdValueSource var5);

        public Object[] removeLocalNaturalIdCrossReference(EntityTypeDescriptor var1, Object var2, Object[] var3);

        public void manageSharedNaturalIdCrossReference(EntityTypeDescriptor var1, Object var2, Object[] var3, Object[] var4, CachedNaturalIdValueSource var5);

        public void removeSharedNaturalIdCrossReference(EntityTypeDescriptor var1, Object var2, Object[] var3);

        public Object[] findCachedNaturalId(EntityTypeDescriptor var1, Object var2);

        public Object findCachedNaturalIdResolution(EntityTypeDescriptor var1, Object[] var2);

        public Collection<Object> getCachedPkResolutions(EntityTypeDescriptor var1);

        public void handleSynchronization(EntityTypeDescriptor var1, Object var2, Object var3);

        public void cleanupFromSynchronizations();

        public void handleEviction(Object var1, EntityTypeDescriptor var2, Object var3);
    }
}

