/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.persistence.EntityGraph;
import org.hibernate.CustomEntityDirtinessStrategy;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.MappingException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.cache.spi.CacheImplementor;
import org.hibernate.cfg.Settings;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.spi.SessionBuilderImplementor;
import org.hibernate.exception.spi.SQLExceptionConverter;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryParameterBindingTypeResolver;
import org.hibernate.query.spi.ResultSetMappingDescriptor;
import org.hibernate.query.sqm.produce.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.produce.function.SqmFunctionTemplate;
import org.hibernate.query.sqm.produce.spi.SqmCreationContext;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationContext;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.Type;
import org.hibernate.type.spi.TypeConfiguration;

public interface SessionFactoryImplementor
extends SessionFactory,
QueryParameterBindingTypeResolver,
SqmCreationContext,
SqlAstCreationContext {
    public String getUuid();

    public String getName();

    public TypeConfiguration getTypeConfiguration();

    @Override
    default public MetamodelImplementor getDomainModel() {
        return this.getMetamodel();
    }

    @Override
    default public Function<String, SqmFunctionTemplate> getFunctionResolver() {
        return this.getQueryEngine().getSqmFunctionRegistry()::findFunctionTemplate;
    }

    @Override
    default public Integer getMaximumFetchDepth() {
        return this.getSessionFactoryOptions().getMaximumFetchDepth();
    }

    @Override
    public SessionBuilderImplementor withOptions();

    public Session openTemporarySession() throws HibernateException;

    @Override
    public CacheImplementor getCache();

    @Override
    public StatisticsImplementor getStatistics();

    @Override
    public ServiceRegistryImplementor getServiceRegistry();

    @Deprecated
    public Interceptor getInterceptor();

    public QueryEngine getQueryEngine();

    public FetchProfile getFetchProfile(String var1);

    public IdentifierGenerator getIdentifierGenerator(String var1);

    public EntityNotFoundDelegate getEntityNotFoundDelegate();

    @Deprecated
    default public SqmFunctionRegistry getSqmFunctionRegistry() {
        return this.getQueryEngine().getSqmFunctionRegistry();
    }

    public void addObserver(SessionFactoryObserver var1);

    public CustomEntityDirtinessStrategy getCustomEntityDirtinessStrategy();

    public CurrentTenantIdentifierResolver getCurrentTenantIdentifierResolver();

    public DeserializationResolver getDeserializationResolver();

    @Override
    public MetamodelImplementor getMetamodel();

    @Override
    default public <T> List<EntityGraph<? super T>> findEntityGraphsByType(Class<T> entityClass) {
        return this.findEntityGraphsByJavaType(entityClass);
    }

    public <T> List<RootGraphImplementor<? super T>> findEntityGraphsByJavaType(Class<T> var1);

    public RootGraphImplementor<?> findEntityGraphByName(String var1);

    @Deprecated
    default public Type[] getReturnTypes(String queryString) {
        throw new UnsupportedOperationException("Concept of query return org.hibernate.type.Types is no longer supported");
    }

    @Deprecated
    default public String[] getReturnAliases(String queryString) {
        throw new UnsupportedOperationException("Access to of query return aliases via Sessionfactory is no longer supported");
    }

    @Deprecated
    default public ResultSetMappingDescriptor getResultSetMapping(String name) {
        return this.getQueryEngine().getNamedQueryRepository().getResultSetMappingDescriptor(name);
    }

    public JdbcServices getJdbcServices();

    @Deprecated
    default public Dialect getDialect() {
        if (this.getServiceRegistry() == null) {
            throw new IllegalStateException("Cannot determine dialect because serviceRegistry is null.");
        }
        return this.getServiceRegistry().getService(JdbcServices.class).getDialect();
    }

    @Deprecated
    default public SQLExceptionConverter getSQLExceptionConverter() {
        return this.getServiceRegistry().getService(JdbcServices.class).getSqlExceptionHelper().getSqlExceptionConverter();
    }

    @Deprecated
    default public SqlExceptionHelper getSQLExceptionHelper() {
        return this.getServiceRegistry().getService(JdbcServices.class).getSqlExceptionHelper();
    }

    @Deprecated
    public Settings getSettings();

    @Deprecated
    default public EntityTypeDescriptor getEntityPersister(String entityName) throws MappingException {
        return this.getMetamodel().getEntityDescriptor(entityName);
    }

    @Deprecated
    default public PersistentCollectionDescriptor getCollectionPersister(String role) throws MappingException {
        PersistentCollectionDescriptor collectionDescriptor = this.getMetamodel().findCollectionDescriptor(role);
        if (collectionDescriptor == null) {
            throw new MappingException("Could not locate CollectionPersister for given role [" + role + "]");
        }
        return collectionDescriptor;
    }

    @Deprecated
    default public Set<String> getCollectionRolesByEntityParticipant(String entityName) {
        return this.getMetamodel().findCollectionRolesByEntityParticipant(this.getMetamodel().findEntityDescriptor(entityName));
    }

    @Deprecated
    default public EntityTypeDescriptor locateEntityPersister(Class byClass) {
        return this.getMetamodel().getEntityDescriptor(byClass);
    }

    @Deprecated
    default public EntityTypeDescriptor locateEntityPersister(String byName) {
        return this.getMetamodel().findEntityDescriptor(byName);
    }

    @FunctionalInterface
    public static interface DeserializationResolver<T extends SessionFactoryImplementor>
    extends Serializable {
        public T resolve();
    }
}

