/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.Serializable;
import java.sql.Connection;
import java.util.UUID;
import javax.persistence.FlushModeType;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.SharedSessionContract;
import org.hibernate.Transaction;
import org.hibernate.cache.spi.CacheTransactionSynchronization;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.LobCreationContext;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.ExceptionConverter;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.query.spi.QueryParameterBindingTypeResolver;
import org.hibernate.query.spi.QueryProducerImplementor;
import org.hibernate.query.sqm.mutation.spi.HandlerCreationContext;
import org.hibernate.resource.jdbc.spi.JdbcSessionOwner;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.hibernate.type.descriptor.spi.WrapperOptions;

public interface SharedSessionContractImplementor
extends SharedSessionContract,
JdbcSessionOwner,
TransactionCoordinatorBuilder.Options,
LobCreationContext,
WrapperOptions,
QueryProducerImplementor,
HandlerCreationContext,
QueryParameterBindingTypeResolver {
    @Override
    public SessionFactoryImplementor getFactory();

    public SessionEventListenerManager getEventListenerManager();

    public PersistenceContext getPersistenceContext();

    public JdbcCoordinator getJdbcCoordinator();

    public JdbcServices getJdbcServices();

    @Override
    public String getTenantIdentifier();

    public UUID getSessionIdentifier();

    public boolean isClosed();

    default public boolean isOpenOrWaitingForAutoClose() {
        return !this.isClosed();
    }

    default public void checkOpen() {
        this.checkOpen(true);
    }

    public void checkOpen(boolean var1);

    public void prepareForQueryExecution(boolean var1);

    public void markForRollbackOnly();

    public long getTransactionStartTimestamp();

    @Deprecated
    default public long getTimestamp() {
        return this.getTransactionStartTimestamp();
    }

    public CacheTransactionSynchronization getCacheTransactionSynchronization();

    public boolean isTransactionInProgress();

    public Transaction accessTransaction();

    public EntityKey generateEntityKey(Object var1, EntityTypeDescriptor var2);

    public Interceptor getInterceptor();

    public void setAutoClear(boolean var1);

    public void initializeCollection(PersistentCollection var1, boolean var2) throws HibernateException;

    public Object internalLoad(String var1, Object var2, boolean var3, boolean var4) throws HibernateException;

    public Object immediateLoad(String var1, Object var2) throws HibernateException;

    @Deprecated
    default public EntityTypeDescriptor getEntityPersister(String entityName, Object object) throws HibernateException {
        return this.getEntityDescriptor(entityName, object);
    }

    public EntityTypeDescriptor getEntityDescriptor(String var1, Object var2) throws HibernateException;

    public Object getEntityUsingInterceptor(EntityKey var1) throws HibernateException;

    public Object getContextEntityIdentifier(Object var1);

    public String bestGuessEntityName(Object var1);

    public String guessEntityName(Object var1) throws HibernateException;

    public Object instantiate(String var1, Object var2) throws HibernateException;

    @Deprecated
    default public Object instantiate(String entityName, Serializable id) throws HibernateException {
        return this.instantiate(entityName, (Object)id);
    }

    public boolean isDefaultReadOnly();

    public int getDontFlushFromFind();

    public CacheMode getCacheMode();

    public void setCacheMode(CacheMode var1);

    @Deprecated
    public void setFlushMode(FlushMode var1);

    public FlushModeType getFlushMode();

    public void setHibernateFlushMode(FlushMode var1);

    public FlushMode getHibernateFlushMode();

    public Connection connection();

    public void flush();

    public boolean isEventSource();

    public void afterScrollOperation();

    public boolean shouldAutoClose();

    public boolean isAutoCloseSessionEnabled();

    default public boolean isQueryParametersValidationEnabled() {
        return this.getFactory().getSessionFactoryOptions().isQueryParametersValidationEnabled();
    }

    public LoadQueryInfluencers getLoadQueryInfluencers();

    public ExceptionConverter getExceptionConverter();

    default public Integer getConfiguredJdbcBatchSize() {
        Integer sessionJdbcBatchSize = this.getJdbcBatchSize();
        return sessionJdbcBatchSize == null ? ConfigurationHelper.getInt("hibernate.jdbc.batch_size", this.getFactory().getProperties(), 1) : sessionJdbcBatchSize;
    }
}

