/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.hibernate.internal.util.ValueHolder;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;

public final class TypedValue
implements Serializable {
    private final JavaTypeDescriptor javaTypeDescriptor;
    private final Object value;
    private transient ValueHolder<Integer> hashcode;

    public TypedValue(JavaTypeDescriptor javaTypeDescriptor, Object value) {
        this.javaTypeDescriptor = javaTypeDescriptor;
        this.value = value;
        this.initTransients();
    }

    public Object getValue() {
        return this.value;
    }

    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.javaTypeDescriptor;
    }

    public String toString() {
        return this.value == null ? "null" : this.value.toString();
    }

    public int hashCode() {
        return this.hashcode.getValue();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TypedValue that = (TypedValue)other;
        return this.javaTypeDescriptor.getJavaType() == that.javaTypeDescriptor.getJavaType() && this.javaTypeDescriptor.areEqual(that.value, this.value);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.initTransients();
    }

    private void initTransients() {
        this.hashcode = new ValueHolder<1>(new ValueHolder.DeferredInitializer<Integer>(){

            @Override
            public Integer initialize() {
                return TypedValue.this.value == null ? 0 : TypedValue.this.javaTypeDescriptor.extractHashCode(TypedValue.this.value);
            }
        });
    }
}

