/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.boot.internal;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.envers.RevisionListener;
import org.hibernate.envers.boot.AuditMetadataBuilder;
import org.hibernate.envers.boot.internal.AuditMetadataImpl;
import org.hibernate.envers.boot.internal.StrategyCreatorAuditStrategyImpl;
import org.hibernate.envers.boot.spi.AuditMetadataBuilderImplementor;
import org.hibernate.envers.boot.spi.AuditMetadataBuildingOptions;
import org.hibernate.envers.boot.spi.AuditMetadataImplementor;
import org.hibernate.envers.configuration.internal.EntitiesConfigurator;
import org.hibernate.envers.configuration.internal.MappingCollector;
import org.hibernate.envers.configuration.internal.RevisionInfoConfiguration;
import org.hibernate.envers.configuration.internal.RevisionInfoConfigurationBuilder;
import org.hibernate.envers.internal.entities.EntitiesConfigurations;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.envers.strategy.AuditStrategy;
import org.hibernate.envers.strategy.internal.DefaultAuditStrategy;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.ServiceRegistry;

public class AuditMetadataBuilderImpl
implements AuditMetadataBuilderImplementor {
    private final InFlightMetadataCollector metadata;
    private final AuditMetadataBuildingOptionsImpl options;
    private RevisionInfoConfiguration revisionInfoConfiguration;
    private EntitiesConfigurations entitiesConfigurations;

    public AuditMetadataBuilderImpl(InFlightMetadataCollector metadata) {
        this.metadata = metadata;
        this.options = new AuditMetadataBuildingOptionsImpl(metadata.getMetadataBuildingOptions().getServiceRegistry());
    }

    @Override
    public AuditMetadataBuildingOptions getAuditMetadataBuildingOptions() {
        return this.options;
    }

    @Override
    public AuditMetadataBuilder applyMappingCollector(MappingCollector mappingCollector) {
        this.buildMappings(mappingCollector);
        return this;
    }

    @Override
    public AuditMetadataBuilder applyTrackEntitiesChangedInRevision(boolean trackEntitiesChangedInRevision) {
        this.options.trackEntitiesChangedInRevision = trackEntitiesChangedInRevision;
        return this;
    }

    @Override
    public AuditMetadataBuilder applyRevisionInfoEntityName(String revisionInfoEntityName) {
        this.options.revisionInfoEntityName = revisionInfoEntityName;
        return this;
    }

    @Override
    public AuditMetadataImplementor build() {
        return new AuditMetadataImpl(this.options, this.revisionInfoConfiguration, this.entitiesConfigurations);
    }

    private void buildMappings(MappingCollector mappingCollector) {
        this.revisionInfoConfiguration = new RevisionInfoConfigurationBuilder(this.metadata, this).build();
        this.options.auditStrategy = this.options.serviceRegistry.getService(StrategySelector.class).resolveStrategy(AuditStrategy.class, (Object)this.options.auditStrategyName, () -> new org.hibernate.envers.strategy.DefaultAuditStrategy(), new StrategyCreatorAuditStrategyImpl(this.revisionInfoConfiguration.getRevisionInfoTimestampData(), this.revisionInfoConfiguration.getRevisionInfoClass(), this.options.serviceRegistry));
        this.entitiesConfigurations = new EntitiesConfigurator(this).build(this.metadata, mappingCollector, this.revisionInfoConfiguration.getRevisionInfoXmlMapping(), this.revisionInfoConfiguration.getRevisionInfoRelationMapping());
    }

    public static class AuditMetadataBuildingOptionsImpl
    implements AuditMetadataBuildingOptions {
        private final ServiceRegistry serviceRegistry;
        private final boolean generateRevisionsForCollections;
        private final boolean doNotAuditOptimsiticLockingField;
        private final boolean storeDataAtDelete;
        private final String defaultSchemaName;
        private final String defaultCatalogName;
        private final boolean globalWithModifiedFlag;
        private final boolean hasGlobalSettingForWithModifiedFlag;
        private final boolean globalLegacyRelationTargetNotFound;
        private final String modifiedFlagSuffix;
        private final boolean useRevisionEntityWithNativeId;
        private final boolean cascadeDeleteRevision;
        private final boolean allowIdentifierReuse;
        private final String correlatedSubqueryOperator;
        private final String auditTablePrefix;
        private final String auditTableSuffix;
        private final String auditStrategyName;
        private final String originalIdPropertyName;
        private final String revisionFieldName;
        private final String revisionNumberPath;
        private final String revisionPropertyBasePath;
        private final String revisionTypePropertyName;
        private final String revisionTypePropertyType;
        private final String revisionEndFieldName;
        private final String revisionEndTimestampFieldName;
        private final boolean revisionEndTimestampEnabled;
        private final boolean numericRevisionEndTimestampEnabled;
        private final boolean revisionEndTimestampLegacyBehaviorEnabled;
        private final String embeddableSetOrdinalPropertyName;
        private boolean trackEntitiesChangedInRevision;
        private String revisionInfoEntityName;
        private String revisionListenerClassName;
        private AuditStrategy auditStrategy;
        private Class<? extends RevisionListener> revisionListenerClass;
        private final Map<String, String> customAuditTablesNames;

        public AuditMetadataBuildingOptionsImpl(ServiceRegistry serviceRegistry) {
            this.serviceRegistry = serviceRegistry;
            this.customAuditTablesNames = new HashMap<String, String>();
            ConfigurationService cfgService = serviceRegistry.getService(ConfigurationService.class);
            Map properties = cfgService.getSettings();
            this.generateRevisionsForCollections = ConfigurationHelper.getBoolean("org.hibernate.envers.revision_on_collection_change", properties, true);
            this.doNotAuditOptimsiticLockingField = ConfigurationHelper.getBoolean("org.hibernate.envers.do_not_audit_optimistic_locking_field", properties, true);
            this.storeDataAtDelete = ConfigurationHelper.getBoolean("org.hibernate.envers.store_data_at_delete", properties, false);
            this.defaultSchemaName = (String)properties.get("org.hibernate.envers.default_schema");
            this.defaultCatalogName = (String)properties.get("org.hibernate.envers.default_catalog");
            this.correlatedSubqueryOperator = HSQLDialect.class.getName().equals(properties.get("hibernate.dialect")) ? "in" : "=";
            this.trackEntitiesChangedInRevision = ConfigurationHelper.getBoolean("org.hibernate.envers.track_entities_changed_in_revision", properties, false);
            this.cascadeDeleteRevision = ConfigurationHelper.getBoolean("org.hibernate.envers.cascade_delete_revision", properties, false);
            this.useRevisionEntityWithNativeId = ConfigurationHelper.getBoolean("org.hibernate.envers.use_revision_entity_with_native_id", properties, true);
            this.hasGlobalSettingForWithModifiedFlag = properties.get("org.hibernate.envers.global_with_modified_flag") != null;
            this.globalWithModifiedFlag = ConfigurationHelper.getBoolean("org.hibernate.envers.global_with_modified_flag", properties, false);
            this.globalLegacyRelationTargetNotFound = ConfigurationHelper.getBoolean("org.hibernate.envers.global_relation_not_found_legacy_flag", properties, true);
            this.modifiedFlagSuffix = ConfigurationHelper.getString("org.hibernate.envers.modified_flag_suffix", properties, "_MOD");
            this.allowIdentifierReuse = ConfigurationHelper.getBoolean("org.hibernate.envers.allow_identifier_reuse", properties, false);
            this.revisionListenerClassName = (String)properties.get("org.hibernate.envers.revision_listener");
            if (this.revisionListenerClassName != null) {
                try {
                    this.revisionListenerClass = ReflectionTools.loadClass(this.revisionListenerClassName, serviceRegistry.getService(ClassLoaderService.class));
                }
                catch (ClassLoadingException e) {
                    throw new MappingException("Revision listener class not found: " + this.revisionListenerClassName, (Throwable)((Object)e));
                }
            }
            this.auditTablePrefix = ConfigurationHelper.getString("org.hibernate.envers.audit_table_prefix", properties, "");
            this.auditTableSuffix = ConfigurationHelper.getString("org.hibernate.envers.audit_table_suffix", properties, "_AUD");
            this.auditStrategyName = ConfigurationHelper.getString("org.hibernate.envers.audit_strategy", properties, DefaultAuditStrategy.class.getName());
            this.originalIdPropertyName = "originalId";
            this.revisionFieldName = ConfigurationHelper.getString("org.hibernate.envers.revision_field_name", properties, "REV");
            this.revisionTypePropertyName = ConfigurationHelper.getString("org.hibernate.envers.revision_type_field_name", properties, "REVTYPE");
            this.revisionTypePropertyType = "byte";
            this.revisionEndFieldName = ConfigurationHelper.getString("org.hibernate.envers.audit_strategy_validity_end_rev_field_name", properties, "REVEND");
            this.revisionEndTimestampEnabled = ConfigurationHelper.getBoolean("org.hibernate.envers.audit_strategy_validity_store_revend_timestamp", properties, false);
            this.numericRevisionEndTimestampEnabled = this.revisionEndTimestampEnabled ? ConfigurationHelper.getBoolean("org.hibernate.envers.use_numeric_revend_timestamp_field_type", properties, false) : false;
            this.embeddableSetOrdinalPropertyName = ConfigurationHelper.getString("org.hibernate.envers.embeddable_set_ordinal_field_name", properties, "SETORDINAL");
            this.revisionEndTimestampFieldName = this.revisionEndTimestampEnabled ? ConfigurationHelper.getString("org.hibernate.envers.audit_strategy_validity_revend_timestamp_field_name", properties, "REVEND_TSTMP") : null;
            this.revisionEndTimestampLegacyBehaviorEnabled = ConfigurationHelper.getBoolean("org.hibernate.envers.audit_strategy_validity_legacy_revend_timestamp", properties, false);
            this.revisionPropertyBasePath = this.originalIdPropertyName + "." + this.revisionFieldName + ".";
            this.revisionNumberPath = this.revisionPropertyBasePath + "id";
        }

        @Override
        public ServiceRegistry getServiceRegistry() {
            return this.serviceRegistry;
        }

        @Override
        public boolean isRevisionOnCollectionChangeEnabled() {
            return this.generateRevisionsForCollections;
        }

        @Override
        public boolean isDoNotAuditOptimisticLockingFieldEnabled() {
            return this.doNotAuditOptimsiticLockingField;
        }

        @Override
        public boolean isStoreDataAtDeleteEnabled() {
            return this.storeDataAtDelete;
        }

        @Override
        public boolean isTrackEntitiesChangedInRevisionEnabled() {
            return this.trackEntitiesChangedInRevision;
        }

        @Override
        public boolean isGlobalWithModifiedFlagEnabled() {
            return this.globalWithModifiedFlag;
        }

        @Override
        public boolean isGlobalLegacyRelationTargetNotFoundEnabled() {
            return this.globalLegacyRelationTargetNotFound;
        }

        @Override
        public boolean hasGlobalWithModifiedFlag() {
            return this.hasGlobalSettingForWithModifiedFlag;
        }

        @Override
        public boolean isUseRevisionEntityWithNativeIdEnabled() {
            return this.useRevisionEntityWithNativeId;
        }

        @Override
        public boolean isCascadeDeleteRevisionEnabled() {
            return this.cascadeDeleteRevision;
        }

        @Override
        public boolean isAllowIdentifierReuseEnabled() {
            return this.allowIdentifierReuse;
        }

        @Override
        public String getDefaultSchemaName() {
            return this.defaultSchemaName;
        }

        @Override
        public String getDefaultCatalogName() {
            return this.defaultCatalogName;
        }

        @Override
        public String getCorrelatedSubqueryOperator() {
            return this.correlatedSubqueryOperator;
        }

        @Override
        public String getModifiedFlagSuffix() {
            return this.modifiedFlagSuffix;
        }

        @Override
        public String getRevisionInfoEntityName() {
            return this.revisionInfoEntityName;
        }

        @Override
        public AuditStrategy getAuditStrategy() {
            return this.auditStrategy;
        }

        @Override
        public Class<? extends RevisionListener> getRevisionListenerClass() {
            return this.revisionListenerClass;
        }

        @Override
        public String getOriginalIdPropName() {
            return this.originalIdPropertyName;
        }

        @Override
        public String getRevisionFieldName() {
            return this.revisionFieldName;
        }

        @Override
        public boolean isRevisionEndTimestampEnabled() {
            return this.revisionEndTimestampEnabled;
        }

        @Override
        public boolean isRevisionEndTimestampLegacyBehaviorEnabled() {
            return this.revisionEndTimestampLegacyBehaviorEnabled;
        }

        @Override
        public String getRevisionEndTimestampFieldName() {
            return this.revisionEndTimestampFieldName;
        }

        @Override
        public boolean isNumericRevisionEndTimestampEnabled() {
            return this.numericRevisionEndTimestampEnabled;
        }

        @Override
        public String getRevisionNumberPath() {
            return this.revisionNumberPath;
        }

        @Override
        public String getRevisionTypePropName() {
            return this.revisionTypePropertyName;
        }

        @Override
        public String getRevisionTypePropType() {
            return this.revisionTypePropertyType;
        }

        @Override
        public String getRevisionEndFieldName() {
            return this.revisionEndFieldName;
        }

        @Override
        public String getEmbeddableSetOrdinalPropertyName() {
            return this.embeddableSetOrdinalPropertyName;
        }

        @Override
        public String getAuditEntityName(String entityName) {
            return this.auditTablePrefix + entityName + this.auditTableSuffix;
        }

        @Override
        public void addCustomAuditTableName(String entityName, String tableName) {
            this.customAuditTablesNames.put(entityName, tableName);
        }

        @Override
        public String getAuditTableName(String entityName, String tableName) {
            String customHistoryTableName = this.customAuditTablesNames.get(entityName);
            if (customHistoryTableName == null) {
                return this.auditTablePrefix + tableName + this.auditTableSuffix;
            }
            return customHistoryTableName;
        }

        @Override
        public String getRevisionPropertyPath(String propertyName) {
            return this.revisionPropertyBasePath + propertyName;
        }
    }
}

