/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.boot.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.Transaction;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.envers.boot.AuditMetadata;
import org.hibernate.envers.boot.spi.AuditServiceImplementor;
import org.hibernate.envers.boot.spi.AuditServiceOptions;
import org.hibernate.envers.internal.entities.EntitiesConfigurations;
import org.hibernate.envers.internal.revisioninfo.ModifiedEntityNamesReader;
import org.hibernate.envers.internal.revisioninfo.RevisionInfoNumberReader;
import org.hibernate.envers.internal.revisioninfo.RevisionInfoQueryCreator;
import org.hibernate.envers.internal.synchronization.AuditProcess;
import org.hibernate.event.spi.EventSource;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class AuditServiceImpl
implements AuditServiceImplementor {
    private final ClassLoaderService classLoaderService;
    private final Map<Transaction, AuditProcess> auditProcesses;
    private AuditMetadata auditMetadata;

    public AuditServiceImpl(ServiceRegistryImplementor serviceRegistry) {
        this.classLoaderService = serviceRegistry.getService(ClassLoaderService.class);
        this.auditProcesses = new ConcurrentHashMap<Transaction, AuditProcess>();
    }

    @Override
    public void initialize(AuditMetadata auditMetadata) {
        this.auditMetadata = auditMetadata;
    }

    @Override
    public AuditServiceOptions getOptions() {
        return this.auditMetadata.getAuditMetadataBuildingOptions();
    }

    @Override
    public EntitiesConfigurations getEntityBindings() {
        return this.auditMetadata.getEntitiesConfigurations();
    }

    @Override
    public AuditProcess getAuditProcess(EventSource session) {
        return this.getOrCreateAuditProcess(session);
    }

    @Override
    public RevisionInfoNumberReader getRevisionInfoNumberReader() {
        return this.auditMetadata.getRevisionInfoNumberReader();
    }

    @Override
    public RevisionInfoQueryCreator getRevisionInfoQueryCreator() {
        return this.auditMetadata.getRevisionInfoQueryCreator();
    }

    @Override
    public ModifiedEntityNamesReader getModifiedEntityNamesReader() {
        return this.auditMetadata.getModifiedEntityNamesReader();
    }

    @Override
    public String getAuditEntityName(String entityName) {
        return this.auditMetadata.getAuditMetadataBuildingOptions().getAuditEntityName(entityName);
    }

    @Override
    public String getRevisionPropertyPath(String propertyName) {
        return this.auditMetadata.getAuditMetadataBuildingOptions().getRevisionPropertyPath(propertyName);
    }

    @Override
    public ClassLoaderService getClassLoaderService() {
        return this.classLoaderService;
    }

    @Override
    public AuditMetadata getMetadata() {
        return this.auditMetadata;
    }

    private AuditProcess getOrCreateAuditProcess(EventSource session) {
        Transaction transaction = session.accessTransaction();
        AuditProcess auditProcess = this.auditProcesses.get(transaction);
        if (auditProcess == null) {
            auditProcess = this.createAuditProcess(session, transaction);
            this.auditProcesses.put(transaction, auditProcess);
        }
        return auditProcess;
    }

    private AuditProcess createAuditProcess(EventSource session, Transaction transaction) {
        AuditProcess auditProcess = new AuditProcess(this.auditMetadata.getRevisionInfoGenerator(), session);
        session.getActionQueue().registerProcess(sessionImplementor -> {
            AuditProcess auditProcess1 = this.auditProcesses.get(transaction);
            if (auditProcess1 != null) {
                auditProcess1.doBeforeTransactionCompletion(sessionImplementor);
            }
        });
        session.getActionQueue().registerProcess((success, sessionImplementor) -> this.auditProcesses.remove(transaction));
        return auditProcess;
    }
}

