/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.boot.internal;

import org.hibernate.boot.Metadata;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.envers.boot.AuditService;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.event.internal.EnversPostCollectionRecreateEventListenerImpl;
import org.hibernate.envers.event.internal.EnversPostDeleteEventListenerImpl;
import org.hibernate.envers.event.internal.EnversPostInsertEventListenerImpl;
import org.hibernate.envers.event.internal.EnversPostUpdateEventListenerImpl;
import org.hibernate.envers.event.internal.EnversPreCollectionRemoveEventListenerImpl;
import org.hibernate.envers.event.internal.EnversPreCollectionUpdateEventListenerImpl;
import org.hibernate.envers.event.internal.EnversPreUpdateEventListenerImpl;
import org.hibernate.envers.event.spi.EnversListenerDuplicationStrategy;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.jboss.logging.Logger;

public class EnversIntegrator
implements Integrator {
    private static final Logger LOG = Logger.getLogger(EnversIntegrator.class);
    public static final String AUTO_REGISTER = "hibernate.envers.autoRegisterListeners";
    private AuditService auditService;
    private EnversService enversService;

    @Override
    public void integrate(Metadata metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        this.enversService = serviceRegistry.getService(EnversService.class);
        this.auditService = serviceRegistry.getService(AuditService.class);
        if (!this.enversService.isEnabled()) {
            LOG.debug((Object)"Skipping Envers listener registrations : EnversService disabled");
            return;
        }
        boolean autoRegister = serviceRegistry.getService(ConfigurationService.class).getSetting(AUTO_REGISTER, StandardConverters.BOOLEAN, Boolean.valueOf(true));
        if (!autoRegister) {
            LOG.debug((Object)"Skipping Envers listener registrations : Listener auto-registration disabled");
            return;
        }
        this.initializeMetadata((MetadataImplementor)metadata);
        if (!this.auditService.getEntityBindings().hasAuditedEntities()) {
            LOG.debug((Object)"Skipping Envers listener registrations : No audited entities found");
            return;
        }
        EventListenerRegistry listenerRegistry = serviceRegistry.getService(EventListenerRegistry.class);
        listenerRegistry.addDuplicationStrategy(EnversListenerDuplicationStrategy.INSTANCE);
        this.registerListeners(listenerRegistry, this.auditService);
    }

    @Override
    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }

    private void initializeMetadata(MetadataImplementor metadata) {
        this.auditService.initialize(metadata.getAuditMetadataBuilder().build());
    }

    private void registerListeners(EventListenerRegistry listenerRegistry, AuditService auditService) {
        listenerRegistry.appendListeners(EventType.POST_DELETE, new EnversPostDeleteEventListenerImpl(auditService));
        listenerRegistry.appendListeners(EventType.POST_INSERT, new EnversPostInsertEventListenerImpl(auditService));
        listenerRegistry.appendListeners(EventType.PRE_UPDATE, new EnversPreUpdateEventListenerImpl(auditService));
        listenerRegistry.appendListeners(EventType.POST_UPDATE, new EnversPostUpdateEventListenerImpl(auditService));
        listenerRegistry.appendListeners(EventType.POST_COLLECTION_RECREATE, new EnversPostCollectionRecreateEventListenerImpl(auditService));
        listenerRegistry.appendListeners(EventType.PRE_COLLECTION_REMOVE, new EnversPreCollectionRemoveEventListenerImpl(auditService));
        listenerRegistry.appendListeners(EventType.PRE_COLLECTION_UPDATE, new EnversPreCollectionUpdateEventListenerImpl(auditService));
    }
}

