/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.boot.internal;

import java.util.Map;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Stoppable;
import org.jboss.logging.Logger;

public class EnversServiceImpl
implements EnversService,
Configurable,
Stoppable {
    private static final Logger log = Logger.getLogger(EnversServiceImpl.class);
    private static final String INTEGRATION_ENABLED = "hibernate.integration.envers.enabled";
    private static final String LEGACY_AUTO_REGISTER = "hibernate.listeners.envers.autoRegister";
    private boolean integrationEnabled;

    @Override
    public void configure(Map configurationValues) {
        if (configurationValues.containsKey(LEGACY_AUTO_REGISTER)) {
            log.debugf("Encountered deprecated Envers setting [%s]; use [%s] or [%s] instead", (Object)LEGACY_AUTO_REGISTER, (Object)INTEGRATION_ENABLED, (Object)"hibernate.envers.autoRegisterListeners");
        }
        this.integrationEnabled = ConfigurationHelper.getBoolean(INTEGRATION_ENABLED, configurationValues, true);
        log.infof("Envers integration enabled? : %s", (Object)this.integrationEnabled);
    }

    @Override
    public boolean isEnabled() {
        return this.integrationEnabled;
    }

    @Override
    public void stop() {
    }
}

