/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.boot.internal;

import java.util.function.Function;
import org.hibernate.MappingException;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.strategy.AuditStrategy;
import org.hibernate.service.ServiceRegistry;
import org.jboss.logging.Logger;

public class StrategyCreatorAuditStrategyImpl<I extends AuditStrategy>
implements Function<Class<I>, I> {
    private static final Logger log = Logger.getLogger(StrategyCreatorAuditStrategyImpl.class);
    private final PropertyData timestampData;
    private final Class<?> revisionInfoClass;
    private final ServiceRegistry serviceRegistry;

    StrategyCreatorAuditStrategyImpl(PropertyData timestampData, Class<?> revisionInfoClass, ServiceRegistry serviceRegistry) {
        this.timestampData = timestampData;
        this.revisionInfoClass = revisionInfoClass;
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public I apply(Class<I> strategyImplClass) {
        log.debugf("Creating AuditStrategy Impl [%s]", (Object)strategyImplClass.getName());
        try {
            AuditStrategy strategy = (AuditStrategy)strategyImplClass.newInstance();
            strategy.postInitialize(this.revisionInfoClass, this.timestampData, this.serviceRegistry);
            return (I)strategy;
        }
        catch (Exception e) {
            throw new MappingException(String.format("Unable to create AuditStrategy [%s].", strategyImplClass.getName()));
        }
    }
}

