/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal;

import java.util.HashMap;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.hibernate.MappingException;
import org.hibernate.annotations.common.reflection.ClassLoadingException;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.envers.boot.spi.AuditMetadataBuilderImplementor;
import org.hibernate.envers.configuration.internal.ClassesAuditingData;
import org.hibernate.envers.configuration.internal.MappingCollector;
import org.hibernate.envers.configuration.internal.PersistentClassGraphDefiner;
import org.hibernate.envers.configuration.internal.metadata.AuditEntityNameRegister;
import org.hibernate.envers.configuration.internal.metadata.AuditMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.EntityXmlMappingData;
import org.hibernate.envers.configuration.internal.metadata.reader.AnnotationsMetadataReader;
import org.hibernate.envers.configuration.internal.metadata.reader.ClassAuditingData;
import org.hibernate.envers.internal.entities.EntitiesConfigurations;
import org.hibernate.envers.internal.tools.StringTools;
import org.hibernate.envers.internal.tools.graph.GraphTopologicalSort;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.service.ServiceRegistry;

public class EntitiesConfigurator {
    private final ServiceRegistry serviceRegistry;
    private final AuditMetadataBuilderImplementor auditMetadataBuilder;
    private final AuditEntityNameRegister auditEntityNameRegister;
    private final Map<PersistentClass, EntityXmlMappingData> xmlMappings;

    public EntitiesConfigurator(AuditMetadataBuilderImplementor auditMetadataBuilder) {
        this.auditMetadataBuilder = auditMetadataBuilder;
        this.serviceRegistry = auditMetadataBuilder.getAuditMetadataBuildingOptions().getServiceRegistry();
        this.auditEntityNameRegister = new AuditEntityNameRegister();
        this.xmlMappings = new HashMap<PersistentClass, EntityXmlMappingData>();
    }

    public EntitiesConfigurations build(InFlightMetadataCollector metadata, MappingCollector mappingCollector, Document revisionInfoXmlMapping, Element revisionInfoRelationMapping) {
        return this.complete(this.prepare(metadata), metadata, mappingCollector, revisionInfoXmlMapping, revisionInfoRelationMapping);
    }

    private ClassesAuditingData prepare(InFlightMetadataCollector metadata) {
        ReflectionManager reflectionManager = metadata.getBootstrapContext().getReflectionManager();
        ClassesAuditingData classesAuditingData = new ClassesAuditingData();
        for (PersistentClass persistentClass : GraphTopologicalSort.sort(new PersistentClassGraphDefiner(metadata))) {
            if (persistentClass.getClassName() == null) continue;
            try {
                XClass clazz = reflectionManager.classForName(persistentClass.getClassName());
                AnnotationsMetadataReader reader = new AnnotationsMetadataReader(this.auditMetadataBuilder.getAuditMetadataBuildingOptions(), reflectionManager, persistentClass, clazz);
                classesAuditingData.addClassAuditingData(persistentClass, reader.getAuditData());
            }
            catch (ClassLoadingException classLoadingException) {}
        }
        classesAuditingData.updateCalculatedFields();
        return classesAuditingData;
    }

    private EntitiesConfigurations complete(ClassesAuditingData classesAuditingData, InFlightMetadataCollector metadata, MappingCollector mappingCollector, Document revisionInfoXmlMapping, Element revisionInfoRelationMapping) {
        AuditMetadataGenerator auditMetaGen = new AuditMetadataGenerator(metadata, this.serviceRegistry, this.auditMetadataBuilder.getAuditMetadataBuildingOptions(), revisionInfoRelationMapping, this.auditEntityNameRegister);
        this.firstPass(classesAuditingData, auditMetaGen);
        this.secondPass(classesAuditingData, auditMetaGen, mappingCollector, revisionInfoXmlMapping);
        return new EntitiesConfigurations(auditMetaGen.getEntitiesConfigurations(), auditMetaGen.getNotAuditedEntitiesConfigurations());
    }

    private void firstPass(ClassesAuditingData classesAuditingData, AuditMetadataGenerator generator) {
        for (Map.Entry<PersistentClass, ClassAuditingData> pcDatasEntry : classesAuditingData.getAllClassAuditedData()) {
            PersistentClass pc = pcDatasEntry.getKey();
            ClassAuditingData auditData = pcDatasEntry.getValue();
            EntityXmlMappingData xmlMappingData = new EntityXmlMappingData();
            if (auditData.isAudited()) {
                if (!StringTools.isEmpty(auditData.getAuditTable().value())) {
                    this.auditMetadataBuilder.getAuditMetadataBuildingOptions().addCustomAuditTableName(pc.getEntityName(), auditData.getAuditTable().value());
                }
                generator.generateFirstPass(pc, auditData, xmlMappingData, true);
            } else {
                generator.generateFirstPass(pc, auditData, xmlMappingData, false);
            }
            this.xmlMappings.put(pc, xmlMappingData);
        }
    }

    private void secondPass(ClassesAuditingData classesAuditingData, AuditMetadataGenerator generator, MappingCollector mappingCollector, Document revisionInfoXmlMapping) {
        for (Map.Entry<PersistentClass, ClassAuditingData> pcDatasEntry : classesAuditingData.getAllClassAuditedData()) {
            EntityXmlMappingData xmlMappingData = this.xmlMappings.get(pcDatasEntry.getKey());
            if (!pcDatasEntry.getValue().isAudited()) continue;
            generator.generateSecondPass(pcDatasEntry.getKey(), pcDatasEntry.getValue(), xmlMappingData);
            try {
                mappingCollector.addDocument(xmlMappingData.getMainXmlMapping());
                for (Document additionalMapping : xmlMappingData.getAdditionalXmlMappings()) {
                    mappingCollector.addDocument(additionalMapping);
                }
            }
            catch (DocumentException e) {
                throw new MappingException(e);
            }
        }
        if (generator.getEntitiesConfigurations().size() > 0) {
            try {
                if (revisionInfoXmlMapping != null) {
                    mappingCollector.addDocument(revisionInfoXmlMapping);
                }
            }
            catch (DocumentException e) {
                throw new MappingException(e);
            }
        }
    }
}

