/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.envers.internal.tools.graph.GraphDefiner;
import org.hibernate.mapping.PersistentClass;

public class PersistentClassGraphDefiner
implements GraphDefiner<PersistentClass, String> {
    private final MetadataImplementor metadata;

    public PersistentClassGraphDefiner(MetadataImplementor metadata) {
        this.metadata = metadata;
    }

    @Override
    public String getRepresentation(PersistentClass pc) {
        return pc.getEntityName();
    }

    @Override
    public PersistentClass getValue(String entityName) {
        return this.metadata.getEntityBinding(entityName);
    }

    private void addNeighbours(Collection<PersistentClass> neighbours, Iterator<PersistentClass> subclassIterator) {
        while (subclassIterator.hasNext()) {
            PersistentClass subclass = subclassIterator.next();
            neighbours.add(subclass);
            this.addNeighbours(neighbours, subclass.getSubclassIterator());
        }
    }

    @Override
    public Collection<PersistentClass> getNeighbours(PersistentClass pc) {
        ArrayList<PersistentClass> neighbours = new ArrayList<PersistentClass>();
        this.addNeighbours(neighbours, pc.getSubclassIterator());
        return neighbours;
    }

    @Override
    public Collection<PersistentClass> getValues() {
        return this.metadata.getEntityBindings();
    }
}

