/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal;

import java.sql.Date;
import java.time.LocalDateTime;
import java.util.Set;
import javax.persistence.Column;
import org.dom4j.Document;
import org.dom4j.Element;
import org.hibernate.MappingException;
import org.hibernate.annotations.common.reflection.ClassLoadingException;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.envers.Audited;
import org.hibernate.envers.DefaultRevisionEntity;
import org.hibernate.envers.DefaultTrackingModifiedEntitiesRevisionEntity;
import org.hibernate.envers.ModifiedEntityNames;
import org.hibernate.envers.RevisionEntity;
import org.hibernate.envers.RevisionListener;
import org.hibernate.envers.RevisionNumber;
import org.hibernate.envers.RevisionTimestamp;
import org.hibernate.envers.boot.spi.AuditMetadataBuilderImplementor;
import org.hibernate.envers.boot.spi.AuditMetadataBuildingOptions;
import org.hibernate.envers.configuration.internal.RevisionInfoConfiguration;
import org.hibernate.envers.configuration.internal.metadata.AuditTableData;
import org.hibernate.envers.configuration.internal.metadata.MetadataTools;
import org.hibernate.envers.enhanced.SequenceIdRevisionEntity;
import org.hibernate.envers.enhanced.SequenceIdTrackingModifiedEntitiesRevisionEntity;
import org.hibernate.envers.internal.EnversMessageLogger;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.RevisionTimestampData;
import org.hibernate.envers.internal.revisioninfo.DefaultRevisionInfoGenerator;
import org.hibernate.envers.internal.revisioninfo.DefaultTrackingModifiedEntitiesRevisionInfoGenerator;
import org.hibernate.envers.internal.revisioninfo.ModifiedEntityNamesReader;
import org.hibernate.envers.internal.revisioninfo.RevisionInfoNumberReader;
import org.hibernate.envers.internal.revisioninfo.RevisionInfoQueryCreator;
import org.hibernate.envers.internal.revisioninfo.RevisionTimestampValueResolver;
import org.hibernate.envers.internal.tools.MutableBoolean;
import org.hibernate.internal.util.xml.XMLHelper;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.type.descriptor.java.internal.LongJavaDescriptor;
import org.hibernate.type.spi.BasicType;
import org.hibernate.type.spi.StandardSpiBasicTypes;
import org.jboss.logging.Logger;

public class RevisionInfoConfigurationBuilder {
    private static final EnversMessageLogger LOG = (EnversMessageLogger)Logger.getMessageLogger(EnversMessageLogger.class, (String)RevisionInfoConfigurationBuilder.class.getName());
    private final MetadataImplementor metadata;
    private final ReflectionManager reflectionManager;
    private final XMLHelper xmlHelper;
    private final AuditMetadataBuilderImplementor auditMetadataBuilder;
    private final AuditMetadataBuildingOptions options;
    private String revisionInfoEntityName;
    private PropertyData revisionInfoIdData;
    private RevisionTimestampData revisionInfoTimestampData;
    private PropertyData modifiedEntityNamesData;
    private BasicType revisionPropType;
    private String revisionPropColumnDefinition;

    public RevisionInfoConfigurationBuilder(InFlightMetadataCollector metadata, AuditMetadataBuilderImplementor auditMetadataBuilder) {
        this.metadata = metadata;
        this.reflectionManager = metadata.getBootstrapContext().getReflectionManager();
        this.options = auditMetadataBuilder.getAuditMetadataBuildingOptions();
        this.auditMetadataBuilder = auditMetadataBuilder;
        this.xmlHelper = new XMLHelper(this.options.getServiceRegistry().getService(ClassLoaderService.class));
        this.revisionInfoEntityName = this.options.isUseRevisionEntityWithNativeIdEnabled() ? "org.hibernate.envers.DefaultRevisionEntity" : "org.hibernate.envers.enhanced.SequenceIdRevisionEntity";
        this.revisionInfoIdData = new PropertyData("id", "id", "field");
        this.revisionInfoTimestampData = new RevisionTimestampData("timestamp", "timestamp", "field", LongJavaDescriptor.INSTANCE);
        this.modifiedEntityNamesData = new PropertyData("modifiedEntityNames", "modifiedEntityNames", "field");
        this.revisionPropType = StandardSpiBasicTypes.INTEGER;
    }

    public RevisionInfoConfiguration build() {
        boolean revisionEntityFound = false;
        DefaultRevisionInfoGenerator revisionInfoGenerator = null;
        Class revisionInfoClass = null;
        RevisionTimestampValueResolver timestampValueResolver = null;
        for (PersistentClass persistentClass : this.metadata.getEntityBindings()) {
            XClass clazz;
            if (persistentClass.getClassName() == null) continue;
            try {
                clazz = this.reflectionManager.classForName(persistentClass.getClassName());
            }
            catch (ClassLoadingException e) {
                continue;
            }
            RevisionEntity revisionEntity = (RevisionEntity)clazz.getAnnotation(RevisionEntity.class);
            if (revisionEntity == null) continue;
            if (revisionEntityFound) {
                throw new MappingException("Only one entity may be annotated with @RevisionEntity!");
            }
            if (clazz.getAnnotation(Audited.class) != null) {
                throw new MappingException("An entity annotated with @RevisionEntity cannot be audited!");
            }
            revisionEntityFound = true;
            MutableBoolean revisionNumberFound = new MutableBoolean();
            MutableBoolean revisionTimestampFound = new MutableBoolean();
            MutableBoolean modifiedEntityNamesFound = new MutableBoolean();
            this.searchForRevisionInfoCfg(clazz, persistentClass, this.reflectionManager, revisionNumberFound, revisionTimestampFound, modifiedEntityNamesFound);
            if (!revisionNumberFound.isSet()) {
                throw new MappingException("An entity annotated with @RevisionEntity must have a field annotated with @RevisionNumber!");
            }
            if (!revisionTimestampFound.isSet()) {
                throw new MappingException("An entity annotated with @RevisionEntity must have a field annotated with @RevisionTimestamp!");
            }
            this.revisionInfoEntityName = persistentClass.getEntityName();
            revisionInfoClass = persistentClass.getMappedClass();
            Class<? extends RevisionListener> revisionListenerClass = this.getRevisionListenerClass(revisionEntity.value());
            if (this.options.isTrackEntitiesChangedInRevisionEnabled() || this.options.isUseRevisionEntityWithNativeIdEnabled() && DefaultTrackingModifiedEntitiesRevisionEntity.class.isAssignableFrom(revisionInfoClass) || !this.options.isUseRevisionEntityWithNativeIdEnabled() && SequenceIdTrackingModifiedEntitiesRevisionEntity.class.isAssignableFrom(revisionInfoClass) || modifiedEntityNamesFound.isSet()) {
                timestampValueResolver = new RevisionTimestampValueResolver(revisionInfoClass, this.revisionInfoTimestampData, this.metadata.getMetadataBuildingOptions().getServiceRegistry());
                revisionInfoGenerator = new DefaultTrackingModifiedEntitiesRevisionInfoGenerator(this.revisionInfoEntityName, revisionInfoClass, revisionListenerClass, timestampValueResolver, this.modifiedEntityNamesData, this.metadata.getMetadataBuildingOptions().getServiceRegistry());
                this.auditMetadataBuilder.applyTrackEntitiesChangedInRevision(true);
                continue;
            }
            timestampValueResolver = new RevisionTimestampValueResolver(revisionInfoClass, this.revisionInfoTimestampData, this.metadata.getMetadataBuildingOptions().getServiceRegistry());
            revisionInfoGenerator = new DefaultRevisionInfoGenerator(this.revisionInfoEntityName, revisionInfoClass, revisionListenerClass, timestampValueResolver);
        }
        Document revisionInfoXmlMapping = null;
        Class<? extends RevisionListener> revisionListenerClass = this.getRevisionListenerClass(RevisionListener.class);
        if (revisionInfoGenerator == null) {
            if (this.options.isTrackEntitiesChangedInRevisionEnabled()) {
                revisionInfoClass = this.options.isUseRevisionEntityWithNativeIdEnabled() ? DefaultTrackingModifiedEntitiesRevisionEntity.class : SequenceIdTrackingModifiedEntitiesRevisionEntity.class;
                this.revisionInfoEntityName = revisionInfoClass.getName();
                timestampValueResolver = new RevisionTimestampValueResolver(revisionInfoClass, this.revisionInfoTimestampData, this.metadata.getMetadataBuildingOptions().getServiceRegistry());
                revisionInfoGenerator = new DefaultTrackingModifiedEntitiesRevisionInfoGenerator(this.revisionInfoEntityName, revisionInfoClass, revisionListenerClass, timestampValueResolver, this.modifiedEntityNamesData, this.metadata.getMetadataBuildingOptions().getServiceRegistry());
            } else {
                revisionInfoClass = this.options.isUseRevisionEntityWithNativeIdEnabled() ? DefaultRevisionEntity.class : SequenceIdRevisionEntity.class;
                timestampValueResolver = new RevisionTimestampValueResolver(revisionInfoClass, this.revisionInfoTimestampData, this.metadata.getMetadataBuildingOptions().getServiceRegistry());
                revisionInfoGenerator = new DefaultRevisionInfoGenerator(this.revisionInfoEntityName, revisionInfoClass, revisionListenerClass, timestampValueResolver);
            }
            revisionInfoXmlMapping = this.generateDefaultRevisionInfoXmlMapping();
        }
        this.auditMetadataBuilder.applyRevisionInfoEntityName(this.revisionInfoEntityName);
        return new RevisionInfoConfiguration(revisionInfoGenerator, revisionInfoXmlMapping, new RevisionInfoQueryCreator(this.revisionInfoEntityName, this.revisionInfoIdData.getName(), timestampValueResolver), this.generateRevisionInfoRelationMapping(), new RevisionInfoNumberReader(revisionInfoClass, this.revisionInfoIdData, this.metadata.getMetadataBuildingOptions().getServiceRegistry()), this.options.isTrackEntitiesChangedInRevisionEnabled() ? new ModifiedEntityNamesReader(revisionInfoClass, this.modifiedEntityNamesData, this.metadata.getMetadataBuildingOptions().getServiceRegistry()) : null, this.revisionInfoEntityName, revisionInfoClass, this.revisionInfoTimestampData);
    }

    private void searchForRevisionInfoCfgInProperties(XClass clazz, PersistentClass persistentClass, ReflectionManager reflectionManager, MutableBoolean revisionNumberFound, MutableBoolean revisionTimestampFound, MutableBoolean modifiedEntityNamesFound, String accessType) {
        for (XProperty property : clazz.getDeclaredProperties(accessType)) {
            RevisionNumber revisionNumber = (RevisionNumber)property.getAnnotation(RevisionNumber.class);
            RevisionTimestamp revisionTimestamp = (RevisionTimestamp)property.getAnnotation(RevisionTimestamp.class);
            ModifiedEntityNames modifiedEntityNames = (ModifiedEntityNames)property.getAnnotation(ModifiedEntityNames.class);
            if (revisionNumber != null) {
                if (revisionNumberFound.isSet()) {
                    throw new MappingException("Only one property may be annotated with @RevisionNumber!");
                }
                XClass revisionNumberClass = property.getType();
                if (reflectionManager.equals(revisionNumberClass, Integer.class) || reflectionManager.equals(revisionNumberClass, Integer.TYPE)) {
                    this.revisionInfoIdData = new PropertyData(property.getName(), property.getName(), accessType);
                    revisionNumberFound.set();
                } else if (reflectionManager.equals(revisionNumberClass, Long.class) || reflectionManager.equals(revisionNumberClass, Long.TYPE)) {
                    this.revisionInfoIdData = new PropertyData(property.getName(), property.getName(), accessType);
                    revisionNumberFound.set();
                    this.revisionPropType = StandardSpiBasicTypes.LONG;
                } else {
                    throw new MappingException("The field annotated with @RevisionNumber must be of type int, Integer, long or Long");
                }
                Column revisionPropColumn = (Column)property.getAnnotation(Column.class);
                if (revisionPropColumn != null) {
                    this.revisionPropColumnDefinition = revisionPropColumn.columnDefinition();
                }
            }
            if (revisionTimestamp != null) {
                if (revisionTimestampFound.isSet()) {
                    throw new MappingException("Only one property may be annotated with @RevisionTimestamp!");
                }
                if (this.isValidTimestampProperty(property.getType(), reflectionManager)) {
                    Property value = persistentClass.getProperty(property.getName());
                    this.revisionInfoTimestampData = new RevisionTimestampData(property.getName(), property.getName(), accessType, value.getValueMapping().getJavaTypeMapping().getJavaTypeDescriptor());
                    revisionTimestampFound.set();
                } else {
                    throw new MappingException("The field annotated with @RevisionTimestamp must be of type long, Long, LocalDateTime, java.util.Date or java.sql.Date");
                }
            }
            if (modifiedEntityNames == null) continue;
            if (modifiedEntityNamesFound.isSet()) {
                throw new MappingException("Only one property may be annotated with @ModifiedEntityNames!");
            }
            XClass modifiedEntityNamesClass = property.getType();
            if (reflectionManager.equals(modifiedEntityNamesClass, Set.class) && reflectionManager.equals(property.getElementClass(), String.class)) {
                this.modifiedEntityNamesData = new PropertyData(property.getName(), property.getName(), accessType);
                modifiedEntityNamesFound.set();
                continue;
            }
            throw new MappingException("The field annotated with @ModifiedEntityNames must be of Set<String> type.");
        }
    }

    private void searchForRevisionInfoCfg(XClass clazz, PersistentClass persistentClass, ReflectionManager reflectionManager, MutableBoolean revisionNumberFound, MutableBoolean revisionTimestampFound, MutableBoolean modifiedEntityNamesFound) {
        XClass superclazz = clazz.getSuperclass();
        if (!"java.lang.Object".equals(superclazz.getName())) {
            this.searchForRevisionInfoCfg(superclazz, persistentClass, reflectionManager, revisionNumberFound, revisionTimestampFound, modifiedEntityNamesFound);
        }
        this.searchForRevisionInfoCfgInProperties(clazz, persistentClass, reflectionManager, revisionNumberFound, revisionTimestampFound, modifiedEntityNamesFound, "field");
        this.searchForRevisionInfoCfgInProperties(clazz, persistentClass, reflectionManager, revisionNumberFound, revisionTimestampFound, modifiedEntityNamesFound, "property");
    }

    private boolean isValidTimestampProperty(XClass revisionTimestampClass, ReflectionManager reflectionManager) {
        return reflectionManager.equals(revisionTimestampClass, Long.class) || reflectionManager.equals(revisionTimestampClass, Long.TYPE) || reflectionManager.equals(revisionTimestampClass, java.util.Date.class) || reflectionManager.equals(revisionTimestampClass, Date.class) || reflectionManager.equals(revisionTimestampClass, LocalDateTime.class);
    }

    private Class<? extends RevisionListener> getRevisionListenerClass(Class<? extends RevisionListener> defaultListener) {
        if (this.options.getRevisionListenerClass() != null) {
            return this.options.getRevisionListenerClass();
        }
        return defaultListener;
    }

    private Document generateDefaultRevisionInfoXmlMapping() {
        Document document = this.xmlHelper.getDocumentFactory().createDocument();
        Element classMapping = MetadataTools.createEntity(document, new AuditTableData(null, null, this.options.getDefaultSchemaName(), this.options.getDefaultCatalogName()), null, null);
        classMapping.addAttribute("name", this.revisionInfoEntityName);
        classMapping.addAttribute("table", "REVINFO");
        Element idProperty = MetadataTools.addNativelyGeneratedId(classMapping, this.revisionInfoIdData.getName(), this.revisionPropType.getJavaTypeDescriptor().getTypeName(), this.options.isUseRevisionEntityWithNativeIdEnabled());
        MetadataTools.addColumn(idProperty, "REV", null, null, null, null, null, null, false);
        Element timestampProperty = MetadataTools.addProperty(classMapping, this.revisionInfoTimestampData.getName(), this.revisionInfoTimestampData.getJavaTypeDescriptor().getTypeName(), true, false);
        MetadataTools.addColumn(timestampProperty, "REVTSTMP", null, null, null, null, null, null, false);
        if (this.options.isTrackEntitiesChangedInRevisionEnabled()) {
            this.generateEntityNamesTrackingTableMapping(classMapping, "modifiedEntityNames", this.options.getDefaultSchemaName(), this.options.getDefaultCatalogName(), "REVCHANGES", "REV", "ENTITYNAME", "string");
        }
        return document;
    }

    private void generateEntityNamesTrackingTableMapping(Element classMapping, String propertyName, String joinTableSchema, String joinTableCatalog, String joinTableName, String joinTablePrimaryKeyColumnName, String joinTableValueColumnName, String joinTableValueColumnType) {
        Element set = classMapping.addElement("set");
        set.addAttribute("name", propertyName);
        set.addAttribute("table", joinTableName);
        set.addAttribute("schema", joinTableSchema);
        set.addAttribute("catalog", joinTableCatalog);
        set.addAttribute("cascade", "persist, delete");
        set.addAttribute("fetch", "join");
        set.addAttribute("lazy", "false");
        Element key = set.addElement("key");
        key.addAttribute("column", joinTablePrimaryKeyColumnName);
        Element element = set.addElement("element");
        element.addAttribute("type", joinTableValueColumnType);
        Element column = element.addElement("column");
        column.addAttribute("name", joinTableValueColumnName);
    }

    private Element generateRevisionInfoRelationMapping() {
        Document document = this.xmlHelper.getDocumentFactory().createDocument();
        Element revRelMapping = document.addElement("key-many-to-one");
        revRelMapping.addAttribute("type", this.getBasicTypeSqlType(this.revisionPropType));
        revRelMapping.addAttribute("class", this.revisionInfoEntityName);
        if (this.revisionPropColumnDefinition != null) {
            MetadataTools.addColumn(revRelMapping, "*", null, null, null, this.revisionPropColumnDefinition, null, null, false);
        }
        return revRelMapping;
    }

    private String getBasicTypeSqlType(BasicType basicType) {
        int sqlType = basicType.getSqlTypeDescriptor().getJdbcTypeCode();
        return this.metadata.getDatabase().getDialect().getTypeName(sqlType);
    }
}

