/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata;

import java.util.Properties;
import javax.persistence.EnumType;
import org.dom4j.Element;
import org.hibernate.boot.model.domain.ValueMapping;
import org.hibernate.envers.configuration.internal.metadata.MetadataTools;
import org.hibernate.envers.configuration.internal.metadata.reader.PropertyAuditingData;
import org.hibernate.envers.internal.entities.mapper.SimpleMapperBuilder;
import org.hibernate.mapping.BasicValue;
import org.hibernate.type.descriptor.sql.spi.IntegerSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;

public final class BasicMetadataGenerator {
    private static final String ENUM = "enumClass";
    private static final String NAMED = "useNamed";
    private static final String TYPE = "type";

    boolean addBasic(Element parent, PropertyAuditingData propertyAuditingData, ValueMapping value, SimpleMapperBuilder mapper, boolean insertable, boolean key) {
        if (value instanceof BasicValue) {
            BasicValue basicValue = (BasicValue)value;
            if (parent != null) {
                Element propMapping = this.buildProperty(parent, propertyAuditingData, basicValue, insertable, key);
                if (this.isAddNestedType(basicValue)) {
                    this.applyNestedType(basicValue, propMapping);
                }
            }
            if (mapper != null) {
                mapper.add(propertyAuditingData.resolvePropertyData(value.getJavaTypeMapping().getJavaTypeDescriptor()));
            }
            return true;
        }
        return false;
    }

    private void mapEnumerationValue(Element parent, BasicValue value, Properties parameters) {
        SqlTypeDescriptor descriptor;
        String enumClass = parameters.getProperty(ENUM) != null ? parameters.getProperty(ENUM) : value.getJavaTypeMapping().getTypeName();
        parent.addElement("param").addAttribute("name", ENUM).setText(enumClass);
        String useNamed = parameters.getProperty(NAMED) != null ? parameters.getProperty(NAMED) : ((descriptor = value.getResolution().getValueMapper().getSqlExpressableType().getSqlTypeDescriptor()).equals(IntegerSqlDescriptor.INSTANCE) ? "false" : "true");
        parent.addElement("param").addAttribute("name", NAMED).setText(useNamed);
    }

    boolean addManyToOne(Element parent, PropertyAuditingData propertyAuditingData, ValueMapping value, SimpleMapperBuilder mapper) {
        Element manyToOneElement = parent.addElement(mapper != null ? "many-to-one" : "key-many-to-one");
        manyToOneElement.addAttribute("name", propertyAuditingData.getName());
        manyToOneElement.addAttribute("class", value.getJavaTypeMapping().getTypeName());
        if (mapper == null) {
            manyToOneElement.addAttribute("foreign-key", "none");
        }
        MetadataTools.addColumns(manyToOneElement, value.getMappedColumns());
        if (mapper != null) {
            mapper.add(propertyAuditingData.resolvePropertyData(value.getJavaTypeMapping().getJavaTypeDescriptor()));
        }
        return true;
    }

    private boolean isAddNestedType(BasicValue basicValue) {
        return basicValue.getTypeParameters() != null;
    }

    private Element buildProperty(Element parent, PropertyAuditingData propertyAuditingData, BasicValue value, boolean insertable, boolean key) {
        Element propMapping = MetadataTools.addProperty(parent, propertyAuditingData.getName(), this.isAddNestedType(value) ? null : value.getJavaTypeMapping().getTypeName(), propertyAuditingData.isForceInsertable() || insertable, key);
        MetadataTools.addColumns(propMapping, value.getMappedColumns());
        return propMapping;
    }

    private void applyNestedType(BasicValue value, Element propertyMapping) {
        Properties typeParameters = value.getTypeParameters();
        Element typeMapping = propertyMapping.addElement(TYPE);
        String typeName = value.getJavaTypeMapping().getTypeName();
        typeMapping.addAttribute("name", typeName);
        if (EnumType.class.getName().equals(typeName)) {
            this.mapEnumerationValue(typeMapping, value, typeParameters);
        } else {
            for (Object object : typeParameters.keySet()) {
                String keyType = (String)object;
                String property = typeParameters.getProperty(keyType);
                if (property == null) continue;
                typeMapping.addElement("param").addAttribute("name", keyType).setText(property);
            }
        }
    }
}

