/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata;

import java.util.List;
import org.dom4j.Element;
import org.dom4j.tree.DefaultElement;
import org.hibernate.MappingException;
import org.hibernate.boot.model.domain.EmbeddedValueMapping;
import org.hibernate.boot.model.domain.PersistentAttributeMapping;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.envers.configuration.internal.metadata.AuditMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.reader.PropertyAuditingData;
import org.hibernate.envers.internal.entities.IdMappingData;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.SimpleMapperBuilder;
import org.hibernate.envers.internal.entities.mapper.id.AbstractIdMapper;
import org.hibernate.envers.internal.entities.mapper.id.EmbeddedIdMapper;
import org.hibernate.envers.internal.entities.mapper.id.MultipleIdMapper;
import org.hibernate.envers.internal.entities.mapper.id.SingleIdMapper;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;

public final class IdMetadataGenerator {
    private final AuditMetadataGenerator mainGenerator;

    IdMetadataGenerator(AuditMetadataGenerator auditMetadataGenerator) {
        this.mainGenerator = auditMetadataGenerator;
    }

    private boolean addIdProperties(Element parent, List<PersistentAttributeMapping> attributes, SimpleMapperBuilder mapper, boolean key, boolean audited) {
        for (PersistentAttributeMapping attribute : attributes) {
            if ("_identifierMapper".equals(attribute.getName())) continue;
            boolean added = false;
            added = attribute.getValueMapping() instanceof ManyToOne ? this.mainGenerator.getBasicMetadataGenerator().addManyToOne(parent, this.getIdPersistentPropertyAuditingData(attribute), attribute.getValueMapping(), mapper) : this.mainGenerator.getBasicMetadataGenerator().addBasic(parent, this.getIdPersistentPropertyAuditingData(attribute), attribute.getValueMapping(), mapper, true, key);
            if (added) continue;
            if (audited) {
                throw new MappingException("Property [" + attribute.getName() + " uses an unsupported type.");
            }
            return false;
        }
        return true;
    }

    IdMappingData addId(PersistentClass pc, boolean audited) {
        AbstractIdMapper mapper;
        DefaultElement relIdMapping = new DefaultElement("properties");
        DefaultElement origIdMapping = new DefaultElement("composite-id");
        PersistentAttributeMapping idProp = pc.getIdentifierAttributeMapping();
        EmbeddedValueMapping idMapper = pc.getEntityMappingHierarchy().getIdentifierEmbeddedValueMapping();
        if (idMapper == null && idProp == null) {
            return null;
        }
        if (idMapper != null) {
            Class componentClass = ReflectionTools.loadClass(((Component)pc.getIdentifier()).getEmbeddableClassName(), this.mainGenerator.getClassLoaderService());
            mapper = new MultipleIdMapper(componentClass, pc.getServiceRegistry());
            if (!this.addIdProperties((Element)relIdMapping, idMapper.getDeclaredPersistentAttributes(), (SimpleMapperBuilder)((Object)mapper), false, audited)) {
                return null;
            }
            if (!this.addIdProperties((Element)origIdMapping, idMapper.getDeclaredPersistentAttributes(), null, true, audited)) {
                return null;
            }
        } else if (Component.class.isInstance(idProp.getValueMapping())) {
            Component idComponent = (Component)idProp.getValueMapping();
            Class embeddableClass = ReflectionTools.loadClass(idComponent.getEmbeddableClassName(), this.mainGenerator.getClassLoaderService());
            mapper = new EmbeddedIdMapper(this.getIdPropertyData((Property)idProp), embeddableClass, pc.getServiceRegistry());
            if (!this.addIdProperties((Element)relIdMapping, idComponent.getDeclaredPersistentAttributes(), (SimpleMapperBuilder)((Object)mapper), false, audited)) {
                return null;
            }
            if (!this.addIdProperties((Element)origIdMapping, idComponent.getDeclaredPersistentAttributes(), null, true, audited)) {
                return null;
            }
        } else {
            mapper = new SingleIdMapper(pc.getServiceRegistry());
            this.mainGenerator.getBasicMetadataGenerator().addBasic((Element)relIdMapping, this.getIdPersistentPropertyAuditingData(idProp), idProp.getValueMapping(), (SimpleMapperBuilder)((Object)mapper), true, false);
            this.mainGenerator.getBasicMetadataGenerator().addBasic((Element)origIdMapping, this.getIdPersistentPropertyAuditingData(idProp), idProp.getValueMapping(), null, true, true);
        }
        origIdMapping.addAttribute("name", this.mainGenerator.getOptions().getOriginalIdPropName());
        this.mainGenerator.addRevisionInfoRelation((Element)origIdMapping);
        return new IdMappingData(mapper, (Element)origIdMapping, (Element)relIdMapping);
    }

    private PropertyData getIdPropertyData(Property property) {
        return new PropertyData(property.getName(), property.getName(), property.getPropertyAccessorName());
    }

    private PropertyAuditingData getIdPersistentPropertyAuditingData(PersistentAttributeMapping attributeMapping) {
        return new PropertyAuditingData(attributeMapping.getName(), attributeMapping.getPropertyAccessorName(), RelationTargetAuditMode.AUDITED, null, null, false);
    }
}

