/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata;

import java.util.Iterator;
import java.util.List;
import javax.persistence.JoinColumn;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.hibernate.boot.model.relational.MappedColumn;
import org.hibernate.envers.configuration.internal.metadata.AuditTableData;
import org.hibernate.envers.configuration.internal.metadata.FormulaNotSupportedException;
import org.hibernate.envers.internal.tools.StringTools;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.Selectable;

public final class MetadataTools {
    private MetadataTools() {
    }

    public static Element addNativelyGeneratedId(Element parent, String name, String type, boolean useRevisionEntityWithNativeId) {
        Element idMapping = parent.addElement("id");
        idMapping.addAttribute("name", name).addAttribute("type", type);
        Element generatorMapping = idMapping.addElement("generator");
        if (useRevisionEntityWithNativeId) {
            generatorMapping.addAttribute("class", "native");
        } else {
            generatorMapping.addAttribute("class", "org.hibernate.envers.enhanced.OrderedSequenceGenerator");
            generatorMapping.addElement("param").addAttribute("name", "sequence_name").setText("REVISION_GENERATOR");
            generatorMapping.addElement("param").addAttribute("name", "table_name").setText("REVISION_GENERATOR");
            generatorMapping.addElement("param").addAttribute("name", "initial_value").setText("1");
            generatorMapping.addElement("param").addAttribute("name", "increment_size").setText("1");
        }
        return idMapping;
    }

    public static Element addProperty(Element parent, String name, String type, boolean insertable, boolean updateable, boolean key) {
        Element propMapping;
        if (key) {
            propMapping = parent.addElement("key-property");
        } else {
            propMapping = parent.addElement("property");
            propMapping.addAttribute("insert", Boolean.toString(insertable));
            propMapping.addAttribute("update", Boolean.toString(updateable));
        }
        propMapping.addAttribute("name", name);
        if (type != null) {
            propMapping.addAttribute("type", type);
        }
        return propMapping;
    }

    public static Element addProperty(Element parent, String name, String type, boolean insertable, boolean key) {
        return MetadataTools.addProperty(parent, name, type, insertable, false, key);
    }

    public static Element addModifiedFlagProperty(Element parent, String propertyName, String suffix, String modifiedFlagName) {
        return MetadataTools.addProperty(parent, modifiedFlagName != null ? modifiedFlagName : MetadataTools.getModifiedFlagPropertyName(propertyName, suffix), "boolean", true, false, false);
    }

    public static String getModifiedFlagPropertyName(String propertyName, String suffix) {
        return propertyName + suffix;
    }

    private static void addOrModifyAttribute(Element parent, String name, String value) {
        Attribute attribute = parent.attribute(name);
        if (attribute == null) {
            parent.addAttribute(name, value);
        } else {
            attribute.setValue(value);
        }
    }

    public static Element addOrModifyColumn(Element parent, String name) {
        Element columnMapping = parent.element("column");
        if (columnMapping == null) {
            return MetadataTools.addColumn(parent, name, null, null, null, null, null, null);
        }
        if (!StringTools.isEmpty(name)) {
            MetadataTools.addOrModifyAttribute(columnMapping, "name", name);
        }
        return columnMapping;
    }

    public static Element addColumn(Element parent, String name, Long length, Integer scale, Integer precision, String sqlType, String customRead, String customWrite) {
        return MetadataTools.addColumn(parent, name, length, scale, precision, sqlType, customRead, customWrite, false);
    }

    public static Element addColumn(Element parent, String name, Long length, Integer scale, Integer precision, String sqlType, String customRead, String customWrite, boolean quoted) {
        Element columnMapping = parent.addElement("column");
        columnMapping.addAttribute("name", quoted ? "`" + name + "`" : name);
        if (length != null) {
            columnMapping.addAttribute("length", length.toString());
        }
        if (scale != null) {
            columnMapping.addAttribute("scale", Integer.toString(scale));
        }
        if (precision != null) {
            columnMapping.addAttribute("precision", Integer.toString(precision));
        }
        if (!StringTools.isEmpty(sqlType)) {
            columnMapping.addAttribute("sql-type", MetadataTools.getColumnSqlTypeFromColumnDefinition(sqlType));
        }
        if (!StringTools.isEmpty(customRead)) {
            columnMapping.addAttribute("read", customRead);
        }
        if (!StringTools.isEmpty(customWrite)) {
            columnMapping.addAttribute("write", customWrite);
        }
        return columnMapping;
    }

    private static String getColumnSqlTypeFromColumnDefinition(String sqlType) {
        String[] tokens;
        if (!StringTools.isEmpty(sqlType) && (tokens = StringHelper.split(" ", sqlType)).length >= 1) {
            return tokens[0];
        }
        return null;
    }

    private static Element createEntityCommon(Document document, String type, AuditTableData auditTableData, String discriminatorValue, Boolean isAbstract) {
        Element hibernateMapping = document.addElement("hibernate-mapping");
        hibernateMapping.addAttribute("auto-import", "false");
        Element classMapping = hibernateMapping.addElement(type);
        if (auditTableData.getAuditEntityName() != null) {
            classMapping.addAttribute("entity-name", auditTableData.getAuditEntityName());
        }
        if (discriminatorValue != null) {
            classMapping.addAttribute("discriminator-value", discriminatorValue);
        }
        if (!StringTools.isEmpty(auditTableData.getAuditTableName())) {
            classMapping.addAttribute("table", auditTableData.getAuditTableName());
        }
        if (!StringTools.isEmpty(auditTableData.getSchema())) {
            classMapping.addAttribute("schema", auditTableData.getSchema());
        }
        if (!StringTools.isEmpty(auditTableData.getCatalog())) {
            classMapping.addAttribute("catalog", auditTableData.getCatalog());
        }
        if (isAbstract != null) {
            classMapping.addAttribute("abstract", isAbstract.toString());
        }
        return classMapping;
    }

    public static Element createEntity(Document document, AuditTableData auditTableData, String discriminatorValue, Boolean isAbstract) {
        return MetadataTools.createEntityCommon(document, "class", auditTableData, discriminatorValue, isAbstract);
    }

    public static Element createSubclassEntity(Document document, String subclassType, AuditTableData auditTableData, String extendsEntityName, String discriminatorValue, Boolean isAbstract) {
        Element classMapping = MetadataTools.createEntityCommon(document, subclassType, auditTableData, discriminatorValue, isAbstract);
        classMapping.addAttribute("extends", extendsEntityName);
        return classMapping;
    }

    public static Element createJoin(Element parent, String tableName, String schema, String catalog) {
        Element joinMapping = parent.addElement("join");
        joinMapping.addAttribute("table", tableName);
        if (!StringTools.isEmpty(schema)) {
            joinMapping.addAttribute("schema", schema);
        }
        if (!StringTools.isEmpty(catalog)) {
            joinMapping.addAttribute("catalog", catalog);
        }
        return joinMapping;
    }

    @Deprecated
    public static void addColumns(Element anyMapping, Iterator selectables) {
        while (selectables.hasNext()) {
            Selectable selectable = (Selectable)selectables.next();
            if (selectable.isFormula()) {
                throw new FormulaNotSupportedException();
            }
            MetadataTools.addColumn(anyMapping, (Column)selectable);
        }
    }

    public static void addColumns(Element anyMapping, List<? extends MappedColumn> mappedColumns) {
        mappedColumns.forEach(column -> {
            if (column.isFormula()) {
                throw new FormulaNotSupportedException();
            }
            MetadataTools.addColumn(anyMapping, (Column)column);
        });
    }

    public static void addColumn(Element anyMapping, Column column) {
        MetadataTools.addColumn(anyMapping, column.getName().getText(), column.getLength(), column.getScale(), column.getPrecision(), column.getSqlType(), column.getCustomRead(), column.getCustomWrite(), column.isQuoted());
    }

    private static void changeNamesInColumnElement(Element element, ColumnNameIterator columnNameIterator) {
        Iterator properties = element.elementIterator();
        while (properties.hasNext()) {
            Attribute nameAttr;
            Element property = (Element)properties.next();
            if (!"column".equals(property.getName()) || (nameAttr = property.attribute("name")) == null) continue;
            nameAttr.setText((String)columnNameIterator.next());
        }
    }

    public static void prefixNamesInPropertyElement(Element element, String prefix, ColumnNameIterator columnNameIterator, boolean changeToKey, boolean insertable) {
        Iterator properties = element.elementIterator();
        while (properties.hasNext()) {
            Element property = (Element)properties.next();
            if (!"property".equals(property.getName()) && !"many-to-one".equals(property.getName())) continue;
            Attribute nameAttr = property.attribute("name");
            if (nameAttr != null) {
                nameAttr.setText(prefix + nameAttr.getText());
            }
            MetadataTools.changeNamesInColumnElement(property, columnNameIterator);
            if (changeToKey) {
                property.setName("key-" + property.getName());
                if (property.getName().equals("key-many-to-one")) {
                    Attribute foreignKey = property.attribute("foreign-key");
                    if (foreignKey == null) {
                        property.addAttribute("foreign-key", "none");
                    } else {
                        foreignKey.setValue("none");
                    }
                }
            }
            if (!"property".equals(property.getName())) continue;
            Attribute insert = property.attribute("insert");
            insert.setText(Boolean.toString(insertable));
        }
    }

    public static void addFormula(Element element, Formula formula) {
        element.addElement("formula").setText(formula.getText());
    }

    @Deprecated
    public static void addColumnsOrFormulas(Element element, Iterator columnIterator) {
        while (columnIterator.hasNext()) {
            Object o = columnIterator.next();
            if (o instanceof Column) {
                MetadataTools.addColumn(element, (Column)o);
                continue;
            }
            if (!(o instanceof Formula)) continue;
            MetadataTools.addFormula(element, (Formula)o);
        }
    }

    public static void addColumnsOrFormulas(Element element, List<MappedColumn> columns) {
        columns.forEach(column -> {
            if (column instanceof Column) {
                MetadataTools.addColumn(element, (Column)column);
            } else if (column instanceof Formula) {
                MetadataTools.addFormula(element, (Formula)column);
            }
        });
    }

    @Deprecated
    public static ColumnNameIterator getColumnNameIterator(final Iterator<Selectable> selectableIterator) {
        return new ColumnNameIterator(){

            @Override
            public boolean hasNext() {
                return selectableIterator.hasNext();
            }

            @Override
            public String next() {
                Selectable next = (Selectable)selectableIterator.next();
                if (next.isFormula()) {
                    throw new FormulaNotSupportedException();
                }
                return ((Column)next).getName().getText();
            }

            @Override
            public void remove() {
                selectableIterator.remove();
            }
        };
    }

    public static ColumnNameIterator getColumnNameIterator(final List<MappedColumn> columns) {
        return new ColumnNameIterator(){
            private Iterator<MappedColumn> selectableIterator;
            {
                this.selectableIterator = columns.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.selectableIterator.hasNext();
            }

            @Override
            public String next() {
                MappedColumn next = this.selectableIterator.next();
                if (next.isFormula()) {
                    throw new FormulaNotSupportedException();
                }
                return ((Column)next).getName().getText();
            }

            @Override
            public void remove() {
                this.selectableIterator.remove();
            }
        };
    }

    public static ColumnNameIterator getColumnNameIterator(final JoinColumn[] joinColumns) {
        return new ColumnNameIterator(){
            int counter;

            @Override
            public boolean hasNext() {
                return this.counter < joinColumns.length;
            }

            @Override
            public String next() {
                return joinColumns[this.counter++].name();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static abstract class ColumnNameIterator
    implements Iterator<String> {
    }
}

